/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.tariff.voice.table;

import java.util.Iterator;
import javax.swing.Icon;
import ru.bitel.bgbilling.client.common.table.tree.TreeNode;
import ru.bitel.bgbilling.client.util.ClientUtils;

public class CodeNode
extends TreeNode<CodeNode> {
    protected static final Icon leafIcon = ClientUtils.getIcon("eath");
    protected static final Icon folderIcon = ClientUtils.getIcon("folder");
    public String prefix;
    public String dest;
    public int destId;
    public String levelStart;
    public String levelEnd;

    @Override
    public Object getValueAt(int column) {
        switch (column) {
            case 0: {
                return this.prefix + " " + this.dest;
            }
            case 1: {
                return this.levelStart;
            }
            case 2: {
                return this.levelEnd;
            }
        }
        return null;
    }

    public String toString() {
        return this.prefix + " " + this.dest;
    }

    @Override
    public Icon getIcon() {
        if (this.folder) {
            return folderIcon;
        }
        return leafIcon;
    }

    public void removeFromParent() {
        CodeNode parent = (CodeNode)this.getParent();
        if (parent != null) {
            int i = parent.removeChild(this);
            if (this.child != null) {
                parent.insertChilds(i, this.child);
            }
        }
    }

    public CodeNode findParentNode(String prefix) {
        CodeNode result = this;
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            CodeNode node = (CodeNode)this.getChild(i);
            if (!prefix.startsWith(node.prefix)) continue;
            result = node.findParentNode(prefix);
            break;
        }
        return result;
    }

    public void insertCodeNode(CodeNode node) {
        if (this.child == null) {
            this.addChild(node);
        } else {
            Iterator iter = this.child.iterator();
            while (iter.hasNext()) {
                CodeNode n = (CodeNode)iter.next();
                if (!n.prefix.startsWith(node.prefix)) continue;
                iter.remove();
                node.addChild(n);
            }
            int i = 0;
            for (CodeNode n : this.child) {
                if (n.prefix.compareTo(node.prefix) > 0) {
                    this.child.add(i, node);
                    node.setParent(this);
                    return;
                }
                ++i;
            }
            this.addChild(node);
        }
    }
}

