/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.license.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.LicenseData;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.LicenseDataDTO;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.LicenseItemData;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.Storage;
import ru.bitel.bgbilling.kernel.admin.license.common.service.LicenseService;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public final class LicViewAgent
extends BGTabPanel {
    public static final String TAB_ID = "licviewAgent";
    private boolean init = false;
    private JPopupMenu popupMenu = null;
    private ErrorPanel errorPanel = new ErrorPanel();
    private DetailTableModel tableModel = new DetailTableModel(LicViewAgent.class.getName());
    private LicDetailTable table = new LicDetailTable(this.tableModel);
    private LocalListTableModel listTableModel = new LocalListTableModel();
    private BGUTable listTable = new BGUTable(this.listTableModel);
    private LicenseService licenseService = null;

    public LicViewAgent() {
        super(TAB_ID, "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0439");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
        this.setData();
    }

    private void init() {
        if (!this.init) {
            try {
                this.getLicenseService().init();
                this.errorPanel.setVisible(false);
                this.init = true;
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
                this.errorPanel.setErrorText(ex.getMessage());
                this.errorPanel.setVisible(true);
            }
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, this.getListPanel(), (Component)this.getDetailPanel(), 1000L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getListPanel() {
        this.listTable.setSelectionMode(0);
        BGSwingUtilites.handleMouseClicked(this.listTable, e -> this.listTableMouseClicked((MouseEvent)e));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.listTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.errorPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void listTableMouseClicked(MouseEvent event) {
        if (this.getPopupMenu() != null && SwingUtilities.isRightMouseButton(event) && this.listTable.getSelectedRow() == this.listTable.rowAtPoint(event.getPoint())) {
            this.getPopupMenu().show(this.listTable, event.getX(), event.getY());
        } else if (event.getClickCount() == 2) {
            this.showLicenseDetail();
        }
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            ActionListener menuActionListener = e -> {
                String actionCommand = e.getActionCommand();
                if ("showLicenseDetail".equals(actionCommand)) {
                    this.showLicenseDetail();
                } else if ("loadLicense".equals(actionCommand)) {
                    this.loadLicense();
                } else if ("deleteLicense".equals(actionCommand)) {
                    this.deleteLicense();
                } else if ("activateLicense".equals(actionCommand)) {
                    this.activateLicense();
                }
            };
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(new LicMenuItem("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0438 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e", "activateLicense", menuActionListener));
            this.popupMenu.add(new LicMenuItem("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u0441\u043e\u0441\u0442\u0430\u0432\u0430 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438", "showLicenseDetail", menuActionListener));
            this.popupMenu.add(new LicMenuItem("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c/\u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e", "loadLicense", menuActionListener));
            this.popupMenu.add(new LicMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e \u0438\u0437 \u0431\u0430\u0437\u044b", "deleteLicense", menuActionListener));
        }
        return this.popupMenu;
    }

    private void activateLicense() {
        LicenseDataDTO licenseData = (LicenseDataDTO)this.listTableModel.getSelectedRow();
        if (licenseData != null) {
            try {
                this.getLicenseService().licenseDataActivate(licenseData.getId());
                this.loadLicenseList();
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }
    }

    private void deleteLicense() {
        LicenseDataDTO licenseData = (LicenseDataDTO)this.listTableModel.getSelectedRow();
        if (licenseData != null) {
            try {
                this.getLicenseService().licenseDataDelete(licenseData.getId());
                this.loadLicenseList();
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }
    }

    private void loadLicense() {
        LicenseDataDTO licenseData = (LicenseDataDTO)this.listTableModel.getSelectedRow();
        if (licenseData != null) {
            try {
                this.getLicenseService().licenseDataLoad(licenseData.getId());
                this.loadLicenseList();
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }
    }

    private void showLicenseDetail() {
        LicenseDataDTO licenseDataDTO = (LicenseDataDTO)this.listTableModel.getSelectedRow();
        if (licenseDataDTO != null) {
            try {
                if (licenseDataDTO.getId() > 0 && !licenseDataDTO.isActive()) {
                    LicenseData licenseData = this.getLicenseService().licenseDataGet(licenseDataDTO.getId());
                    if (licenseData.getPlainData() != null) {
                        ArrayList<LicenseItemData> list = new ArrayList<LicenseItemData>();
                        JSONArray licenseItems = new JSONArray(licenseData.getPlainData());
                        for (Object licenseItem : licenseItems) {
                            JSONObject licenseItemJson = (JSONObject)licenseItem;
                            list.add(LicenseItemData.builder().setTitle(licenseItemJson.getString("name")).setCount("0:" + licenseItemJson.getString("count")).setDate(licenseItemJson.getString("date")).build());
                        }
                        Collections.sort(list, (o1, o2) -> o1.getTitle().compareTo(o2.getTitle()));
                        this.tableModel.setData(list);
                    }
                } else {
                    this.tableModel.setData(this.getLicenseService().currentLicenseList());
                }
                this.loadLicenseList();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    private JPanel getDetailPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0421\u043e\u0441\u0442\u0430\u0432 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    @Override
    public void setData() {
        this.init();
        try {
            this.tableModel.setData(this.getLicenseService().currentLicenseList());
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
        this.loadLicenseList();
    }

    private void loadLicenseList() {
        LicenseDataDTO licenseData = (LicenseDataDTO)this.listTableModel.getSelectedRow();
        try {
            this.listTableModel.setData(this.getLicenseService().licenseDataList());
            if (licenseData == null) {
                for (LicenseDataDTO rowLicenseData : this.listTableModel.getRows()) {
                    if (!rowLicenseData.isActive()) continue;
                    licenseData = rowLicenseData;
                    break;
                }
            }
            if (licenseData == null) {
                for (LicenseDataDTO rowLicenseData : this.listTableModel.getRows()) {
                    if (!rowLicenseData.getStorage().equals((Object)Storage.FILE)) continue;
                    licenseData = rowLicenseData;
                    break;
                }
            }
            if (licenseData == null && this.listTableModel.getRowCount() > 0) {
                licenseData = (LicenseDataDTO)this.listTableModel.getRows().get(0);
            }
            if (licenseData != null) {
                this.listTableModel.setSelectedRow(licenseData);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private LicenseService getLicenseService() {
        if (this.licenseService == null) {
            this.licenseService = this.getContext().getPort(LicenseService.class);
        }
        return this.licenseService;
    }

    class ErrorPanel
    extends JPanel {
        private static final String errorText = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0439, \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 (\u041c\u0435\u043d\u044e -> \u0421\u0435\u0440\u0432\u0438\u0441 -> \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 -> \u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f):\nlicense.server.url=https://license.bitel.ru/license\nlicense.contract.title=B7XXX-YY\nlicense.contract.password=<\u043f\u0430\u0440\u043e\u043b\u044c \u043e\u0442 \u041b\u041a>\n";
        private JTextArea errorMessage = new JTextArea(10, 50);

        public ErrorPanel() {
            this.errorMessage.setEditable(false);
            this.errorMessage.setMargin(new Insets(5, 5, 5, 5));
            this.errorMessage.setFont(new Font("SansSerif", 1, 12));
            this.errorMessage.setForeground(Color.WHITE);
            this.errorMessage.setBackground(new Color(255, 128, 128));
            this.errorMessage.setLineWrap(true);
            this.errorMessage.setWrapStyleWord(true);
            this.errorMessage.setText(errorText);
            this.setLayout(new GridBagLayout());
            this.add((Component)BGSwingUtilites.wrapScrollPane(this.errorMessage, 200, 200), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.setVisible(false);
        }

        void setErrorText(String message) {
            this.errorMessage.setText(errorText + (String)(message != null ? "\nERROR: " + message : ""));
        }
    }

    class DetailTableModel
    extends BGTableModel<LicenseItemData> {
        public DetailTableModel(String name) {
            super(name, LicenseItemData.class);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043e\u0434\u0443\u043b\u044f(\u043f\u043b\u0430\u0433\u0438\u043d\u0430)", 150, 150, -1, "title");
            this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0439", 150, 150, -1, "count");
            this.addColumn("\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u043e", 150, 150, 150, "date");
        }
    }

    class LicDetailTable
    extends BGUTable {
        DateCellRenderer dateCellRenderer;
        CountCellRenderer countCellRenderer;

        public LicDetailTable(TableModel model) {
            super(model);
            this.dateCellRenderer = new DateCellRenderer();
            this.countCellRenderer = new CountCellRenderer();
            this.setSelectionMode(0);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            TableCellRenderer tableCellRenderer = null;
            tableCellRenderer = "date".equals(LicViewAgent.this.tableModel.getIdentifier(column)) ? this.dateCellRenderer : ("count".equals(LicViewAgent.this.tableModel.getIdentifier(column)) ? this.countCellRenderer : super.getCellRenderer(row, column));
            return tableCellRenderer;
        }
    }

    class LocalListTableModel
    extends BGTableModel<LicenseDataDTO> {
        public LocalListTableModel() {
            super(LocalListTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u0430", 80, 80, 80, "active", true);
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", 150, 150, 150, "createDate", true);
            this.addColumn("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432", 100, 100, 100, "count", true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0425\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435", 100, 100, 100, "storage", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0425\u044d\u0448", 150, 150, -1, "hash", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(LicenseDataDTO value, int columnIndex) throws Exception {
            String identifier = this.getIdentifier(columnIndex);
            return "storage".equals(identifier) ? value.getStorage().getTitile() : super.getValue(value, columnIndex);
        }

        @Override
        public void setSelectedRows(List<LicenseDataDTO> selected) {
            ListSelectionModel selectionModel = this.table.getSelectionModel();
            selectionModel.clearSelection();
            selectionModel.setValueIsAdjusting(true);
            List rows = this.getRows();
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                int licenseId = ((LicenseDataDTO)rows.get(i)).getId();
                if (!selected.stream().anyMatch(a -> a.getId() == licenseId)) continue;
                if (this.table.getRowSorter() != null) {
                    int row = this.table.getRowSorter().convertRowIndexToView(i);
                    selectionModel.addSelectionInterval(row, row);
                    continue;
                }
                selectionModel.addSelectionInterval(i, i);
            }
            selectionModel.setValueIsAdjusting(false);
        }
    }

    class LicMenuItem
    extends JMenuItem {
        public LicMenuItem(String text, String actionCommand, ActionListener actionListener) {
            super(text);
            this.setActionCommand(actionCommand);
            this.addActionListener(actionListener);
        }
    }

    class CountCellRenderer
    extends DefaultTableCellRenderer {
        Color defaultBackgroundColor = UIManager.getColor("Table.background");
        Color defaultForegroundColor = UIManager.getColor("Table.foreground");

        public CountCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean expired = false;
            if (value instanceof String) {
                try {
                    String[] values = value.toString().split(":");
                    int cur = Integer.parseInt(values[0]);
                    int max = Integer.parseInt(values[1]);
                    StringBuilder builder = new StringBuilder().append(cur).append(" \u0438\u0437 ").append(max == 0 ? "\u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e" : String.valueOf(max)).append(" (").append(max == 0 ? "0" : String.valueOf(Math.round((float)cur / (float)max * 100.0f))).append("%)");
                    value = builder.toString();
                    expired = max != 0 && cur > max;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setBackground(expired ? Color.RED : this.defaultBackgroundColor);
            this.setForeground(expired ? Color.WHITE : this.defaultForegroundColor);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class DateCellRenderer
    extends DefaultTableCellRenderer {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        Color defaultBackgroundColor = UIManager.getColor("Table.background");
        Color defaultForegroundColor = UIManager.getColor("Table.foreground");

        public DateCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean expired = false;
            if (value instanceof String) {
                try {
                    Date date = this.dateFormat.parse(value.toString());
                    expired = date.getTime() < System.currentTimeMillis();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setBackground(expired ? Color.RED : this.defaultBackgroundColor);
            this.setForeground(expired ? Color.WHITE : this.defaultForegroundColor);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

