/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime.device;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.sa.ProtocolHandler;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ManagedBeanInfoManager;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContextThreadFactory;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadLocalEvent;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.worker.Destroyable;
import ru.bitel.common.worker.WorkerTask;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceRuntimeManager;

public class InetDeviceRuntimeMap
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private final int moduleId;
    private final InetApplication application;
    private ManagedBeanInfoManager<Object> beanInfoManager;
    private final boolean loadSaScripts;
    private final ConcurrentMap<Integer, AtomicReference<InetDeviceRuntime>> referenceMap = new ConcurrentHashMap<Integer, AtomicReference<InetDeviceRuntime>>();
    private volatile Map<Integer, InetDeviceRuntime> idMap;
    private Setup setup;
    private int rootDeviceId;

    public InetDeviceRuntimeMap(InetApplication application, boolean realtime, Setup setup, int moduleId, int rootDeviceId, boolean loadSaScripts) throws BGException {
        this.setup = setup;
        this.moduleId = moduleId;
        this.rootDeviceId = rootDeviceId;
        this.application = application;
        this.loadSaScripts = loadSaScripts;
        this.setup = setup;
        InetDeviceMap.getInstance(moduleId);
        if (realtime) {
            EventProcessor.getInstance().addListener((EventListener)this, InetReloadLocalEvent.class, moduleId, null);
        }
    }

    public void notify(Event e, EventListenerContext ctx) throws Exception {
        if (e instanceof InetReloadLocalEvent) {
            this.load(ctx.getConnection());
        }
    }

    public InetDeviceRuntime get(Integer id) {
        return this.idMap.get(id);
    }

    public AtomicReference<InetDeviceRuntime> getRef(Integer id) {
        return (AtomicReference)this.referenceMap.get(id);
    }

    public InetDeviceRuntime getAndLockSa(Integer id) {
        InetDeviceRuntime result = this.idMap.get(id);
        if (result == null) {
            throw new IllegalStateException("inetDeviceRuntime == null for id: " + id);
        }
        result.saInstances.lock();
        for (int i = 0; !(i >= 100 || result.saInstances != null && result.saInstances.isAlive()); ++i) {
            result.saInstances.unlock();
            result = this.idMap.get(id);
            result.saInstances.lock();
        }
        if (result.saInstances == null) {
            throw new IllegalStateException("saInstances == null");
        }
        if (!result.saInstances.isAlive()) {
            throw new IllegalStateException("saInstances == null");
        }
        return result;
    }

    public Collection<InetDeviceRuntime> values() {
        return this.idMap.values();
    }

    public Map<Integer, InetDeviceRuntime> getMap() {
        return this.idMap;
    }

    public synchronized void load(Connection con_) throws Exception {
        AbstractMap idMap;
        logger.info("(Re)loading InetDeviceRuntimeMap");
        this.beanInfoManager = new ManagedBeanInfoManager();
        Directory deviceTypeDir = ServerDirectoryFactory.newUnmodifiableDirectory(InetDeviceType.class, (Connection)con_, (int)this.moduleId, (boolean)false);
        Map deviceTypeMap = Id.newMap((List)deviceTypeDir.list());
        InetDeviceMap deviceMap = InetDeviceMap.getInstance(this.moduleId);
        InetDeviceMap.InetDeviceMapItem rootDevice = null;
        try {
            rootDevice = deviceMap.get(this.rootDeviceId);
        }
        catch (BGException e) {
            logger.error("Error rootDevice load.");
            throw e;
        }
        if (rootDevice == null || rootDevice.getDevice() == null) {
            throw new BGException("Not found rootDevice with id = " + this.rootDeviceId);
        }
        ArrayList<InetDevice> superRootList = new ArrayList<InetDevice>();
        if (rootDevice.getConfig().getInt("inetDeviceRuntimeMap.load.super", 0) > 0) {
            for (InetDeviceMap.InetDeviceMapItem parent = rootDevice.getParent(); parent != null && parent.getDevice() != null && parent.getDevice().getId() >= 0; parent = parent.getParent()) {
                superRootList.add(parent.getDevice());
            }
            Collections.reverse(superRootList);
        }
        IpResourceRuntimeManager ipResourceManager = this.application instanceof Access ? this.application.ipResourceManager : null;
        GregorianCalendar closePeriod = new GregorianCalendar();
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)closePeriod);
        Date closePeriodDate = closePeriod.getTime();
        long start = System.currentTimeMillis();
        int threadCount = rootDevice.getConfig().getInt("inetDeviceRuntimeMap.load.threadCount", 0);
        if (threadCount > 1) {
            idMap = new ConcurrentHashMap();
            ExecutorService executorService = Executors.newFixedThreadPool(threadCount, (ThreadFactory)new ServerContextThreadFactory(Setup.getSetup(), this.application.moduleId, "inetDevice-load", null));
            ReduceSemaphore reduceSemaphore = new ReduceSemaphore(1);
            for (InetDevice inetDevice : superRootList) {
                this.loadDevice(this.setup, this.moduleId, deviceMap, deviceTypeMap, ipResourceManager, idMap, inetDevice, null, this.loadSaScripts, closePeriodDate, false);
            }
            this.loadDevice(executorService, reduceSemaphore, this.setup, this.moduleId, deviceMap, deviceTypeMap, ipResourceManager, (ConcurrentMap)((Object)idMap), rootDevice.getDevice(), null, this.loadSaScripts, closePeriodDate);
            try {
                reduceSemaphore.tryAcquire(1L, TimeUnit.HOURS);
                executorService.shutdown();
                executorService.awaitTermination(1L, TimeUnit.HOURS);
            }
            catch (InterruptedException ex) {
                Thread.interrupted();
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            idMap = new HashMap<Integer, InetDeviceRuntime>(idMap);
        } else {
            idMap = new HashMap();
            for (InetDevice inetDevice : superRootList) {
                this.loadDevice(this.setup, this.moduleId, deviceMap, deviceTypeMap, ipResourceManager, idMap, inetDevice, null, this.loadSaScripts, closePeriodDate, false);
            }
            this.loadDevice(this.setup, this.moduleId, deviceMap, deviceTypeMap, ipResourceManager, idMap, rootDevice.getDevice(), null, this.loadSaScripts, closePeriodDate, true);
        }
        logger.info("Load inetDeviceRuntimeMap complete. Loaded " + idMap.size() + " inetDevices for " + (System.currentTimeMillis() - start) + " ms");
        HashMap<String, ArrayList<InetDeviceRuntime>> identifierMap = new HashMap<String, ArrayList<InetDeviceRuntime>>();
        for (InetDeviceRuntime deviceRuntime : idMap.values()) {
            String string = deviceRuntime.inetDevice.getIdentifier();
            if (!Utils.notBlankString((String)string)) continue;
            ArrayList<InetDeviceRuntime> list = (ArrayList<InetDeviceRuntime>)identifierMap.get(string);
            if (list == null) {
                list = new ArrayList<InetDeviceRuntime>(2);
                identifierMap.put(string, list);
            }
            list.add(deviceRuntime);
        }
        final Map<Integer, InetDeviceRuntime> map = this.idMap;
        this.idMap = idMap;
        for (InetDeviceRuntime inetDeviceRuntime : idMap.values()) {
            AtomicReference<InetDeviceRuntime> ref = (AtomicReference<InetDeviceRuntime>)this.referenceMap.get(inetDeviceRuntime.inetDeviceId);
            if (ref != null) {
                ref.set(inetDeviceRuntime);
                continue;
            }
            AtomicReference<InetDeviceRuntime> newRef = new AtomicReference<InetDeviceRuntime>(inetDeviceRuntime);
            ref = this.referenceMap.putIfAbsent(inetDeviceRuntime.inetDeviceId, newRef);
            if (ref == null) continue;
            ref.set(inetDeviceRuntime);
        }
        for (Map.Entry entry : this.referenceMap.entrySet()) {
            if (idMap.containsKey(entry.getKey())) continue;
            ((AtomicReference)entry.getValue()).set(null);
        }
        if (map != null) {
            new Thread(this, "deviceRntm-destroy"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    logger.info("Preparing to clean old SA instances");
                    for (InetDeviceRuntime deviceRuntime : map.values()) {
                        deviceRuntime.saInstances.lock();
                        deviceRuntime.saInstances.unlock();
                    }
                    logger.info("Clean old SA instances");
                    for (InetDeviceRuntime deviceRuntime : map.values()) {
                        deviceRuntime.saInstances.lock();
                        try {
                            deviceRuntime.saInstances.destroy();
                        }
                        finally {
                            deviceRuntime.saInstances.unlock();
                        }
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    logger.info("Clean old PH instances");
                    for (InetDeviceRuntime deviceRuntime : map.values()) {
                        ProtocolHandler protocolHandler = deviceRuntime.protocolHandler;
                        if (!(protocolHandler instanceof Destroyable)) continue;
                        try {
                            ((Destroyable)protocolHandler).destroy();
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }.start();
        }
    }

    private void loadDevice(final ExecutorService executorService, final ReduceSemaphore semaphore, final Setup setup, final int moduleId, final InetDeviceMap deviceMap, final Map<Integer, InetDeviceType> deviceTypeMap, final IpResourceRuntimeManager ipResourceManager, final ConcurrentMap<Integer, InetDeviceRuntime> map, final InetDevice inetDevice, final InetDeviceRuntime parentInstance, final boolean initScripts, final Date closePeriod) throws BGException {
        semaphore.reducePermits(1);
        executorService.execute((Runnable)new WorkerTask<ServerContext>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runImpl() throws Exception {
                try {
                    InetDeviceMap.InetDeviceMapItem item = deviceMap.get(inetDevice.getId());
                    if (item == null) {
                        if (inetDevice != null && inetDevice.getDateTo() != null && inetDevice.getDateTo().before(closePeriod)) {
                            return;
                        }
                        logger.error("Could not find InetDevice in InetDeviceMap with id=" + inetDevice.getId() + "!");
                        return;
                    }
                    int deviceTypeId = inetDevice.getDeviceTypeId();
                    InetDeviceType inetDeviceType = (InetDeviceType)deviceTypeMap.get(deviceTypeId);
                    if (inetDeviceType == null) {
                        inetDeviceType = (InetDeviceType)inetDevice.getDeviceType();
                    }
                    InetDeviceRuntime instance = new InetDeviceRuntime(setup, moduleId, inetDevice, inetDeviceType, parentInstance, item, InetDeviceRuntimeMap.this.beanInfoManager, item.getFlowAgentIfaceMap(), initScripts, ipResourceManager, InetDeviceRuntimeMap.this.application);
                    map.put(inetDevice.getId(), instance);
                    List children = inetDevice.getChildren();
                    if (children != null && children.size() > 0) {
                        for (InetDevice child : children) {
                            InetDeviceRuntimeMap.this.loadDevice(executorService, semaphore, setup, moduleId, deviceMap, deviceTypeMap, ipResourceManager, map, child, instance, initScripts, closePeriod);
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error("Error while loading device " + String.valueOf(inetDevice) + ": " + ex.getMessage(), (Throwable)ex);
                }
                finally {
                    semaphore.release();
                }
            }
        });
    }

    private void loadDevice(Setup setup, int moduleId, InetDeviceMap deviceMap, Map<Integer, InetDeviceType> deviceTypeMap, IpResourceRuntimeManager ipResourceManager, Map<Integer, InetDeviceRuntime> map, InetDevice inetDevice, InetDeviceRuntime parentInstance, boolean initScripts, Date closePeriod, boolean loadChildren) throws BGException {
        try {
            List children;
            InetDeviceMap.InetDeviceMapItem item = deviceMap.get(inetDevice.getId());
            if (item == null) {
                if (inetDevice != null && inetDevice.getDateTo() != null && inetDevice.getDateTo().before(closePeriod)) {
                    return;
                }
                logger.error("Could not find InetDevice in InetDeviceMap with id=" + inetDevice.getId() + "!");
                return;
            }
            int deviceTypeId = inetDevice.getDeviceTypeId();
            InetDeviceType inetDeviceType = deviceTypeMap.get(deviceTypeId);
            if (inetDeviceType == null) {
                inetDeviceType = (InetDeviceType)inetDevice.getDeviceType();
            }
            InetDeviceRuntime instance = new InetDeviceRuntime(setup, moduleId, inetDevice, inetDeviceType, parentInstance, item, this.beanInfoManager, item.getFlowAgentIfaceMap(), initScripts, ipResourceManager, this.application);
            map.put(inetDevice.getId(), instance);
            if (loadChildren && (children = inetDevice.getChildren()) != null && children.size() > 0) {
                for (InetDevice child : children) {
                    this.loadDevice(setup, moduleId, deviceMap, deviceTypeMap, ipResourceManager, map, child, instance, initScripts, closePeriod, loadChildren);
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error while loading device " + String.valueOf(inetDevice) + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    public Map<String, InetDeviceRuntime> getDescendantMap(InetDeviceRuntime parent) {
        Map<String, InetDeviceRuntime> descendantMap = parent.descendantMap;
        if (descendantMap == null) {
            descendantMap = new HashMap<String, InetDeviceRuntime>();
            for (Integer id : parent.descendantIds) {
                InetDeviceRuntime child = this.get(id);
                if (child == null) continue;
                String identifier = child.inetDevice.getIdentifier();
                if (identifier != null) {
                    descendantMap.put(identifier.toLowerCase(), child);
                    continue;
                }
                logger.error("Identifier is null");
            }
            parent.descendantMap = descendantMap;
        }
        return descendantMap;
    }

    public Map<Integer, InetDeviceRuntime> getDescendantSvlanMap(InetDeviceRuntime parent) {
        Map<Integer, InetDeviceRuntime> descendantSvlanMap = parent.descendantSvlanMap;
        if (descendantSvlanMap == null) {
            descendantSvlanMap = new HashMap<Integer, InetDeviceRuntime>();
            for (Integer id : parent.descendantIds) {
                int svlan;
                InetDeviceRuntime child = this.get(id);
                if (child == null || (svlan = child.inetDevice.getSvlan()) < 0) continue;
                descendantSvlanMap.put(svlan, child);
            }
            parent.descendantSvlanMap = descendantSvlanMap;
        }
        return descendantSvlanMap;
    }

    public InetDeviceRuntime getByIdentifier(InetDeviceRuntime ancestorDeviceRuntime, Object agentRemoteId) {
        Map<String, InetDeviceRuntime> descendantMap = this.getDescendantMap(ancestorDeviceRuntime = ancestorDeviceRuntime.getAgentDeviceRoot(this));
        if (descendantMap.size() == 0) {
            logger.debug("descendantMap.size() == 0");
            return null;
        }
        if (agentRemoteId instanceof String) {
            logger.debug("agentRemoteId instanceof String");
            return descendantMap.get(((String)agentRemoteId).toLowerCase());
        }
        if (agentRemoteId instanceof ByteBuffer) {
            logger.debug("agentRemoteId instanceof ByteBuffer");
            agentRemoteId = Utils.byteBufferAsArray((ByteBuffer)((ByteBuffer)agentRemoteId));
        }
        if (agentRemoteId instanceof byte[]) {
            byte[] agentRemoteIdBytes = (byte[])agentRemoteId;
            if (logger.isDebugEnabled()) {
                logger.debug("agentRemoteId instanceof byte[] = {}", (Object)Utils.bytesToString((byte[])agentRemoteIdBytes));
            }
            if (agentRemoteIdBytes.length > 1 && agentRemoteIdBytes[0] == 1 && (agentRemoteIdBytes[1] & 0xFF) == agentRemoteIdBytes.length - 2) {
                logger.debug("agentRemoteId found header (\u043f\u0435\u0440\u0432\u044b\u0435 \u0434\u0432\u0430 \u0431\u0430\u0439\u0442\u0430 \u043e\u0442\u0431\u0440\u0430\u0441\u044b\u0432\u0430\u0435\u043c)");
                byte[] agentRemoteIdBytes2 = new byte[agentRemoteIdBytes.length - 2];
                System.arraycopy(agentRemoteIdBytes, 2, agentRemoteIdBytes2, 0, agentRemoteIdBytes2.length);
                agentRemoteIdBytes = agentRemoteIdBytes2;
            }
            InetDeviceRuntime result = descendantMap.get(Utils.bytesToString((byte[])agentRemoteIdBytes, (boolean)false, null));
            if (logger.isDebugEnabled()) {
                logger.debug("descendantMap.get( Utils.bytesToString( agentRemoteIdBytes ) ) = {}", result == null ? null : "inetDeviceId#" + result.inetDeviceId);
            }
            if (result != null) {
                return result;
            }
            result = descendantMap.get(new String(agentRemoteIdBytes, StandardCharsets.UTF_8).toLowerCase());
            if (logger.isDebugEnabled()) {
                logger.debug("descendantMap.get( new String( agentRemoteIdBytes ) ) = {}", (Object)result);
            }
            return result;
        }
        return null;
    }

    public InetDeviceRuntime getBySvlan(InetDeviceRuntime ancestorDeviceRuntime, Object svlan) {
        Map<Integer, InetDeviceRuntime> descendantSvlanMap = this.getDescendantSvlanMap(ancestorDeviceRuntime = ancestorDeviceRuntime.getAgentDeviceRoot(this));
        if (descendantSvlanMap.size() == 0) {
            return null;
        }
        if (svlan instanceof Integer) {
            return descendantSvlanMap.get((Integer)svlan);
        }
        if (svlan instanceof Number) {
            return descendantSvlanMap.get(((Number)svlan).intValue());
        }
        if (svlan instanceof String) {
            if (((String)svlan).length() == 0) {
                return null;
            }
            return descendantSvlanMap.get(Utils.parseInt((String)((String)svlan), (int)-1));
        }
        if (svlan instanceof ByteBuffer) {
            svlan = Utils.byteBufferAsArray((ByteBuffer)((ByteBuffer)svlan));
        }
        if (svlan instanceof byte[]) {
            byte[] svlanBytes = (byte[])svlan;
            int svlanInt = InetUtils.parseInt(svlanBytes, 0, svlanBytes.length);
            if (svlanInt < 0) {
                return null;
            }
            return descendantSvlanMap.get(svlanInt);
        }
        return null;
    }

    static class ReduceSemaphore
    extends Semaphore {
        public ReduceSemaphore(int permits) {
            super(permits);
        }

        @Override
        public void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }
}

