/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSession;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLogAccount;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;

public class InetSessionLog
extends InetSession
implements Cloneable {
    private Date connectionStart;
    private long parentConnectionId;
    private String realm;
    private int contractId;
    private int servId;
    private int deviceId;
    private int devicePort;
    private int agentDeviceId;
    private String acctSessionId;
    private String username;
    private String calledStationId;
    private String callingStationId;
    private String circuitId;
    private int ipResourceId;
    private byte[] inetAddressBytes;
    private IpAddress inetAddress;
    private int prefixResourceId;
    private byte[] prefix;
    private short prefixLength;
    private int delegatedPrefixResourceId;
    private byte[] delegatedPrefix;
    private short delegatedPrefixLength;
    private List<IpNet> routeList;
    private int type;
    private int accessCode;
    private Set<Integer> deviceOptions;
    private Map<Integer, Long> trafficMap = new HashMap<Integer, Long>();
    private Map<Integer, InetSessionLogAccount> accountMap = new HashMap<Integer, InetSessionLogAccount>();
    private List<InetSessionLog> children;
    private String contractComment = "";
    private String contractTitle = "";
    private String serviceTitle = "";

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InetSessionLog other = (InetSessionLog)obj;
        return this.id == other.id && this.id == other.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public InetSessionLog() {
    }

    public InetSessionLog(InetConnection connection, InetSession session) {
        this.setContractId(connection.getContractId());
        this.setServId(connection.getServId());
        this.setConnectionStart(connection.getConnectionStart());
        this.setConnectionId(connection.getId());
        this.setParentConnectionId(connection.getParentConnectionId());
        this.setDeviceId(connection.getDeviceId());
        this.setDevicePort(connection.getDevicePort());
        this.setAgentDeviceId(connection.getAgentDeviceId());
        this.setAcctSessionId(connection.getAcctSessionId());
        this.setUsername(connection.getUsername());
        this.setCalledStationId(connection.getCalledStationId());
        this.setCallingStationId(connection.getCallingStationId());
        if (connection.getCircuitId() != null) {
            this.setCircuitId(String.valueOf(connection.getCircuitId()));
        }
        this.setIpResourceId(connection.getIpResourceId());
        this.setInetAddressBytes(connection.getInetAddressBytes());
        this.setPrefixResourceId(connection.getPrefixResourceId());
        this.setPrefix(connection.getPrefix());
        this.setPrefixLength(connection.getPrefixLength());
        this.setDelegatedPrefixResourceId(connection.getDelegatedPrefixResourceId());
        this.setDelegatedPrefix(connection.getDelegatedPrefix());
        this.setDelegatedPrefixLength(connection.getDelegatedPrefixLength());
        this.setRouteList(connection.getRouteList());
        this.setType(connection.getType());
        this.setDeviceState(connection.getDeviceState());
        this.setAccessCode(connection.getAccessCode());
        this.setDeviceOptions(connection.getDeviceOptions());
        this.setId(session.getId());
        this.setLastActive(session.getLastActive());
        this.setSessionCost(session.getSessionCost());
        this.setSessionStart(session.getSessionStart());
        this.setSessionStop(session.getSessionStop());
        this.setSessionTime(session.getSessionTime());
        this.setStatus(session.getStatus());
    }

    @XmlAttribute(name="cid")
    public int getContractId() {
        return this.contractId;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    @XmlAttribute(name="servId")
    public int getServId() {
        return this.servId;
    }

    public void setServId(int loginId) {
        this.servId = loginId;
    }

    @XmlAttribute
    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }

    @XmlAttribute
    public int getDevicePort() {
        return this.devicePort;
    }

    public void setDevicePort(int port) {
        this.devicePort = port;
    }

    @XmlAttribute
    public int getAgentDeviceId() {
        return this.agentDeviceId;
    }

    public void setAgentDeviceId(int agentDeviceId) {
        this.agentDeviceId = agentDeviceId;
    }

    @XmlAttribute
    public Date getConnectionStart() {
        return this.connectionStart;
    }

    public void setConnectionStart(Date connectionStart) {
        this.connectionStart = connectionStart;
    }

    @XmlAttribute(name="parConId")
    public long getParentConnectionId() {
        return this.parentConnectionId;
    }

    public void setParentConnectionId(long parentSessionId) {
        this.parentConnectionId = parentSessionId;
    }

    @XmlAttribute(name="realm")
    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    @XmlElementWrapper
    @XmlElements(value={@XmlElement(name="child")})
    public List<InetSessionLog> getChildren() {
        return this.children;
    }

    public void setChildren(List<InetSessionLog> children) {
        this.children = children;
    }

    @XmlAttribute(name="acctSessId")
    public String getAcctSessionId() {
        return this.acctSessionId;
    }

    public void setAcctSessionId(String acctSessionId) {
        this.acctSessionId = acctSessionId;
    }

    @XmlAttribute
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String userName) {
        this.username = userName;
    }

    @XmlAttribute(name="cdsId")
    public String getCalledStationId() {
        return this.calledStationId;
    }

    public void setCalledStationId(String fromNumber) {
        this.calledStationId = fromNumber;
    }

    @XmlAttribute(name="cnsId")
    public String getCallingStationId() {
        return this.callingStationId;
    }

    public void setCallingStationId(String toNumber) {
        this.callingStationId = toNumber;
    }

    @XmlAttribute(name="crctId")
    public String getCircuitId() {
        return this.circuitId;
    }

    public void setCircuitId(String circuitId) {
        this.circuitId = circuitId;
    }

    @XmlAttribute(name="ipResId")
    public int getIpResourceId() {
        return this.ipResourceId;
    }

    public void setIpResourceId(int ipResourceId) {
        this.ipResourceId = ipResourceId;
    }

    @XmlAttribute(name="ipBytes")
    public byte[] getInetAddressBytes() {
        return this.inetAddressBytes;
    }

    public void setInetAddressBytes(byte[] inetAddressBytes) {
        this.inetAddressBytes = inetAddressBytes;
    }

    @XmlAttribute(name="ip")
    public String getInetAddress() {
        return this.inetAddressBytes != null ? IpAddress.toString((byte[])this.inetAddressBytes) : "";
    }

    public void setInetAddress(String nil) {
    }

    @XmlElementWrapper
    @XmlElements(value={@XmlElement(name="route")})
    public List<IpNet> getRouteList() {
        return this.routeList;
    }

    public void setRouteList(List<IpNet> routeList) {
        this.routeList = routeList;
    }

    @XmlAttribute
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @XmlAttribute
    public int getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(int accessCode) {
        this.accessCode = accessCode;
    }

    @XmlAttribute(name="devOpts")
    public Set<Integer> getDeviceOptions() {
        return this.deviceOptions;
    }

    public void setDeviceOptions(Set<Integer> deviceOptions) {
        this.deviceOptions = deviceOptions;
    }

    public InetSessionLog clone() throws CloneNotSupportedException {
        return (InetSessionLog)super.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("InetSession [id=").append(this.connectionId).append('-').append(this.parentConnectionId).append('-').append(this.id).append(',');
        sb.append(" iface=").append(this.deviceId).append(':').append(this.devicePort).append(',');
        sb.append(" sessId=").append(this.acctSessionId).append(',');
        sb.append(" start=").append(TimeUtils.format((Date)this.sessionStart, (String)"dd.MM.yyyy HH:mm:ss")).append(',');
        sb.append(" uname=").append(this.username).append(',');
        sb.append(" addr=").append(this.inetAddress).append(']');
        return sb.toString();
    }

    public Map<Integer, Long> getTrafficMap() {
        return this.trafficMap;
    }

    public void setTrafficMap(Map<Integer, Long> trafficMap) {
        this.trafficMap = trafficMap;
    }

    public Map<Integer, InetSessionLogAccount> getAccountMap() {
        return this.accountMap;
    }

    public void setAccountMap(Map<Integer, InetSessionLogAccount> accountMap) {
        this.accountMap = accountMap;
    }

    @XmlAttribute(name="statusName")
    public String getStatusName() {
        return Optional.ofNullable(this.status).map(a -> a.getTitle()).orElse("");
    }

    public void setStatusName(String nil) {
    }

    @XmlAttribute
    public String getContractComment() {
        return this.contractComment;
    }

    public void setContractComment(String contractComment) {
        this.contractComment = contractComment;
    }

    @XmlAttribute
    public void setContractTitle(String contractTitle) {
        this.contractTitle = contractTitle;
    }

    public String getContractTitle() {
        return this.contractTitle;
    }

    public String getServiceTitle() {
        return this.serviceTitle;
    }

    public void setServiceTitle(String serviceTitle) {
        this.serviceTitle = serviceTitle;
    }

    public InetSession toSession() {
        InetSession result = new InetSession();
        result.setConnectionId(this.getConnectionId());
        result.setId(this.getId());
        result.setLastActive(this.getLastActive());
        result.setSessionCost(this.getSessionCost());
        result.setSessionStart(this.getSessionStart());
        result.setSessionStop(this.getSessionStop());
        result.setSessionTime(this.getSessionTime());
        result.setStatus(this.getStatus());
        result.setDeviceState(this.getDeviceState());
        result.setParentId(this.getParentId());
        result.setSplittedId(this.getSplittedId());
        return result;
    }

    public InetConnection toConnection() {
        return new InetConnection(this);
    }

    @XmlTransient
    public String getFromNumberToNumberAsString() {
        Object result = "";
        boolean flag = false;
        if (this.getCallingStationId() != null) {
            result = (String)result + this.getCallingStationId();
            flag = true;
        }
        if (this.getCalledStationId() != null) {
            if (flag) {
                result = (String)result + "/";
            }
            result = (String)result + this.getCalledStationId();
        }
        return result;
    }

    @XmlTransient
    public String getDurationAsString() {
        Long amount = this.getTrafficMap().get(TrafficType.TIME_ID);
        String result = amount != null && amount != 0L ? Utils.formatSessionTime((int)amount.intValue()) : "0";
        return result;
    }

    @XmlTransient
    public String getConnectionStartAsString() {
        return TimeUtils.format((Date)this.getConnectionStart(), (String)"dd.MM.yyyy HH:mm:ss");
    }

    @XmlTransient
    public String getSessionStartAsString() {
        return TimeUtils.format((Date)this.getSessionStart(), (String)"dd.MM.yyyy HH:mm:ss");
    }

    @XmlTransient
    public String getSessionStopAsString() {
        return TimeUtils.format((Date)this.getSessionStop(), (String)"dd.MM.yyyy HH:mm:ss");
    }

    @XmlTransient
    public String getSessionActivityAsString() {
        return TimeUtils.format((Date)this.getLastActive(), (String)"dd.MM.yyyy HH:mm:ss");
    }

    @XmlAttribute
    public int getPrefixResourceId() {
        return this.prefixResourceId;
    }

    public void setPrefixResourceId(int prefixResourceId) {
        this.prefixResourceId = prefixResourceId;
    }

    @XmlAttribute
    public byte[] getPrefix() {
        return this.prefix;
    }

    public void setPrefix(byte[] prefix) {
        this.prefix = prefix;
    }

    @XmlAttribute
    public short getPrefixLength() {
        return this.prefixLength;
    }

    public void setPrefixLength(short prefixLength) {
        this.prefixLength = prefixLength;
    }

    @XmlAttribute
    public int getDelegatedPrefixResourceId() {
        return this.delegatedPrefixResourceId;
    }

    public void setDelegatedPrefixResourceId(int delegatedPrefixResourceId) {
        this.delegatedPrefixResourceId = delegatedPrefixResourceId;
    }

    @XmlAttribute
    public byte[] getDelegatedPrefix() {
        return this.delegatedPrefix;
    }

    public void setDelegatedPrefix(byte[] delegatedPrefix) {
        this.delegatedPrefix = delegatedPrefix;
    }

    @XmlAttribute
    public short getDelegatedPrefixLength() {
        return this.delegatedPrefixLength;
    }

    public void setDelegatedPrefixLength(short delegatedPrefixLength) {
        this.delegatedPrefixLength = delegatedPrefixLength;
    }
}

