/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.action.web;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.common.Utils;

public abstract class AbstractChartReport
extends AbstractAction {
    public AbstractChartReport() {
        super("inet");
    }

    public void chart() throws BGException {
        HttpServletResponse response = this.context.getResponse();
        response.setContentType("image/png");
        this.setResultParam("contentType", "binary");
        String chart = this.req.get("chart", null);
        LinkedHashMap map = (LinkedHashMap)this.context.getRequest().getSession().getAttribute(AbstractChartReport.class.getName() + ".chartMap");
        if (map != null && chart != null) {
            try {
                byte[] image = (byte[])map.get(chart);
                if (image != null) {
                    ServletOutputStream out = response.getOutputStream();
                    out.write(image);
                    out.flush();
                }
            }
            catch (IOException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    protected String addChart(ByteArrayOutputStream baos) {
        LinkedHashMap<String, byte[]> map = (LinkedHashMap<String, byte[]>)this.context.getRequest().getSession().getAttribute(AbstractChartReport.class.getName() + ".chartMap");
        if (map == null) {
            map = new LinkedHashMap<String, byte[]>();
            this.context.getRequest().getSession().setAttribute(AbstractChartReport.class.getName() + ".chartMap", map);
        }
        if (map.size() > 10) {
            Iterator iter = map.values().iterator();
            iter.next();
            iter.remove();
        }
        String result = Utils.randomAlphanumeric((int)8);
        map.put(result, baos.toByteArray());
        return result;
    }

    protected String getUnitTitle(long unit) {
        if (unit == 1L) {
            return "\u0431\u0430\u0439\u0442";
        }
        if (unit == 1024L) {
            return "\u041a\u0411";
        }
        if (unit == 0x100000L) {
            return "\u041c\u0411";
        }
        if (unit == 0x40000000L) {
            return "\u0413\u0411";
        }
        return "";
    }
}

