/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gorod.client;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ServiceConfigTag
extends ServiceConfigTabbedPanel {
    private BGTable table = new BGTable();
    private JPanel editorPanel = new JPanel();
    private BGTextField tagTextField = new BGTextField();
    private BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
    int currentTagId;

    public ServiceConfigTag() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "tag");
        this.editorPanel.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.editorPanel.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.editorPanel.setLayout(new GridBagLayout());
        this.editorPanel.add((Component)new JLabel("\u0422\u0435\u0433"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.editorPanel.add((Component)this.tagTextField, new GridBagConstraints(1, 0, 1, 1, 2.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editorPanel.add((Component)this.okCancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.tagTextField.setPreferredSize(new Dimension(200, 24));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.editorPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editorPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ServiceConfigTag.this.setData();
            }
        });
        this.okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
    }

    public void setData() {
        Request request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("TagGetList");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData((Node)XMLUtils.getElement((Document)doc, (String)"table"));
        }
    }

    private void stopEdit(boolean save) {
        if (save) {
            if (Utils.isEmptyString((String)this.tagTextField.getText().trim())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!");
                return;
            }
            Request request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("TagAddUpdate").setAttribute("tagId", this.currentTagId).setAttribute("tagTitle", this.tagTextField.getText());
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.editorPanel.setVisible(false);
            }
        } else {
            this.editorPanel.setVisible(false);
        }
    }

    public void deleteItem() {
        this.currentTagId = ClientUtils.getRowId((BGTable)this.table);
        if (this.currentTagId != 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("TagDelete").setAttribute("tagId", this.currentTagId);
            this.stopEdit(false);
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.setData();
            }
        }
    }

    public void editItem() {
        this.currentTagId = ClientUtils.getRowId((BGTable)this.table);
        if (this.currentTagId > 0) {
            this.startEdit();
        }
    }

    public void newItem() {
        this.currentTagId = 0;
        this.startEdit();
    }

    private void startEdit() {
        Request request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("TagGet").setAttribute("tagId", this.currentTagId);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            if (this.currentTagId > 0) {
                Element serviceEl = XMLUtils.getElement((Document)doc, (String)"tag");
                this.tagTextField.setText(serviceEl.getAttribute("title"));
            } else {
                this.tagTextField.setText("");
            }
        }
        this.editorPanel.setVisible(true);
    }
}

