/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.client;

import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.email.common.service.EmailService;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;

public class SPP_Forward
extends ServicePanel
implements ActionListener {
    private int editMode = 0;
    private BGUList<KeyValue> forwards = new BGUList();
    private List<KeyValue> forwardItems = new ArrayList<KeyValue>();
    private BGDialogToolBar dialogToolBar = new BGDialogToolBar();

    public SPP_Forward() {
        this.tryCall(() -> this.jbInit());
        this.dialogToolBar.setDefaultButtons((ActionListener)this);
        this.dialogToolBar.setFloatable(false);
        this.dialogToolBar.setOrientation(1);
        this.dialogToolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        this.forwards.setData(new ArrayList());
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.dialogToolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)this.forwards), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        BGSwingUtilites.handleLDMouseClicked(this.forwards, e -> this.editItem());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int pos;
        String actionCommand = e.getActionCommand();
        if ("newItem".equals(actionCommand)) {
            this.editMode = 2;
            new ForwardEditor("\u041d\u043e\u0432\u044b\u0439 \u0430\u0434\u0440\u0435\u0441", "").open();
        } else if ("editItem".equals(actionCommand)) {
            this.editItem();
        } else if ("deleteItem".equals(actionCommand) && (pos = this.forwards.getSelectedIndex()) >= 0) {
            this.forwardItems.remove(pos);
            this.forwards.setData(this.forwardItems);
        }
    }

    public void editItem() {
        this.editMode = 1;
        Optional.ofNullable((KeyValue)this.forwards.getSelectedValue()).ifPresentOrElse(item -> new ForwardEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0430\u0434\u0440\u0435\u0441\u0430", item.getValue()).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!"));
    }

    public void setData() {
        if (this.id > 0) {
            this.tryCall(() -> {
                this.forwardItems = ((EmailService)this.getContext().getWebService(EmailService.class)).forwardList(this.getContractId(), this.id);
            });
            this.forwards.setData(this.forwardItems);
        }
    }

    public boolean updateData() {
        if (this.id > 0) {
            this.tryCall(() -> ((EmailService)this.getContext().getWebService(EmailService.class)).forwardUpdate(this.id, this.forwardItems.stream().map(a -> a.getValue()).toList()));
        }
        return true;
    }

    public void setDocument(Document doc) {
    }

    class ForwardEditor
    extends BGEditorDialog<String> {
        private BGTextField value;

        public ForwardEditor(String title, String data) {
            super(title, (Object)data);
            this.value = new BGTextField(30);
        }

        public void doDialogPanel() {
            this.panel.add((Component)this.value, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.value.setText((String)this.data);
        }

        public boolean doApply() throws Exception {
            if (this.value.getText().length() > 0 && this.value.getText().indexOf("@") > 0) {
                if (SPP_Forward.this.editMode == 1) {
                    ((KeyValue)SPP_Forward.this.forwards.getSelectedValue()).setValue(this.value.getText());
                } else {
                    SPP_Forward.this.forwardItems.add(new KeyValue("0", this.value.getText()));
                    SPP_Forward.this.forwards.setData(SPP_Forward.this.forwardItems);
                }
                return true;
            }
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 E-Mail!");
            return false;
        }
    }
}

