/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.action;

import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.email.server.bean.DomainManager;
import ru.bitel.common.Utils;

public class ActionFindEmail
extends ActionBase {
    public void doAction() throws Exception {
        String mask = this.getParameter("mask", "");
        int domainID = this.getIntParameter("domain", 0);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        if (Utils.notEmptyString((String)mask)) {
            DomainManager dm = new DomainManager(this.con, this.mid);
            AccountManager am = new AccountManager(this.con, this.mid);
            List<Account> accountList = am.findAccounts(mask, domainID);
            Map<Long, String> quotas = this.getQuotasMap();
            try (ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());){
                for (Account ac : accountList) {
                    Element row = this.createElement(data, "row");
                    Contract contract = (Contract)contractDao.get(ac.getContractId());
                    Domain domain = dm.get(ac.getDomainId());
                    String quota = quotas.get(ac.getQuota());
                    row.setAttribute("cid", String.valueOf(ac.getContractId()));
                    row.setAttribute("status", ac.getStringStatus());
                    if (contract != null) {
                        row.setAttribute("contract", contract.getTitle());
                        row.setAttribute("comment", contract.getComment());
                    }
                    if (domain != null) {
                        row.setAttribute("email", ac.getAccount() + "@" + domain.getName());
                    }
                    if (quota == null) continue;
                    row.setAttribute("quota", quota);
                }
            }
        }
    }
}

