/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.client;

import bitel.billing.module.common.BGComboBoxFixed;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentInfos;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentSearchInfo;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentType;
import ru.bitel.bgbilling.plugins.edo.common.service.EdoService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class SearchContragentDialog
extends JDialog {
    private BGComboBoxFixed field_type = new BGComboBoxFixed();
    private BGIntTextField field_inn = new BGIntTextField();
    private BGIntTextField field_kpp = new BGIntTextField();
    private BGTextField field_F = new BGTextField();
    private BGTextField field_I = new BGTextField();
    private BGTextField field_O = new BGTextField();
    private BGIntTextField field_snils = new BGIntTextField();
    private JLabel resultInfoTitle = new JLabel();
    private final DefaultListModel<ContragentInfos.ContragentInfo> resultListModel = new DefaultListModel();
    private final JList<ContragentInfos.ContragentInfo> resultList = new JList<ContragentInfos.ContragentInfo>(this.resultListModel);
    private final JScrollPane searchResultPane = new JScrollPane(this.resultList);
    private BGButtonPanelOkCancel okCancelPanelSearch = new BGButtonPanelOkCancel();
    private BGButtonPanelOkCancel okCancelPanelSelect = new BGButtonPanelOkCancel();
    private ContragentInfos result;
    private ContragentInfos _wsResult;
    private ClientContext clientContext;
    private boolean defaultOnlyMode = false;

    public SearchContragentDialog(ClientContext clientContext, int contractId) {
        this.clientContext = clientContext;
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setTitle("\u041f\u043e\u0438\u0441\u043a \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430");
        this.okCancelPanelSearch.getButtonOk().setText("\u041f\u043e\u0438\u0441\u043a");
        this.okCancelPanelSearch.addActionListener(e -> this.okCancelPanelSearch_actionPerformed(e));
        this.okCancelPanelSelect.getButtonOk().setText("\u0412\u044b\u0431\u0440\u0430\u0442\u044c");
        this.okCancelPanelSelect.addActionListener(e -> this.okCancelPanelSelect_actionPerformed(e));
        this.field_type.addItem((Object)ContragentType.ORG, "\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f");
        this.field_type.addItem((Object)ContragentType.IP, "\u0418\u041f");
        this.field_type.addItem((Object)ContragentType.FIZ, "\u0424\u0438\u0437.\u043b\u0438\u0446\u043e");
        this.field_inn.setColumns(32);
        this.resultList.setSelectionMode(0);
        JPanel filterPanel1 = new JPanel(new GridBagLayout());
        filterPanel1.add((Component)new JLabel("\u0422\u0438\u043f: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)this.field_type, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)new JLabel("\u0418\u041d\u041d: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)this.field_inn, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)new JLabel("\u041a\u041f\u041f: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)this.field_kpp, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)new JLabel("\u0424\u0430\u043c\u0438\u043b\u0438\u044f: "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)this.field_F, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)new JLabel("\u0418\u043c\u044f: "), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)this.field_I, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)new JLabel("\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e: "), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)this.field_O, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)new JLabel("\u0421\u041d\u0418\u041b\u0421: "), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)this.field_snils, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.resultInfoTitle.setVisible(false);
        this.searchResultPane.setVisible(false);
        this.okCancelPanelSelect.setVisible(false);
        ClientUtils.addOpenAction(this.resultList, e -> this.okCancelPanelSelect.getButtonOk().doClick());
        this.field_inn.addActionListener(e -> this.doInnInput());
        this.getContentPane().add((Component)filterPanel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.okCancelPanelSearch, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.resultInfoTitle, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.searchResultPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.okCancelPanelSelect, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.getRootPane().setDefaultButton(this.okCancelPanelSearch.getButtonOk());
        this.setSize(640, 480);
        this.pack();
        this.setLocationRelativeTo((Component)BGClientBase.getFrame());
        this.fillSearchInfo(contractId);
    }

    private void fillSearchInfo(int contractId) {
        try {
            ContragentSearchInfo result = ((EdoService)this.clientContext.getPort(EdoService.class)).fillContragentSearchInfo(contractId);
            this.field_type.setSelectedId((Object)result.guessType());
            this.field_inn.setText(result.getInn());
            this.field_kpp.setText(result.getKpp());
            this.field_F.setText(result.getF());
            this.field_I.setText(result.getI());
            this.field_O.setText(result.getO());
            this.field_snils.setText(result.getSnils());
        }
        catch (BGException e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438! " + e.getMessage());
        }
    }

    private void okCancelPanelSearch_actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if ("ok".equals(actionCommand)) {
            ContragentSearchInfo csi = new ContragentSearchInfo();
            csi.setType((ContragentType)this.field_type.getSelectedIdObj());
            csi.setInn(this.field_inn.getText());
            csi.setKpp(this.field_kpp.getText());
            csi.setF(this.field_F.getText());
            csi.setI(this.field_I.getText());
            csi.setO(this.field_O.getText());
            csi.setSnils(this.field_snils.getText());
            try {
                this._wsResult = ((EdoService)this.clientContext.getPort(EdoService.class)).sbisSearchContragent(csi);
                this._setResultInfoTitle(this._wsResult.toStringFull());
                this.resultListModel.removeAllElements();
                ContragentInfos.ContragentInfo def = null;
                for (ContragentInfos.ContragentInfo in : this._wsResult.ids) {
                    this.resultListModel.addElement(in);
                    if (!in.main) continue;
                    def = in;
                }
                if (def != null) {
                    this.resultList.setSelectedValue(def, true);
                }
                if (this.defaultOnlyMode) {
                    this.resultList.setEnabled(false);
                }
                if (this.defaultOnlyMode && def == null) {
                    this.resultList.setSelectedValue(null, false);
                    ClientUtils.showErrorMessageDialog((String)"\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u0418\u0414 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
                }
                this.resultInfoTitle.setVisible(true);
                this.searchResultPane.setVisible(true);
                this.okCancelPanelSelect.setVisible(true);
                this.okCancelPanelSearch.getButton(BGButtonPanelOkCancel.CANCEL).setVisible(false);
                this.pack();
            }
            catch (Exception e1) {
                ClientUtils.showErrorMessageDialog((Throwable)e1);
                this._wsResult = null;
                this.resultInfoTitle.setVisible(false);
                this.searchResultPane.setVisible(false);
                this.okCancelPanelSelect.setVisible(false);
                this.okCancelPanelSearch.getButton(BGButtonPanelOkCancel.CANCEL).setVisible(true);
                this.pack();
            }
        } else if ("cancel".equals(actionCommand)) {
            this._setResultAndClose(null);
        }
    }

    private void doInnInput() {
        String inn = this.field_inn.getText();
        if (Utils.notBlankString((String)inn)) {
            inn = inn.strip();
            ContragentType currentType = (ContragentType)this.field_type.getSelectedIdObj();
            if (inn.length() == 10 && currentType != ContragentType.ORG) {
                this.field_type.setSelectedId((Object)ContragentType.ORG);
                return;
            }
            if (inn.length() == 12 && currentType == ContragentType.ORG) {
                this.field_type.setSelectedId((Object)ContragentType.IP);
                return;
            }
        }
    }

    private void okCancelPanelSelect_actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if ("ok".equals(actionCommand)) {
            ContragentInfos.ContragentInfo value = this.resultList.getSelectedValue();
            if (value == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
                return;
            }
            if (this._wsResult == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u0431\u044b\u043b\u043e \u043d\u0430\u0439\u0434\u0435\u043d\u043e");
                return;
            }
            this._wsResult.ids.clear();
            this._wsResult.ids.add(value);
            this._setResultAndClose(this._wsResult);
        } else if ("cancel".equals(actionCommand)) {
            this._setResultAndClose(null);
        }
    }

    private void setDefaultOnlyMode(boolean defaultOnlyMode) {
        this.defaultOnlyMode = defaultOnlyMode;
    }

    private void _setResultInfoTitle(String result) {
        this.resultInfoTitle.setText("<html>" + result.replace("\n", "<br>") + "</html>");
    }

    private void _setResultAndClose(ContragentInfos result) {
        this.result = result;
        this.setVisible(false);
        this.dispose();
    }

    public static ContragentInfos doSearch(ClientContext clientContext, int contractId) {
        SearchContragentDialog dialog = new SearchContragentDialog(clientContext, contractId);
        dialog.setVisible(true);
        return dialog.result;
    }

    public static ContragentInfos doSearchDefaultOnly(ClientContext clientContext, int contractId) {
        SearchContragentDialog dialog = new SearchContragentDialog(clientContext, contractId);
        dialog.setDefaultOnlyMode(true);
        dialog.setVisible(true);
        return dialog.result;
    }
}

