/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.provider.sbis;

import bitel.billing.common.VersionInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentInfos;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentSearchInfo;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentType;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;

public class SbisAPI
extends BGLogger {
    private int userId = 0;
    private BGPluginServer plugin = null;
    private static Map<Integer, String> tokenMap = new HashMap<Integer, String>();

    public SbisAPI(int userId) {
        this.userId = userId;
        this.plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.edo");
    }

    public WriteDoc writeFormalizedDoc(final InputFile file, final ParameterMap documentSetup, final ContragentInfos contragentInfos) throws BGException, SbisJsonRpcException {
        HashMap<String, Object> params = new HashMap<String, Object>(){
            {
                this.put("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442", new HashMap<String, Object>(){
                    {
                        this.put("\u0412\u043b\u043e\u0436\u0435\u043d\u0438\u0435", new ArrayList<HashMap<String, Object>>(){
                            {
                                this.add(new HashMap<String, Object>(){
                                    {
                                        this.put("\u0424\u0430\u0439\u043b", new HashMap<String, Object>(){
                                            {
                                                this.put("\u0414\u0432\u043e\u0438\u0447\u043d\u044b\u0435\u0414\u0430\u043d\u043d\u044b\u0435", file.base64data());
                                                this.put("\u0418\u043c\u044f", file.name);
                                            }
                                        });
                                    }
                                });
                            }
                        });
                        final String org_INN = documentSetup.get("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f_\u0418\u041d\u041d");
                        this.put("\u041d\u0430\u0448\u0430\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f", new HashMap<String, Object>(){
                            {
                                if (org_INN.length() == 10) {
                                    this.put("\u0421\u0432\u042e\u041b", new HashMap<String, Object>(){
                                        {
                                            this.put("\u0418\u041d\u041d", org_INN);
                                            this.put("\u041a\u041f\u041f", documentSetup.get("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f_\u041a\u041f\u041f"));
                                            this.put("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", documentSetup.get("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f_\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"));
                                        }
                                    });
                                }
                                if (org_INN.length() == 12) {
                                    this.put("\u0421\u0432\u0424\u041b", new HashMap<String, Object>(){
                                        {
                                            this.put("\u0418\u041d\u041d", org_INN);
                                            this.put("\u0421\u041d\u0418\u041b\u0421", documentSetup.get("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f_\u0421\u041d\u0418\u041b\u0421"));
                                            this.put("\u0424\u0430\u043c\u0438\u043b\u0438\u044f", documentSetup.get("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f_\u0424\u0430\u043c\u0438\u043b\u0438\u044f"));
                                            this.put("\u0418\u043c\u044f", documentSetup.get("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f_\u0418\u043c\u044f"));
                                            this.put("\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e", documentSetup.get("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f_\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e"));
                                        }
                                    });
                                }
                            }
                        });
                        String _id_Dest = documentSetup.get("\u0418\u0434\u041f\u043e\u043b");
                        if (_id_Dest == null) {
                            _id_Dest = ((ContragentInfos.ContragentInfo)contragentInfos.ids.get((int)0)).id;
                        }
                        final String id_Dest = _id_Dest;
                        this.put("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442", new HashMap<String, Object>(){
                            {
                                this.put("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", id_Dest);
                            }
                        });
                    }
                });
            }
        };
        JSONObject jsonobject = new JSONObject((Map)params);
        JSONObject response = (JSONObject)this.doRequest("\u0421\u0411\u0418\u0421.\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442", jsonobject, this.getToken());
        WriteDoc writeDoc = new WriteDoc();
        writeDoc.link = response.optString("\u0421\u0441\u044b\u043b\u043a\u0430\u0414\u043b\u044f\u041d\u0430\u0448\u0430\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f");
        writeDoc.title = response.optString("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        return writeDoc;
    }

    public WriteDoc writeNotFormalizedDoc(List<InputFile> file, ParameterMap documentSetup, ContragentInfos contragentInfos) throws BGException, SbisJsonRpcException {
        return this.writeFormalizedDoc(file.get(0), documentSetup, contragentInfos);
    }

    public ContragentInfos contragentInfo(final ContragentSearchInfo info) throws BGException, SbisJsonRpcException {
        HashMap<String, Object> params = new HashMap<String, Object>(){
            {
                this.put("\u0423\u0447\u0430\u0441\u0442\u043d\u0438\u043a", new HashMap<String, Object>(){
                    {
                        if (info.getType() == ContragentType.ORG) {
                            this.put("\u0421\u0432\u042e\u041b", new HashMap<String, Object>(){
                                {
                                    this.put("\u0418\u041d\u041d", info.getInn());
                                    this.put("\u041a\u041f\u041f", info.getKpp());
                                }
                            });
                        } else {
                            this.put("\u0421\u0432\u0424\u041b", new HashMap<String, Object>(){
                                {
                                    this.put("\u0424\u0430\u043c\u0438\u043b\u0438\u044f", info.getF());
                                    this.put("\u0418\u043c\u044f", info.getI());
                                    if (Utils.notBlankString((String)info.getO())) {
                                        this.put("\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e", info.getO());
                                    }
                                    if (Utils.notBlankString((String)info.getInn())) {
                                        this.put("\u0418\u041d\u041d", info.getInn());
                                    }
                                    if (Utils.notBlankString((String)info.getSnils())) {
                                        this.put("\u0421\u041d\u0418\u041b\u0421", info.getSnils());
                                    }
                                    if (info.getType() == ContragentType.IP) {
                                        this.put("\u0427\u0430\u0441\u0442\u043d\u043e\u0435\u041b\u0438\u0446\u043e", "\u041d\u0435\u0442");
                                    } else {
                                        this.put("\u0427\u0430\u0441\u0442\u043d\u043e\u0435\u041b\u0438\u0446\u043e", "\u0414\u0430");
                                    }
                                }
                            });
                        }
                        this.put("\u0414\u043e\u043f\u041f\u043e\u043b\u044f", "\u0421\u043f\u0438\u0441\u043e\u043a\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u0432");
                    }
                });
            }
        };
        JSONObject jsonobject = new JSONObject((Map)params);
        JSONObject response = (JSONObject)this.doRequest("\u0421\u0411\u0418\u0421.\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f\u041e\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0435", jsonobject, this.getToken());
        ContragentInfos infos = new ContragentInfos();
        try {
            String _type;
            switch (_type = response.getString("\u0422\u0438\u043f")) {
                case "\u042e\u041b": {
                    infos.type = ContragentType.ORG;
                    break;
                }
                case "\u0418\u041f": {
                    infos.type = ContragentType.IP;
                    break;
                }
                case "\u0424\u041b": {
                    infos.type = ContragentType.FIZ;
                    break;
                }
                default: {
                    throw new Exception("unknown \u0422\u0438\u043f=" + _type);
                }
            }
            String _svName = infos.type == ContragentType.ORG ? "\u0421\u0432\u042e\u041b" : "\u0421\u0432\u0424\u041b";
            JSONObject _sv = response.getJSONObject(_svName);
            infos.title = _sv.optString("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", null);
            infos.titleFull = _sv.getString("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u041f\u043e\u043b\u043d\u043e\u0435");
            infos.inn = _sv.getString("\u0418\u041d\u041d");
            infos.kpp = _sv.optString("\u041a\u041f\u041f", null);
            infos.address = _sv.optString("\u0410\u0434\u0440\u0435\u0441\u042e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0439", null);
            infos.snils = _sv.optString("\u0421\u041d\u0418\u041b\u0421", null);
            infos.f = _sv.optString("\u0424\u0430\u043c\u0438\u043b\u0438\u044f", null);
            infos.i = _sv.optString("\u0418\u043c\u044f", null);
            infos.o = _sv.optString("\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e", null);
            if (infos.title == null && (infos.type == ContragentType.IP || infos.type == ContragentType.FIZ)) {
                infos.title = infos.type == ContragentType.IP ? "\u0418\u041f" : "(\u0444\u0438\u0437\u043b\u0438\u0446\u043e)";
                String f = _sv.optString("\u0424\u0430\u043c\u0438\u043b\u0438\u044f", null);
                String i = _sv.optString("\u0418\u043c\u044f", null);
                String o = _sv.optString("\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e", null);
                if (Utils.notBlankString((String)f)) {
                    infos.title = infos.title + " " + f;
                }
                if (Utils.notBlankString((String)i)) {
                    infos.title = infos.title + " " + i.charAt(0) + ".";
                }
                if (Utils.notBlankString((String)o)) {
                    infos.title = infos.title + o.charAt(0) + ".";
                }
            }
            JSONArray ids = response.getJSONArray("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440");
            for (int index = 0; index < ids.length(); ++index) {
                JSONObject ident = ids.getJSONObject(index);
                ContragentInfos.ContragentInfo _info = new ContragentInfos.ContragentInfo();
                _info.id = ident.optString("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0423\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430");
                _info.operatorId = ident.optJSONObject("\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440").optString("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440");
                _info.operatorName = ident.optJSONObject("\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440").optString("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                _info.main = "\u0414\u0430".equalsIgnoreCase(ident.optString("\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439"));
                _info.roaming = "\u0414\u0430".equalsIgnoreCase(ident.optString("\u0420\u043e\u0443\u043c\u0438\u043d\u0433"));
                _info.ok = "0".equals(ident.optJSONObject("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f").optString("\u041a\u043e\u0434"));
                infos.ids.add(_info);
            }
        }
        catch (Exception e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043e\u0442\u0432\u0435\u0442\u0430: " + e.getMessage());
        }
        return infos;
    }

    private String getToken() throws BGException, SbisJsonRpcException {
        String token = tokenMap.get(this.userId);
        if (token == null) {
            String login = this.plugin.getSetup().get("sbis.service.login");
            String password = this.plugin.getSetup().get("sbis.service.password");
            JSONObject loginPassword = new JSONObject();
            loginPassword.put("\u041b\u043e\u0433\u0438\u043d", (Object)login);
            loginPassword.put("\u041f\u0430\u0440\u043e\u043b\u044c", (Object)password);
            JSONObject params = new JSONObject();
            params.put("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", (Object)loginPassword);
            Object result = this.doAuthRequest("\u0421\u0411\u0418\u0421.\u0410\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c", params, null);
            token = (String)result;
            tokenMap.put(this.userId, token);
        }
        return token;
    }

    private String httpRequest(String url, String httpMethod, String data, String sessionId) throws BGException {
        String result = null;
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(url));
        if ("GET".equals(httpMethod)) {
            builder = builder.GET();
        } else if ("POST".equals(httpMethod)) {
            builder = builder.POST(HttpRequest.BodyPublishers.ofString(data));
        }
        builder.setHeader("Content-Type", "application/json-rpc;charset=utf-8");
        builder.setHeader("User-Agent", "BGBilling " + String.valueOf(VersionInfo.getVersionInfo((String)"kernel")));
        if (sessionId != null) {
            builder.setHeader("X-SBISSessionID", sessionId);
        }
        HttpRequest request = builder.build();
        try {
            this.getLogger().debug("-> {}", (Object)request);
            if (Utils.notBlankString((String)data)) {
                this.getLogger().trace("-- {}", (Object)data);
            }
            result = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
            this.getLogger().debug("<- {}", (Object)result);
        }
        catch (HttpTimeoutException ex) {
            throw new BGException("\u0441\u0435\u0440\u0432\u0438\u0441 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new BGException("io error", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            throw new BGException("interrupt error", (Throwable)ex);
        }
        return result;
    }

    private Object jsonRequest(String url, String jsonMethod, JSONObject jsonParams, String sessionId) throws BGException, SbisJsonRpcException {
        JSONObject json = new JSONObject().put("jsonrpc", (Object)"2.0").put("method", (Object)jsonMethod).put("params", (Object)jsonParams).put("id", System.currentTimeMillis());
        JSONObject result = new JSONObject(this.httpRequest(url, "POST", json.toString(), sessionId));
        if (result.has("result")) {
            return result.get("result");
        }
        if (result.has("error")) {
            JSONObject error = result.getJSONObject("error");
            throw new SbisJsonRpcException(error.getInt("code"), error.getString("message"), error.getString("details"), error.getJSONObject("data"));
        }
        throw new BGException("error jsonrpc reply");
    }

    private Object doAuthRequest(String jsonMethod, JSONObject jsonParams, String sessionId) throws BGException, SbisJsonRpcException {
        String url = this.plugin.getSetup().get("sbis.auth.url", "https://online.sbis.ru/auth/service/");
        return this.jsonRequest(url, jsonMethod, jsonParams, sessionId);
    }

    private Object doRequest(String jsonMethod, JSONObject jsonParams, String sessionId) throws BGException, SbisJsonRpcException {
        String url = this.plugin.getSetup().get("sbis.service.url", "https://online.sbis.ru/service/?srv=1");
        return this.jsonRequest(url, jsonMethod, jsonParams, sessionId);
    }

    public static class InputFile {
        public String name;
        public InputStream fileData;

        public InputFile(String name, InputStream fileData) {
            this.name = name;
            this.fileData = fileData;
        }

        public String base64data() throws BGException {
            try {
                return Base64.encode((InputStream)this.fileData);
            }
            catch (IOException e) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 base64-\u0441\u0435\u0440\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0444\u0430\u0439\u043b\u0430 " + this.name, (Throwable)e);
            }
        }
    }

    public static class WriteDoc {
        public String link;
        public String title;
    }

    public static class SbisJsonRpcException
    extends BGException {
        int code;
        String message;
        String details;
        JSONObject data;

        public SbisJsonRpcException(int code, String message, String details, JSONObject data) {
            super("JsonRpc error " + code + ": " + message);
            this.code = code;
            this.message = message;
            this.details = details;
            this.data = data;
        }
    }
}

