/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessage;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessageStatistic;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class DispatchMessageDao
extends AbstractIdDao<DispatchMessage> {
    private static final String TABLE_MESSAGE_STATISTIC = "dispatch_message_statistic";
    private static final String TABLE_MESSAGE_CONTENT = "dispatch_message_content";

    public DispatchMessageDao(Connection con) {
        super(con, "dispatch_message");
    }

    protected void updateImpl(DispatchMessage dispatchMessage) throws SQLException {
        String querySet = "create_date=?, dispatch_id=?, is_sent=?, send_date=?, msg_body=?, msg_title=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)dispatchMessage, querySet);){
            int index = 1;
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)dispatchMessage.getCreateDate()));
            ps.setInt(index++, dispatchMessage.getDispatchId());
            ps.setBoolean(index++, dispatchMessage.isSent());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)dispatchMessage.getSendDate()));
            ps.setString(index++, dispatchMessage.getMessageBody());
            ps.setString(index++, dispatchMessage.getTitle());
            this.executeUpdate((Id)dispatchMessage, index, ps);
        }
    }

    protected DispatchMessage getFromRS(ResultSet rs) throws SQLException {
        return new DispatchMessage().setId(rs.getInt("id")).setTitle(rs.getString("msg_title")).setCreateDate((Date)rs.getTimestamp("create_date")).setDispatchId(rs.getInt("dispatch_id")).setSendDate((Date)rs.getTimestamp("send_date")).setMessageBody(rs.getString("msg_body")).setSent(rs.getBoolean("is_sent"));
    }

    public List<DispatchMessage> getList(int dispatchId, boolean onlyNotSent) throws SQLException {
        String filter = "dispatch_id=?" + (onlyNotSent ? " AND is_sent=0 AND send_date <= NOW()" : "");
        return this.list(filter, "id", new Object[]{dispatchId});
    }

    public void deleteByDispatch(int id) throws SQLException {
        StringBuilder sb = new StringBuilder(100).append("DELETE FROM ").append(this.tableName).append(" WHERE dispatch_id=?");
        try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    public void addMessageStatistic(DispatchMessageStatistic statistic) throws SQLException {
        String query = "INSERT INTO dispatch_message_statistic SET contractId=?, messageId=?, dispatchId=?, contactId=?, sendDate=?, contractValue=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, statistic.getContractId());
            ps.setInt(index++, statistic.getMessageId());
            ps.setInt(index++, statistic.getDispatchId());
            ps.setInt(index++, statistic.getContactId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)(statistic.getSendDate() != null ? statistic.getSendDate() : new Date())));
            ps.setString(index, statistic.getContactValue());
            ps.executeUpdate();
            statistic.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            try (PreparedStatement textPs = this.con.prepareStatement("INSERT INTO dispatch_message_content SET statisticId=?, text=?");){
                index = 1;
                textPs.setInt(index++, statistic.getId());
                textPs.setString(index++, statistic.getMessageText());
                textPs.executeUpdate();
            }
        }
    }

    public DispatchMessageStatistic getMessageStatistic(int id) throws SQLException {
        DispatchMessageStatistic result = null;
        String query = "SELECT mstat.*, c.title, d.title, cont.val, msg.text FROM dispatch_message_statistic mstat LEFT JOIN contract c ON c.id=mstat.contractId LEFT JOIN dispatch_dispatch d ON d.id=mstat.dispatchId LEFT JOIN dispatch_message dmes ON dmes.id=mstat.messageId LEFT JOIN dispatch_contact cont ON cont.id=mstat.contactId LEFT JOIN dispatch_message_content msg ON msg.statisticId=mstat.id WHERE mstat.id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getMessageStatisticFromRs(rs);
                }
            }
        }
        return result;
    }

    public void getMessageStatisticList(int contractId, int dispatchId, int messageId, int contactId, SearchResult<DispatchMessageStatistic> searchResult) throws SQLException {
        List result = searchResult.getList();
        Period period = searchResult.getPeriod();
        Page page = searchResult.getPage();
        Object query = "SELECT SQL_CALC_FOUND_ROWS mstat.*, c.title, d.title, cont.val, msg.text FROM dispatch_message_statistic mstat LEFT JOIN contract c ON c.id=mstat.contractId LEFT JOIN dispatch_dispatch d ON d.id=mstat.dispatchId LEFT JOIN dispatch_message dmes ON dmes.id=mstat.messageId LEFT JOIN dispatch_contact cont ON cont.id=mstat.contactId LEFT JOIN dispatch_message_content msg ON msg.statisticId=mstat.id WHERE 1=1 ";
        if (contractId > 0) {
            query = (String)query + " AND c.id=" + contractId;
        }
        if (dispatchId > 0) {
            query = (String)query + " AND d.id=" + dispatchId;
        }
        if (contactId > 0) {
            query = (String)query + " AND cont.id=" + contactId;
        }
        if (messageId > 0) {
            query = (String)query + " AND dmes.id=" + messageId;
        }
        if (period != null) {
            if (period.getDateFrom() != null) {
                query = (String)query + " AND sendDate>=?";
            }
            if (period.getDateTo() != null) {
                query = (String)query + " AND sendDate<=?";
            }
        }
        query = (String)query + " ORDER BY id";
        query = (String)query + Page.toSqlLimit((Page)page);
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            int index = 1;
            if (period != null) {
                if (period.getDateFrom() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                }
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getMessageStatisticFromRs(rs));
                }
            }
            Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.con));
        }
    }

    public void deleteMessageStatistic(int id) throws SQLException {
        String query = "DELETE FROM dispatch_message_statistic WHERE id=" + id;
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(query);
        }
    }

    private DispatchMessageStatistic getMessageStatisticFromRs(ResultSet rs) throws SQLException {
        return new DispatchMessageStatistic().setId(rs.getInt("mstat.id")).setMessageId(rs.getInt("mstat.messageId")).setDispatchId(rs.getInt("mstat.dispatchId")).setContactId(rs.getInt("mstat.contactId")).setContractId(rs.getInt("mstat.contractId")).setSendDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("mstat.sendDate"))).setContractTitle(rs.getString("c.title")).setDispatchTitle(rs.getString("d.title")).setContactValue(rs.getString("mstat.contractValue")).setMessageText(rs.getString("msg.text"));
    }
}

