/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.action;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.plugins.crm.common.model.AddressFilter;
import ru.bitel.bgbilling.plugins.crm.common.model.PersonalRegisterTask;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterGroup;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterTask;
import ru.bitel.bgbilling.plugins.crm.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterGroupManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterProblemManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterTaskManager;
import ru.bitel.bgbilling.plugins.crm.server.model.TaskFilter;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.FOUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public class ActionGetRegisterTaskTable
extends ActionBase {
    public void doAction() throws Exception {
        int value;
        Object phoneParam;
        String fioParams;
        String ext = this.getParameter("ext");
        if (ext == null) {
            ext = "html";
        }
        String xslt = "crm_" + ext + "_" + this.getParameter("xslt", "register_tasks.xsl");
        this.rootNode.setAttribute("xslt", xslt);
        ArrayList<String> orders = new ArrayList<String>(5);
        orders.add(this.getParameter("sort1", "no"));
        orders.add(this.getParameter("sort2", "no"));
        orders.add(this.getParameter("sort3", "no"));
        orders.add(this.getParameter("sort4", "no"));
        orders.add(this.getParameter("sort5", "no"));
        AddressFilter addressFilter = null;
        int city = this.getIntParameter("city", -1);
        int quarter = this.getIntParameter("quarter", -1);
        int street = this.getIntParameter("street", -1);
        int house = this.getIntParameter("house", -1);
        if (quarter > 0 || street > 0 || house > 0 || city > 0) {
            addressFilter = new AddressFilter();
            addressFilter.setCityId(city);
            addressFilter.setStreetId(street);
            addressFilter.setQuarterId(quarter);
            addressFilter.setHouseId(house);
        }
        if ((fioParams = this.plugin.getSetup().get("contract.fio.param.id", null)) == null) {
            fioParams = this.plugin.getSetup().get("register.param.fio", this.setup.get("register.param.fio", ""));
        }
        if ((phoneParam = this.plugin.getSetup().get("contract.phone.param.id", null)) == null && (value = this.plugin.getSetup().getInt("register.param.phone", this.setup.getInt("register.param.phone", 0))) > 0) {
            phoneParam = "text:" + value;
        }
        TaskFilter filter = TaskFilter.builder().setId(this.getIntParameter("taskId", -1)).setContractId(this.cid).setFioParams(fioParams).setProcessed(this.getIntParameter("processed", -1)).setTypes(this.getParameter("type", "")).build();
        filter.statusMask = this.getParameter("status", "");
        filter.dateType = this.getParameter("date_type");
        filter.dateFrom = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date1"));
        filter.dateTo = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date2"));
        filter.setPhoneParams((String)phoneParam);
        filter.addressFilter = addressFilter;
        filter.executors = this.getParameter("executors", "");
        filter.groups = this.getParameter("groups", "");
        filter.orders = orders;
        Page page = this.getPage();
        if (filter.id > 0) {
            page.setPageIndex(1);
            page.setPageSize(1);
            Page.setRecordCount((Page)page, (int)1);
        }
        RegisterTaskManager manager = new RegisterTaskManager(this.con);
        List<PersonalRegisterTask> taskList = manager.getTaskList(filter, page);
        Map<Integer, String> typeMap = this.getRegisterTaskTypeMap();
        Map<Integer, String> executorMap = this.getRegisterExecutorMap();
        Map<Integer, RegisterGroup> groupMap = new RegisterGroupManager(this.con).getGroupMap();
        String statusList = this.plugin.getSetup().get("register.task.status.list", "0:\u043e\u0442\u043a\u0440\u044b\u0442\u0430;1:\u043f\u0440\u0438\u043d\u044f\u0442\u0430;2:\u0437\u0430\u043a\u0440\u044b\u0442\u0430");
        Map<Integer, String> statusMap = RegisterProblemManager.getStatusMap(statusList);
        Element table = this.createElement(this.rootNode, "table");
        table.setAttribute("current_date", TimeUtils.formatDate((Calendar)new GregorianCalendar()));
        Element data = this.createElement(table, "data");
        Map<Object, Object> colorMap = new HashMap();
        List hourList = Utils.toIntegerList((String)this.plugin.getSetup().get("task.hour", null));
        if (hourList != null) {
            Collections.sort(hourList);
            colorMap = this.correctColors(this.plugin.getSetup().sub("task.color."), hourList);
        }
        for (PersonalRegisterTask personalTask : taskList) {
            RegisterGroup group;
            RegisterTask task = personalTask.getTask();
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(task.getId()));
            String typeRef = typeMap.get(task.getTypeId());
            if (typeRef != null) {
                row.setAttribute("type", typeRef);
            }
            if ((group = groupMap.get(task.getGroupId())) != null) {
                row.setAttribute("group", group.getTitle());
            } else {
                row.setAttribute("group", "-");
            }
            row.setAttribute("status", statusMap.get(task.getStatus()));
            row.setAttribute("status_code", String.valueOf(task.getStatus()));
            row.setAttribute("open_date", task.getOpenTimeF());
            row.setAttribute("open_user", UserMap.getUser((Integer)task.getOpenUserId()).getName());
            row.setAttribute("target_date", task.getTargetDateF());
            row.setAttribute("execute_date", TimeUtils.format((Date)task.getExecuteDate(), (String)"dd.MM.yyyy"));
            row.setAttribute("comment", task.getComment());
            row.setAttribute("resolution", task.getResolution());
            row.setAttribute("contract", this.maskNull(personalTask.getContract()));
            row.setAttribute("contract_comment", this.maskNull(personalTask.getContractComment()));
            row.setAttribute("object_title", this.maskNull(personalTask.getObjectTitle()));
            row.setAttribute("fio", this.maskNull(personalTask.getFio()));
            row.setAttribute("phone", this.maskNull(personalTask.getPhone()));
            row.setAttribute("city", this.maskNull(personalTask.getCity()));
            row.setAttribute("area", this.maskNull(personalTask.getArea()));
            row.setAttribute("quarter", this.maskNull(personalTask.getQuarter()));
            row.setAttribute("street", this.maskNull(personalTask.getStreet()));
            row.setAttribute("house", this.maskNull(personalTask.getHouse()));
            row.setAttribute("flat", this.maskNull(personalTask.getFlat()));
            row.setAttribute("pod", personalTask.getPod() > 0 ? String.valueOf(personalTask.getPod()) : "");
            row.setAttribute("floor", personalTask.getFloor() > 0 ? String.valueOf(personalTask.getFloor()) : "");
            row.setAttribute("current_date", new SimpleDateFormat("dd.MM.yyyy").format(Calendar.getInstance().getTime()));
            if (hourList != null && task.getTargetDate() != null) {
                int hoursToEnd = TimeUtils.hourDelta((Calendar)TimeUtils.convertDateToCalendar((Date)new Date()), (Calendar)TimeUtils.convertDateToCalendar((Date)task.getTargetDate()));
                Iterator iterator = hourList.iterator();
                while (iterator.hasNext()) {
                    int hours = (Integer)iterator.next();
                    if (hoursToEnd <= 0 && colorMap.get(-1) != null) {
                        row.setAttribute("color", (String)colorMap.get(-1));
                        break;
                    }
                    if (hoursToEnd <= 0 || hoursToEnd >= hours || colorMap.get(hours) == null) continue;
                    row.setAttribute("color", (String)colorMap.get(hours));
                    break;
                }
            }
            StringBuffer executorsBuf = new StringBuffer();
            manager.loadExecutorList(task);
            for (Integer executorId : task.getExecutors()) {
                String title = executorMap.get(executorId);
                if (executorsBuf.length() > 0) {
                    executorsBuf.append(", ");
                }
                executorsBuf.append(title);
            }
            row.setAttribute("executors", executorsBuf.toString());
        }
        ServerUtils.prepareElementToSerialize((Node)data);
        Page.setRecordCount((Page)page, (int)manager.getTaskCount(filter));
        this.setPageAttribute(table, page);
        if ("npdf".equals(this.getParameter("ext")) || "opdf".equals(this.getParameter("ext")) || "zpdf".equals(this.getParameter("ext"))) {
            this.request.setAttribute("contentType", (Object)"binary");
            XSLManager.getInstance().transform((Source)new DOMSource(this.rootNode.getOwnerDocument()), xslt, (Result)FOUtils.renderSAXResult((OutputStream)this.response.getOutputStream(), (String)"application/pdf"));
        }
    }

    private String maskNull(String value) {
        return value != null ? value : "";
    }

    private Map<Integer, String> correctColors(ParameterMap map, List<Integer> hourList) throws BGMessageException {
        HashMap<Integer, String> colorMap = new HashMap<Integer, String>();
        for (int index = 0; index < hourList.size(); ++index) {
            int hour = hourList.get(index);
            String colStr = map.get(Integer.toString(hour), null);
            this.addColor(colStr, hour, colorMap);
            if (colStr != null) continue;
            int step = Integer.valueOf(128) / hourList.size();
            String defColor = Integer.toHexString(index * step + 127);
            colorMap.put(hour, defColor + defColor + defColor);
        }
        this.addColor(this.plugin.getSetup().get("task.bad.color", null), -1, colorMap);
        return colorMap;
    }

    private void addColor(String colStr, int hour, Map<Integer, String> colorMap) throws BGMessageException {
        if (colStr != null) {
            try {
                Integer.valueOf(colStr, 16);
                colorMap.put(hour, colStr);
            }
            catch (NumberFormatException e) {
                throw new BGMessageException("\u041d\u0435 \u0432\u0435\u0440\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0446\u0432\u0435\u0442 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 CRM. \u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0446\u0432\u0435\u0442 - " + colStr);
            }
        }
    }
}

