/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCardCopy;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.LoggingAbstractManager;

public class UserCardCopyManager
extends LoggingAbstractManager<UserCardCopy> {
    private UserCardManager userCardManager;

    public UserCardCopyManager(Connection con, int moduleId, int userId) {
        super(con, "user_card_copy", moduleId, userId);
        this.userCardManager = new UserCardManager(con, moduleId, userId);
    }

    public List<UserCardCopy> getList(int uid) throws BGException {
        if (uid < 0) {
            return this.list(null, "date1", new Object[0]);
        }
        return this.list("uid=?", "date1", new Object[]{uid});
    }

    public List<UserCardCopy> getListByDate(int uid, LocalDate date) throws BGException {
        if (uid < 0) {
            return this.list("(date1 IS NULL OR date1<=?) AND (date2 IS NULL or ?<=date2)", "", new Object[]{date, date});
        }
        return this.list("(uid=?) AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL or ?<=date2)", "", new Object[]{uid, date, date});
    }

    protected void updateImpl(UserCardCopy b) throws BGException, SQLException {
        String query = null;
        PreparedStatement ps = null;
        if (!this.setParentCard(b)) {
            throw new BGMessageException("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e, \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430");
        }
        if (!TimeUtils.periodInRange((Date)b.getDate1(), (Date)b.getDate2(), (Date)b.getParentCard().getDate1(), (Date)b.getParentCard().getDate2())) {
            throw new BGMessageException("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e, \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043a\u043e\u043f\u0438\u0438 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u044b");
        }
        if (b.getId() <= 0) {
            query = "INSERT INTO " + this.tableName + " (uid, date1, date2, comment) VALUES (?, ?, ?, ?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            query = "UPDATE " + this.tableName + " SET uid=?, date1=?, date2=?, comment=?  WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(5, b.getId());
        }
        ps.setInt(1, b.getParentCardId());
        ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)b.getDate1()));
        ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)b.getDate2()));
        ps.setString(4, b.getComment());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }

    public void deleteCardCopies(int uid) throws BGException {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE uid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, uid);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    public int getCopyCount(int uid, Date date) throws BGException {
        int result = 0;
        try {
            String query = "SELECT count(1) FROM " + this.tableName + " WHERE (uid=?) AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL or ?<=date2)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, uid);
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)date));
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected UserCardCopy getFromRS(ResultSet rs) throws SQLException, BGException {
        UserCardCopy copy = new UserCardCopy();
        copy.setId(rs.getInt("id"));
        copy.setParentCardId(rs.getInt("uid"));
        copy.setDate1(TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("date1")));
        copy.setDate2(TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("date2")));
        copy.setComment(rs.getString("comment"));
        copy.setParentCard((UserCard)this.userCardManager.get(copy.getParentCardId()));
        return copy;
    }

    protected boolean setParentCard(UserCardCopy b) throws BGException {
        if (b.getParentCard() == null && b.getParentCardId() > 0) {
            try {
                b.setParentCard((UserCard)this.userCardManager.get(b.getParentCardId()));
            }
            catch (BGException ex) {
                return false;
            }
        }
        return true;
    }

    public void close() throws BGException {
        super.close();
        this.userCardManager.close();
    }
}

