/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.driver.zatol;

import java.io.UnsupportedEncodingException;
import jssc.SerialPortException;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.zatol.AtolPrinterType;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.zatol.ModePOS;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.zatol.PrinterAtolErrorException;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.zatol.PrinterStatus;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.PrinterConnectException;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.BGByteBuffer;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.DeviceSerialPort;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.SerialParameters;
import ru.bitel.common.Utils;

public class AtolPrinter
extends DeviceSerialPort {
    private static final byte SS_ENQ = 5;
    private static final byte SS_ACK = 6;
    private static final byte SS_STX = 2;
    private static final byte SS_ETX = 3;
    private static final byte SS_EOT = 4;
    private static final byte SS_NAK = 21;
    private static final byte SS_DLE = 16;
    private static final int T1 = 500;
    private static final int T2 = 2000;
    private static final int T3 = 500;
    private static final int T4 = 500;
    private static final int T5 = 120000;
    private static final int T6 = 500;
    private static final int T7 = 500;
    private Logger logTrace;
    private AtolPrinterType printerType = null;
    private BGByteBuffer bOperPassword = null;
    private BGByteBuffer bAccessPassword = null;

    public AtolPrinter(SerialParameters portParam, AtolPrinterType printerType, long accessPassword, long operPassword, Logger logTrace) {
        super(portParam);
        this.printerType = printerType;
        this.bAccessPassword = AtolPrinter.encodeNumber(accessPassword, 2);
        this.bOperPassword = AtolPrinter.encodeNumber(operPassword, 4);
        this.logTrace = logTrace;
    }

    /*
     * Exception decompiling
     */
    private BGByteBuffer _transferPacket(BGByteBuffer packet) throws PrinterConnectException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 13[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final void _testUPacket(BGByteBuffer packet) throws PrinterAtolErrorException {
        if (packet.getBytes().length == 3 && packet.getBytes()[0] == 85 && packet.getBytes()[1] != 0 && packet.getBytes()[2] == 0) {
            throw new PrinterAtolErrorException(BGByteBuffer.byte2int(packet.getBytes()[1]));
        }
    }

    private static BGByteBuffer encodeNumber(long number, int bytes) {
        byte[] digits = new byte[bytes];
        for (int n = 0; n < bytes; ++n) {
            long digit1 = number % 10L;
            long digit2 = (number /= 10L) % 10L;
            number /= 10L;
            digits[bytes - n - 1] = (byte)(digit2 * 16L + digit1);
        }
        return new BGByteBuffer(digits);
    }

    private static long decodeNumber(BGByteBuffer buffer) {
        long number = 0L;
        long mul = 1L;
        for (int n = 0; n < buffer.getBytes().length; ++n) {
            byte b = buffer.getBytes()[buffer.getBytes().length - n - 1];
            int digit1 = b % 16;
            number += (long)digit1 * mul;
            int digit2 = b / 16;
            number += (long)digit2 * (mul *= 10L);
            mul *= 10L;
        }
        return number;
    }

    private static BGByteBuffer encodeString(String string, int maxbytes) {
        if (string != null) {
            try {
                byte[] msgbytes = string.getBytes("866");
                int bytes = Math.min(maxbytes, msgbytes.length);
                return new BGByteBuffer(msgbytes, bytes);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getName() throws PrinterConnectException, PrinterAtolErrorException {
        String name = null;
        this.$trace("get name");
        BGByteBuffer reply = this._transferPacket(new BGByteBuffer(-91));
        AtolPrinter._testUPacket(reply);
        byte errcode = reply.popBeginByte();
        if (errcode != 0) {
            throw new PrinterConnectException("error code ('" + errcode + "') not 0");
        }
        byte protver = reply.popBeginByte();
        if (protver != 1) {
            throw new PrinterConnectException("protocol version " + protver + " unsupported");
        }
        byte type = reply.popBeginByte();
        Object stype = null;
        switch (type) {
            case 0: {
                stype = "\u0422\u0438\u043f \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d";
                break;
            }
            case 1: {
                stype = "\u041a\u041a\u041c";
                break;
            }
            case 2: {
                stype = "\u0412\u0435\u0441\u044b";
                break;
            }
            case 3: {
                stype = "\u0411\u043b\u043e\u043a Memo PlusTM";
                break;
            }
            case 4: {
                stype = "\u041f\u0440\u0438\u043d\u0442\u0435\u0440 \u044d\u0442\u0438\u043a\u0435\u0442\u043e\u043a";
                break;
            }
            case 5: {
                stype = "\u0422\u0435\u0440\u043c\u0438\u043d\u0430\u043b \u0441\u0431\u043e\u0440\u0430 \u0434\u0430\u043d\u043d\u044b\u0445";
                break;
            }
            case 6: {
                stype = "\u0414\u0438\u0441\u043f\u043b\u0435\u0439 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f";
                break;
            }
            case 7: {
                stype = "\u0421\u043a\u0430\u043d\u0435\u0440 \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434\u0430, PIN-\u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u0430, \u0440\u0435\u0441\u0442\u043e\u0440\u0430\u043d\u043d\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u0430";
                break;
            }
            default: {
                stype = "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e (" + type + ")";
            }
        }
        byte model = reply.popBeginByte();
        Object smodel = null;
        smodel = type == 1 ? AtolPrinter.getPOSModelName(model) : "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e: \u0442\u0438\u043f '" + type + "', \u043c\u043e\u0434\u0435\u043b\u044c '" + model + "'";
        StringBuilder smode = new StringBuilder();
        int modebin = reply.popBeginByte() * 256 + reply.popBeginByte();
        if (type == 1) {
            if ((modebin & 0x8000) != 0) {
                smode.append("Off-Line;");
            }
            if ((modebin & 0x4000) != 0) {
                smode.append("On-Line;");
            }
            if ((modebin & 0x1000) != 0) {
                smode.append("\u0424\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440;");
            }
            if ((modebin & 0x800) != 0) {
                smode.append("\u0424\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u043b\u0430\u0442\u0430;");
            }
        }
        if (smode.length() == 0) {
            smode.append("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e (\u043c\u0430\u0441\u043a\u0430 " + modebin + ")");
        }
        int ver = (int)AtolPrinter.decodeNumber(reply.popBegin(1));
        int subver = (int)AtolPrinter.decodeNumber(reply.popBegin(1));
        int langcode = (int)AtolPrinter.decodeNumber(reply.popBegin(1));
        int build = (int)AtolPrinter.decodeNumber(reply.popBegin(2));
        String sver = String.valueOf(ver) + "." + String.valueOf(subver) + "." + String.valueOf(build) + "." + AtolPrinter.getLangTableName(langcode);
        String sname = null;
        try {
            sname = new String(reply.getBytes(), "866");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        name = sname + " (\u0442\u0438\u043f:'" + (String)stype;
        name = name + "', \u043c\u043e\u0434\u0435\u043b\u044c:'" + (String)smodel;
        name = name + "', \u0440\u0435\u0436\u0438\u043c(\u044b):'" + String.valueOf(smode);
        name = name + "', \u0432\u0435\u0440\u0441\u0438\u044f:'" + sver;
        name = name + "')";
        return name;
    }

    public void buzzer() throws PrinterAtolErrorException, PrinterConnectException {
        this._transferPacket(new BGByteBuffer(71));
    }

    public PrinterStatus getStatus() throws PrinterAtolErrorException, PrinterConnectException {
        PrinterStatus ps = new PrinterStatus();
        this.$trace("get status");
        BGByteBuffer reply = this._transferPacket(new BGByteBuffer(63));
        AtolPrinter._testUPacket(reply);
        byte b = reply.popBeginByte();
        if (b != 68 || reply.getBytes().length != 29) {
            throw new PrinterConnectException("protocol error: strange reply to command \"get status\"");
        }
        ps.cashman = (short)AtolPrinter.decodeNumber(reply.popBegin(1));
        ps.number = (short)AtolPrinter.decodeNumber(reply.popBegin(1));
        int ye = (int)AtolPrinter.decodeNumber(reply.popBegin(1));
        int mo = (int)AtolPrinter.decodeNumber(reply.popBegin(1));
        int da = (int)AtolPrinter.decodeNumber(reply.popBegin(1));
        int ho = (int)AtolPrinter.decodeNumber(reply.popBegin(1));
        int mi = (int)AtolPrinter.decodeNumber(reply.popBegin(1));
        int se = (int)AtolPrinter.decodeNumber(reply.popBegin(1));
        StringBuilder sb = new StringBuilder();
        sb.append(da).append(".").append(mo).append(".").append(ye).append(" ").append(ho).append(":").append(mi).append(":").append(se);
        ps.datetime = sb.toString();
        byte flags = reply.popBeginByte();
        ps.isFiscal = Utils.testBit((byte)flags, (int)0);
        ps.isDayOpen = Utils.testBit((byte)flags, (int)1);
        ps.isCashBoxNotOpen = Utils.testBit((byte)flags, (int)2);
        ps.isWeightPaperHave = Utils.testBit((byte)flags, (int)3);
        ps.isCoverOpen = Utils.testBit((byte)flags, (int)5);
        ps.isBatteriesLow = Utils.testBit((byte)flags, (int)7);
        ps.serial = AtolPrinter.decodeNumber(reply.popBegin(4));
        ps.modelName = AtolPrinter.getPOSModelName(reply.popBeginByte());
        reply.popBegin(2);
        byte mode = reply.popBeginByte();
        ps.mode = ModePOS.getMode(mode & 0xF, (mode & 0xFFFFFFF0) >> 4);
        ps.checkNumber = (int)AtolPrinter.decodeNumber(reply.popBegin(2));
        ps.dayNumber = (int)AtolPrinter.decodeNumber(reply.popBegin(2));
        reply.popBeginByte();
        ps.checkSum = AtolPrinter.decodeNumber(reply.popBegin(5));
        ps.decimalDot = (short)AtolPrinter.decodeNumber(reply.popBegin(1));
        ps.port = (short)AtolPrinter.decodeNumber(reply.popBegin(1));
        ps.cashTotal = this.getTotal();
        ps.lastX = this.getLastX();
        return ps;
    }

    private long getTotal() throws PrinterConnectException, PrinterAtolErrorException {
        this.$trace("get total");
        BGByteBuffer reply = this._transferPacket(new BGByteBuffer(77));
        AtolPrinter._testUPacket(reply);
        byte b = reply.popBeginByte();
        if (b != 77 || reply.getBytes().length != 7) {
            throw new PrinterConnectException("protocol error: strange reply to command \"get total\"");
        }
        return AtolPrinter.decodeNumber(reply);
    }

    private long getLastX() throws PrinterConnectException, PrinterAtolErrorException {
        this.$trace("get last x");
        BGByteBuffer reply = this._transferPacket(new BGByteBuffer(88));
        AtolPrinter._testUPacket(reply);
        byte b = reply.popBeginByte();
        byte e = reply.popBeginByte();
        if (b != 85 || reply.getBytes().length != 7 && reply.getBytes().length != 14) {
            throw new PrinterConnectException("protocol error: strange reply to command \"get last x\"");
        }
        if (e != 0) {
            throw new PrinterAtolErrorException(BGByteBuffer.byte2int(e));
        }
        reply = reply.popBegin(7);
        return AtolPrinter.decodeNumber(reply);
    }

    public void sale(long price, long quantity, int division, String text) throws PrinterConnectException, PrinterAtolErrorException {
        this.$trace("sale(" + price + ", " + quantity + ", " + division + ", " + text + ")");
        this.$trace("register flag=1");
        BGByteBuffer cmd = new BGByteBuffer(82);
        cmd.pushEnd((byte)1);
        cmd.pushEnd(AtolPrinter.encodeNumber(price, 5));
        cmd.pushEnd(AtolPrinter.encodeNumber(quantity, 5));
        cmd.pushEnd(AtolPrinter.encodeNumber(division, 1));
        BGByteBuffer reply = this._transferPacket(cmd);
        AtolPrinter._testUPacket(reply);
        if (text != null) {
            this.printLine(text);
        }
        this.$trace("register flag=0");
        cmd = new BGByteBuffer(82);
        cmd.pushEnd((byte)0);
        cmd.pushEnd(AtolPrinter.encodeNumber(price, 5));
        cmd.pushEnd(AtolPrinter.encodeNumber(quantity, 5));
        cmd.pushEnd(AtolPrinter.encodeNumber(division, 1));
        reply = this._transferPacket(cmd);
        AtolPrinter._testUPacket(reply);
    }

    public void closeCheck(long sum, int type) throws PrinterConnectException, PrinterAtolErrorException {
        this.$trace("close check");
        BGByteBuffer cmd = new BGByteBuffer(74);
        cmd.pushEnd((byte)0);
        cmd.pushEnd(AtolPrinter.encodeNumber(type, 1));
        cmd.pushEnd(AtolPrinter.encodeNumber(sum, 5));
        BGByteBuffer reply = this._transferPacket(cmd);
        AtolPrinter._testUPacket(reply);
    }

    public boolean testOnOpenCheckAndNulled() throws PrinterConnectException, PrinterAtolErrorException {
        boolean isCheckOpen = false;
        if (this.isCheckOpen()) {
            isCheckOpen = true;
            BGByteBuffer reply = this._transferPacket(new BGByteBuffer(89));
            AtolPrinter._testUPacket(reply);
        }
        return isCheckOpen;
    }

    private boolean isCheckOpen() throws PrinterConnectException, PrinterAtolErrorException {
        this.$trace("isCheckOpen()");
        this.$trace("get status");
        BGByteBuffer reply = this._transferPacket(new BGByteBuffer(63));
        AtolPrinter._testUPacket(reply);
        byte b = reply.popBeginByte();
        if (b != 68 || reply.getBytes().length != 29) {
            throw new PrinterConnectException("protocol error: strange reply to command \"get status\"");
        }
        byte sc = reply.getBytes()[21];
        return (sc & 3) != 0;
    }

    void printLine(String text) throws PrinterConnectException, PrinterAtolErrorException {
        this.$trace("print line");
        BGByteBuffer cmd = new BGByteBuffer(76);
        cmd.pushEnd(AtolPrinter.encodeString(text, this.printerType.getStrLen()));
        BGByteBuffer reply = this._transferPacket(cmd);
        AtolPrinter._testUPacket(reply);
    }

    public void openCheck() throws PrinterAtolErrorException, PrinterConnectException {
        this.changeMode(ModePOS.m_1_0);
        if (this.isCheckOpen()) {
            throw new PrinterAtolErrorException("\u041d\u0435\u043b\u044c\u0437\u044f \u043d\u0430\u0447\u0430\u0442\u044c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044e - \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0447\u0435\u043a\u0430 \u043d\u0435 '\u0447\u0435\u043a \u0437\u0430\u043a\u0440\u044b\u0442'");
        }
    }

    public void xreport(int type) throws PrinterConnectException, PrinterAtolErrorException {
        PrinterStatus ps;
        this.changeMode(ModePOS.m_2_0);
        this.$trace("xreport");
        BGByteBuffer cmd = new BGByteBuffer(103);
        cmd.pushEnd(AtolPrinter.encodeNumber(type, 1));
        BGByteBuffer reply = this._transferPacket(cmd);
        AtolPrinter._testUPacket(reply);
        do {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ps = this.getStatePOS();
        } while (ps.mode == ModePOS.m_2_2);
        if (ps.mode == ModePOS.m_2_0) {
            if (ps.flPrinterNoPaper) {
                throw new PrinterAtolErrorException("\u041d\u0435\u0442 \u0431\u0443\u043c\u0430\u0433\u0438");
            }
            if (ps.flPrinterNoLink) {
                throw new PrinterAtolErrorException("\u041d\u0435\u0442 \u0441\u0432\u044f\u0437\u0438 \u0441 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u043e\u043c \u0447\u0435\u043a\u0430");
            }
        } else {
            throw new PrinterAtolErrorException("\u0421\u043d\u044f\u0442\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u0430 \u043f\u0440\u0435\u0440\u0432\u0430\u043b\u043e\u0441\u044c");
        }
    }

    public void zreport() throws PrinterConnectException, PrinterAtolErrorException {
        PrinterStatus ps;
        this.changeMode(ModePOS.m_3_0);
        this.$trace("zreport");
        BGByteBuffer reply = this._transferPacket(new BGByteBuffer(90));
        AtolPrinter._testUPacket(reply);
        do {
            try {
                Thread.sleep(333L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ps = this.getStatePOS();
        } while (ps.mode == ModePOS.m_3_2);
        if (ps.mode != ModePOS.m_7_1) {
            if (ps.flPrinterNoPaper) {
                throw new PrinterAtolErrorException("\u041d\u0435\u0442 \u0431\u0443\u043c\u0430\u0433\u0438");
            }
            if (ps.flPrinterNoLink) {
                throw new PrinterAtolErrorException("\u041d\u0435\u0442 \u0441\u0432\u044f\u0437\u0438 \u0441 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u043e\u043c \u0447\u0435\u043a\u0430");
            }
            if (ps.flPrinterMechError) {
                throw new PrinterAtolErrorException("\u041c\u0435\u0445\u0430\u043d\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0447\u0430\u0442\u0430\u044e\u0449\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
            }
            throw new PrinterAtolErrorException("\u0421\u043d\u044f\u0442\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u0430 \u043f\u0440\u0435\u0440\u0432\u0430\u043b\u043e\u0441\u044c");
        }
        while (this.getStatePOS().mode == ModePOS.m_7_1) {
            try {
                Thread.sleep(333L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void cut() throws PrinterConnectException, PrinterAtolErrorException {
        BGByteBuffer cmd = new BGByteBuffer(117);
        cmd.pushEnd((byte)0);
        BGByteBuffer reply = this._transferPacket(cmd);
        AtolPrinter._testUPacket(reply);
    }

    private PrinterStatus getStatePOS() throws PrinterConnectException, PrinterAtolErrorException {
        this.$trace("get state POS");
        BGByteBuffer reply = this._transferPacket(new BGByteBuffer(69));
        byte b = reply.popBeginByte();
        if (b != 85 || reply.getBytes().length != 2) {
            throw new PrinterAtolErrorException("protocol error: error reply");
        }
        byte mode = reply.popBeginByte();
        byte flags = reply.popBeginByte();
        PrinterStatus ps = new PrinterStatus();
        ps.mode = ModePOS.getMode(mode & 0xF, (mode & 0xFFFFFFF0) >> 4);
        ps.flPrinterNoPaper = Utils.testBit((byte)flags, (int)0);
        ps.flPrinterNoLink = Utils.testBit((byte)flags, (int)1);
        ps.flPrinterMechError = Utils.testBit((byte)flags, (int)2);
        return ps;
    }

    private void changeMode(ModePOS mode) throws PrinterAtolErrorException, PrinterConnectException {
        this.$trace("leave mode");
        BGByteBuffer reply = this._transferPacket(new BGByteBuffer(72));
        AtolPrinter._testUPacket(reply);
        PrinterStatus ps = this.getStatePOS();
        if (ps.mode != ModePOS.m_0_0) {
            throw new PrinterAtolErrorException("\u041a\u041a\u041c \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0432\u044b\u0439\u0442\u0438 \u0438\u0437 \u0440\u0435\u0436\u0438\u043c\u0430 " + ps.mode.toString());
        }
        if (mode != ModePOS.m_0_0) {
            this.$trace("enter mode " + mode.getMode());
            BGByteBuffer cmd = new BGByteBuffer(86);
            cmd.pushEnd(AtolPrinter.encodeNumber(mode.getMode(), 1));
            cmd.pushEnd(this.bOperPassword);
            reply = this._transferPacket(cmd);
            AtolPrinter._testUPacket(reply);
        }
    }

    public BGByteBuffer pureCmd(String hexDump) throws PrinterConnectException {
        this.$trace("pure command");
        return this._transferPacket(new BGByteBuffer(hexDump));
    }

    public synchronized void saleBack(long price, long quantity, String text) throws PrinterConnectException, PrinterAtolErrorException {
        this.$trace("saleback flag=1");
        BGByteBuffer cmd = new BGByteBuffer(87);
        cmd.pushEnd((byte)1);
        cmd.pushEnd(AtolPrinter.encodeNumber(price, 5));
        cmd.pushEnd(AtolPrinter.encodeNumber(quantity, 5));
        BGByteBuffer reply = this._transferPacket(cmd);
        AtolPrinter._testUPacket(reply);
        if (text != null) {
            this.printLine(text);
        }
        this.$trace("saleback flag=0");
        cmd = new BGByteBuffer(87);
        cmd.pushEnd((byte)0);
        cmd.pushEnd(AtolPrinter.encodeNumber(price, 5));
        cmd.pushEnd(AtolPrinter.encodeNumber(quantity, 5));
        reply = this._transferPacket(cmd);
        AtolPrinter._testUPacket(reply);
    }

    public void openDay(String text) throws PrinterConnectException, PrinterAtolErrorException {
        this.changeMode(ModePOS.m_1_0);
        this.$trace("open day");
        BGByteBuffer cmd = new BGByteBuffer(-102);
        cmd.pushEnd((byte)0);
        if (text != null) {
            cmd.pushEnd(AtolPrinter.encodeString(text, this.printerType.getStrLen()));
        }
        BGByteBuffer reply = this._transferPacket(cmd);
        AtolPrinter._testUPacket(reply);
    }

    public void open() throws PrinterConnectException {
        try {
            super._open();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.close();
            throw new PrinterConnectException(e.toString());
        }
    }

    public void close() {
        try {
            super._close();
        }
        catch (SerialPortException e) {
            this.logTrace.error("error close", (Throwable)e);
        }
    }

    @Override
    protected void _send(byte b) throws SerialPortException {
        this.$trace("-> " + AtolPrinter.$int2str(BGByteBuffer.byte2int(b)));
        super._send(b);
    }

    @Override
    protected void _send(BGByteBuffer buffer) throws SerialPortException {
        this.$trace("-> " + buffer.toString());
        super._send(buffer);
    }

    @Override
    protected int _recv() throws SerialPortException {
        int i = super._recv();
        this.$trace("<- " + AtolPrinter.$int2str(i));
        return i;
    }

    private static String $int2str(int i) {
        switch (i) {
            case -1: {
                return "<not>";
            }
            case 5: {
                return "ENQ";
            }
            case 6: {
                return "ACK";
            }
            case 2: {
                return "STX";
            }
            case 3: {
                return "ETX";
            }
            case 4: {
                return "EOT";
            }
            case 21: {
                return "NAK";
            }
            case 16: {
                return "DLE";
            }
        }
        Object shex = Integer.toHexString(i).toUpperCase();
        if (((String)shex).length() == 1) {
            shex = "0" + (String)shex;
        }
        return shex;
    }

    private void $trace(String message) {
        if (this.logTrace != null) {
            this.logTrace.trace("atol-driver: " + message);
        }
    }

    private static final String getLangTableName(int code) {
        switch (code) {
            case 0: {
                return "\u0420\u0443\u0441\u0441\u043a\u0430\u044f";
            }
            case 1: {
                return "\u0410\u0440\u043c\u044f\u043d\u0441\u043a\u0430\u044f";
            }
            case 2: {
                return "\u041c\u043e\u043b\u0434\u0430\u0432\u0441\u043a\u0430\u044f";
            }
            case 3: {
                return "\u0423\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0430\u044f";
            }
            case 4: {
                return "\u041b\u0438\u0442\u043e\u0432\u0441\u043a\u0430\u044f";
            }
            case 5: {
                return "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u043a\u0430\u044f";
            }
            case 6: {
                return "\u041c\u043e\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0430\u044f";
            }
            case 7: {
                return "\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0430\u044f";
            }
            case 8: {
                return "\u041b\u0430\u0442\u0432\u0438\u0439\u0441\u043a\u0430\u044f";
            }
            case 9: {
                return "\u0413\u0440\u0443\u0437\u0438\u043d\u0441\u043a\u0430\u044f";
            }
            case 10: {
                return "\u041a\u0430\u0437\u0430\u0445\u0441\u043a\u0430\u044f";
            }
            case 11: {
                return "\u042d\u0441\u0442\u043e\u043d\u0441\u043a\u0430\u044f";
            }
            case 12: {
                return "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u043a\u0430\u044f";
            }
            case 13: {
                return "\u041a\u0438\u0440\u0433\u0438\u0437\u0441\u043a\u0430\u044f";
            }
            case 14: {
                return "\u0422\u0430\u0434\u0436\u0438\u043a\u0441\u043a\u0430\u044f";
            }
            case 15: {
                return "\u0423\u0437\u0431\u0435\u043a\u0441\u043a\u0430\u044f";
            }
            case 16: {
                return "\u041f\u043e\u043b\u044c\u0441\u043a\u0430\u044f";
            }
            case 17: {
                return "\u0420\u0443\u043c\u044b\u043d\u0441\u043a\u0430\u044f";
            }
            case 18: {
                return "\u0411\u043e\u043b\u0433\u0430\u0440\u0441\u043a\u0430\u044f";
            }
            case 19: {
                return "\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0430\u044f";
            }
            case 20: {
                return "\u0424\u0438\u043d\u0441\u043a\u0430\u044f";
            }
        }
        return "?" + String.valueOf(code);
    }

    private static final String getPOSModelName(byte model) {
        Object smodel = null;
        switch (model) {
            case 13: {
                smodel = "\u0422\u0440\u0438\u0443\u043c-\u0424";
                break;
            }
            case 14: {
                smodel = "\u0424\u0415\u041b\u0418\u041a\u0421-\u0420 \u0424";
                break;
            }
            case 15: {
                smodel = "\u0424\u0415\u041b\u0418\u041a\u0421-02\u041a (\u0424\u0415\u041b\u0418\u041a\u0421-02\u0424)";
                break;
            }
            case 16: {
                smodel = "\u00ab\u041c\u0435\u0440\u043a\u0443\u0440\u0438\u0439-140\u0424\u00bb (\u0424\u0415\u041b\u0418\u041a\u0421-03\u0424)";
                break;
            }
            case 20: {
                smodel = "\u0422\u041e\u0420\u041d\u0410\u0414\u041e";
                break;
            }
            case 22: {
                smodel = "\u041c\u0435\u0440\u043a\u0443\u0440\u0438\u0439-130";
                break;
            }
            case 23: {
                smodel = "\u041c\u0435\u0440\u043a\u0443\u0440\u0438\u0439 MS-K, \u0432\u0435\u0440\u0441\u0438\u044f 02";
                break;
            }
            case 24: {
                smodel = "\u0424\u0415\u041b\u0418\u041a\u0421-\u0420 \u041a, \u0432\u0435\u0440\u0441\u0438\u044f 01";
                break;
            }
            case 27: {
                smodel = "\u0424\u0415\u041b\u0418\u041a\u0421-3\u0421\u041a, \u0432\u0435\u0440\u0441\u0438\u044f 01";
                break;
            }
            case 29: {
                smodel = "FPrint-01K";
                break;
            }
            case 30: {
                smodel = "FPrint-02K";
                break;
            }
            case 31: {
                smodel = "FPrint-03K";
                break;
            }
            case 32: {
                smodel = "FPrint-88K";
                break;
            }
            case 33: {
                smodel = "BIXOLON-01K";
                break;
            }
            case 34: {
                smodel = "\u041c\u0418\u041a\u0420\u041e-\u0424\u0420-01\u041a";
                break;
            }
            case 35: {
                smodel = "FPrint-5200K";
                break;
            }
            case 36: {
                smodel = "Flaton-11K";
                break;
            }
            case 37: {
                smodel = "PayVKP-80K";
                break;
            }
            case 38: {
                smodel = "PayPPU-700K";
                break;
            }
            case 39: {
                smodel = "PayCTS-2000K";
                break;
            }
            case 63: {
                smodel = "FPrint-22\u041f\u0422\u041a";
                break;
            }
            case 67: {
                smodel = "FPrint-11\u041f\u0422\u041a";
                break;
            }
            case 69: {
                smodel = "FPrint-77\u041f\u0422\u041a";
                break;
            }
            case 72: {
                smodel = "FPrint-190\u0410\u041a";
            }
        }
        if (smodel == null) {
            smodel = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u041a\u041a\u041c, \u043a\u043e\u0434 " + model;
        }
        return smodel;
    }

    public String touch() {
        try {
            this._transferPacket(new BGByteBuffer(-91));
        }
        catch (Exception e) {
            return "error transfer: " + e.toString();
        }
        String name = null;
        try {
            name = this.getName();
        }
        catch (Exception e) {
            return "ok transfer; error get name: " + e.toString();
        }
        return "ok transfer; name: " + name;
    }
}

