/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.service;

import au.com.bytecode.opencsv.CSVWriter;
import bitel.billing.server.contract.bean.ContractManager;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.dto.FileDto;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.modules.card.common.bean.DealerPayment;
import ru.bitel.bgbilling.modules.card.common.service.CardService;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.bgbilling.modules.card.server.bean.CardManager;
import ru.bitel.bgbilling.modules.card.server.bean.DealerDao;
import ru.bitel.bgbilling.modules.card.server.bean.DealerPaymentDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.localize.Localizer;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.card.common.service.CardService")
@XmlSeeAlso(value={FilterEntityAttr.class})
public class CardServiceImpl
extends AbstractService
implements CardService {
    public Result<DealerPayment> paymentList(Set<Integer> dealerIds, Date dateFrom, Date dateTo, int type, String trans, String contract, long contractGroups, List<FilterEntityAttr> contractFilter, Page page) throws BGException {
        if (dateFrom == null) {
            throw new BGIllegalArgumentException("dateFrom is null");
        }
        return (Result)this.tryReturn(() -> {
            DealerPaymentDao dealerPaymentDao = new DealerPaymentDao(this.getConnection(), this.moduleId, dateFrom);
            return dealerPaymentDao.list(dealerIds, dateFrom, dateTo, type, trans, contract, contractGroups, contractFilter, page);
        });
    }

    public FileDto paymentListExport(Set<Integer> dealerIds, Date dateFrom, Date dateTo, int type, String trans, String contract, long contractGroups, List<FilterEntityAttr> contractFilter, Page page) throws BGException {
        if (dateFrom == null) {
            throw new BGIllegalArgumentException("dateFrom is null");
        }
        return (FileDto)this.tryReturn(() -> {
            DealerPaymentDao dealerPaymentDao = new DealerPaymentDao(this.getConnection(), this.moduleId, dateFrom);
            PipedInputStream input = new PipedInputStream(51200);
            final PipedOutputStream ouput = new PipedOutputStream(input);
            final Result<DealerPayment> result = dealerPaymentDao.list(dealerIds, dateFrom, dateTo, type, trans, contract, contractGroups, contractFilter, page);
            new Thread(){

                @Override
                public void run() {
                    try {
                        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                        char decimalSeparator = CardServiceImpl.this.getModuleSetup().getChar("format.decimal.separator", Localizer.getDecimalFormatSymbols().getDecimalSeparator());
                        dfs.setDecimalSeparator(decimalSeparator);
                        DecimalFormat df = new DecimalFormat("########0.00", dfs);
                        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)ouput, StandardCharsets.UTF_8);
                        CSVWriter csv = new CSVWriter((Writer)writer, CardServiceImpl.this.getModuleSetup().get("csv.separator", ";").charAt(0));
                        for (DealerPayment payment : result.getList()) {
                            csv.writeNext(new String[]{payment.getTransId(), payment.getDealerTitle(), payment.getContractTitle(), payment.getContractComment(), TimeUtils.format((Date)payment.getDateTime(), (String)"dd.MM.yyyy HH:mm:ss"), df.format(payment.getSumma()), payment.getPaymentComment(), switch (payment.getStatus()) {
                                case 1 -> "\u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d";
                                case 0 -> "\u043e\u0442\u043c\u0435\u043d\u0435\u043d";
                                case -1 -> "\u0443\u0434\u0430\u043b\u0435\u043d";
                                default -> "-";
                            }}, false);
                        }
                        csv.flush();
                        csv.close();
                    }
                    catch (IOException ex) {
                        CardServiceImpl.this.logError(ex);
                    }
                }
            }.start();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(input.readAllBytes());
            outputStream.flush();
            FileDto fileDto = new FileDto();
            fileDto.setContentType("text/csv");
            fileDto.setFileName("export.csv");
            fileDto.setData(Base64.getEncoder().encodeToString(outputStream.toByteArray()));
            return fileDto;
        });
    }

    public List<Dealer> dealerList(int type) throws BGException {
        return (List)this.tryReturn(() -> new DealerDao(this.getSlaveConnection(), this.moduleId).list(type));
    }

    public void cardActivateForPayment(int contractId, String number, String pin) throws BGException {
        if (Utils.isBlankString((String)number)) {
            throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u043a\u0430\u0440\u0442\u044b!", "card.activate.invalidNumber");
        }
        if (Utils.isBlankString((String)pin)) {
            throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c (PIN-\u043a\u043e\u0434) \u043a\u0430\u0440\u0442\u044b!", "card.activate.invalidPin");
        }
        this.tryCall(() -> {
            boolean is_pasw_valid;
            CardManager cardManager = new CardManager(this.getConnection(), this.moduleId);
            Card card = cardManager.findCard(number);
            if (card == null) {
                this.getLogger().debug("Card not found");
                throw new BGMessageException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043a\u0430\u0440\u0442\u044b \u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c (PIN-\u043a\u043e\u0434)!", "card.activate.notFound");
            }
            boolean bl = is_pasw_valid = Utils.getDigest((String)pin, (String)"cp1251").equals(card.getCardPinCode()) || pin.equals(card.getCardPinCode());
            if (!is_pasw_valid) {
                this.getLogger().debug("Card password error");
                throw new BGMessageException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043a\u0430\u0440\u0442\u044b \u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c (PIN-\u043a\u043e\u0434)!", "card.activate.passwordError");
            }
            ContractManager contractManager = new ContractManager(this.getConnection());
            this.getLogger().debug("Card found, checking..");
            this.checkCard(contractManager, card, contractId);
            Connection con = this.context.getConnection();
            card.setContractId(contractId);
            if (cardManager.activated(card, 3)) {
                Payment payment = Payment.builder().setContractId(contractId).setTypeId(card.getPaymentType()).setUserId(this.userId).setSum(new BigDecimal(card.getSumma())).setComment("N " + card.getId()).setDate(new Date()).build();
                new PaymentDao(con).update((Object)payment);
                Contract contract = this.getContract(contractId);
                con.commit();
                try (BalanceUtils bu = new BalanceUtils(con);){
                    bu.updateBalance(payment.getDate(), contract);
                }
                this.context.publishAfterCommit((Event)new PaymentEvent(this.userId, payment));
                this.context.publishAfterCommit((Event)new ContractBalanceChangedEvent(contract.getId(), 3, payment.getSum()));
            }
        });
    }

    private void checkCard(ContractManager contractManager, Card card, int contractId) throws BGException {
        if (!card.checkPeriod(new Date())) {
            this.getLogger().debug("Card period error");
            throw new BGMessageException("\u0418\u0441\u0442\u0435\u043a \u0438\u043b\u0438 \u043d\u0435 \u043d\u0430\u0441\u0442\u0443\u043f\u0438\u043b \u043f\u0435\u0440\u0438\u043e\u0434 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043a\u0430\u0440\u0442\u044b!", "card.activate.periodError");
        }
        if (card.getStatus() == 0) {
            this.getLogger().debug("Card lock");
            throw new BGMessageException("\u041a\u0430\u0440\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430!", "card.activate.statusLock");
        }
        if (card.getStatus() == 3) {
            this.getLogger().debug("Card activated for balance");
            throw new BGMessageException("\u041a\u0430\u0440\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430!", "card.activate.statusActivatedForBalance");
        }
        if (card.getStatus() != 1) {
            this.getLogger().debug("Card status not active");
            throw new BGMessageException("\u041a\u0430\u0440\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430!", "card.activate.statusNotActivate");
        }
        if (!contractManager.checkContractService(contractId, card.getServicePayId(), new Date())) {
            throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u043e\u043f\u043e\u043b\u043d\u0435\u043d \u044d\u0442\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0439!", "card.activate.serviceError");
        }
    }

    public void dealerUpdate(Dealer dealer) throws BGException {
        this.tryCall(() -> new DealerDao(this.getConnection(), this.moduleId).update(dealer));
    }
}

