/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.botconfigure;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.BotConfigurePanel;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.DialogElemenCheckBoxFilterPanel;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.DialogElementEditor;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.ElementsListCellRenderer;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.ElementsListTransferHandler;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.event.DialogElementUpdateEvent;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.event.OpenDialogEditorEvent;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElementType;
import ru.bitel.bgbilling.modules.botmanager.common.service.BotManagerService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;

public class DialogElementConfigurePanel
extends BGUPanel
implements EventSubscriber<OpenDialogEditorEvent>,
DialogElemenCheckBoxFilterPanel.FilterChangeListener {
    private BotConfigurePanel botConfigurePanel;
    private DialogElemenCheckBoxFilterPanel elemenCheckBoxFilterPanel;
    private DialogElementEditor elementEditor;
    private BGUList<BotDialogElement> elementList;
    private List<BotDialogElement> allElements = new ArrayList<BotDialogElement>();

    protected DialogElementConfigurePanel(BotConfigurePanel botConfigurePanel) {
        this.botConfigurePanel = botConfigurePanel;
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)"\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0434\u0438\u0430\u043b\u043e\u0433\u0430");
        this.elemenCheckBoxFilterPanel = new DialogElemenCheckBoxFilterPanel(this);
        this.elementEditor = new DialogElementEditor(this.botConfigurePanel, this);
        this.initListElements();
        JScrollPane listElementsScrollPane = new JScrollPane((Component)this.elementList);
        this.add(this.getToolBar(), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
        this.add(new JLabel("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c:"), new GridBagConstraints(1, 0, 1, 1, 0.7, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.elemenCheckBoxFilterPanel, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(listElementsScrollPane, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 0, 0), 0, 0));
        EventBus.subscribe(OpenDialogEditorEvent.class, (EventSubscriber)this);
    }

    public void onEvent(OpenDialogEditorEvent event) {
        if (!event.isOpened()) {
            this.elemenCheckBoxFilterPanel.setSelectedType(null);
            this.elemenCheckBoxFilterPanel.onFilterChange();
        } else if (event.getDialog() != null && Utils.notEmptyCollection((Collection)event.getDialog().getDialogElements())) {
            this.elementList.setData(event.getDialog().getDialogElements());
        }
    }

    @Override
    public void onFilterChange() {
        this.elementListReloadByFilter(this.elemenCheckBoxFilterPanel.getSelectedTypes());
    }

    private JToolBar getToolBar() {
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(event -> {
            switch (BGDialogToolBar.ButtonData.of((String)event.getActionCommand())) {
                case NEW_ITEM: {
                    this.elementEditor.openEditor(null);
                    break;
                }
                case EDIT_ITEM: {
                    this.editDialogElement();
                    break;
                }
                case DELETE_ITEM: {
                    this.deleteDialogElement();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf(BGDialogToolBar.ButtonData.of((String)event.getActionCommand())));
                }
            }
        }, new BGDialogToolBar.ButtonData[]{BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.EDIT_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM});
        toolBar.setFloatable(false);
        toolBar.setOrientation(0);
        toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        return toolBar;
    }

    private void initListElements() throws Exception {
        this.elementList = new BGUList();
        this.elementList.setModel(new DefaultListModel());
        final JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u0438\u0430\u043b\u043e\u0433\u0438 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u043c").addActionListener(e -> this.showDialogsWithElement());
        popupMenu.add("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c").addActionListener(e -> this.editDialogElement());
        popupMenu.add("\u0423\u0434\u0430\u043b\u0438\u0442\u044c").addActionListener(e -> this.deleteDialogElement());
        this.elementList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BotDialogElement selectedElement;
                if (e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e) && (selectedElement = (BotDialogElement)DialogElementConfigurePanel.this.elementList.getSelectedValue()) != null) {
                    popupMenu.show((Component)DialogElementConfigurePanel.this.elementList, e.getX(), e.getY());
                }
            }
        });
        BotManagerService botManagerService = this.botConfigurePanel.getBotManagerService();
        this.elementList.setCellRenderer((ListCellRenderer)new ElementsListCellRenderer(botManagerService.getDialogs()));
        this.elementList.setSelectionMode(0);
        this.elementList.setDragEnabled(true);
        this.elementList.setTransferHandler((TransferHandler)new ElementsListTransferHandler(botManagerService));
        this.elementList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DialogElementConfigurePanel.this.botConfigurePanel.getDialogConfigurePanel().clearSelectedDialogs();
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    DialogElementConfigurePanel.this.editDialogElement();
                }
            }
        });
    }

    private void showDialogsWithElement() {
        this.botConfigurePanel.getDialogConfigurePanel().showDialogsWithElement(this.getSelectedElement());
    }

    private void deleteDialogElement() {
        BotDialogElement selectedElement = (BotDialogElement)this.elementList.getSelectedValue();
        if (selectedElement == null) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442");
        } else {
            Object infoText = "";
            int dialogsWithCurrentElement = selectedElement.getDialogIds().size();
            if (dialogsWithCurrentElement > 0) {
                infoText = (String)infoText + "\u0423\u0434\u0430\u043b\u044f\u0435\u043c\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 " + dialogsWithCurrentElement + " \u0434\u0438\u0430\u043b\u043e\u0433\u0430\u0445. \u041f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438, \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0431\u0443\u0434\u0435\u0442 \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0432\u0441\u0435\u0445 \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432. ";
            }
            if (ClientUtils.confirm((String)("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442? " + (String)infoText), (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430")) {
                try {
                    this.botConfigurePanel.getBotManagerService().deleteDialogElement(selectedElement);
                    EventBus.publish((Object)new DialogElementUpdateEvent(selectedElement));
                    this.elementListReloadByFilter(this.elemenCheckBoxFilterPanel.getSelectedTypes());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
                this.botConfigurePanel.performAction("refresh");
            }
        }
    }

    private void elementListReloadByFilter(List<BotDialogElementType> typesOnFilter) {
        if (Utils.notEmptyCollection(typesOnFilter)) {
            if (typesOnFilter.stream().anyMatch(Objects::isNull)) {
                this.elementList.setData(this.allElements);
            } else {
                this.elementList.setData(this.allElements.stream().filter(el -> typesOnFilter.contains(el.getElementType())).collect(Collectors.toList()));
            }
        } else {
            this.elementList.setData(this.allElements);
        }
    }

    protected void editDialogElement(BotDialogElement element) {
        this.elementEditor.openEditor(element);
    }

    private void editDialogElement() {
        this.elementEditor.openEditor(this.getSelectedElement());
    }

    private BotDialogElement getSelectedElement() {
        BotDialogElement selectedElement = (BotDialogElement)this.elementList.getSelectedValue();
        if (selectedElement == null) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
        }
        return selectedElement;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.allElements.clear();
            this.allElements.addAll(this.botConfigurePanel.getBotManagerService().getDialogElements());
            this.elementListReloadByFilter(this.elemenCheckBoxFilterPanel.getSelectedTypes());
        });
    }

    protected BGUList<BotDialogElement> getElementList() {
        return this.elementList;
    }

    protected void showAllElementsOfDialog(BotDialog dialog) {
        List elementsOfDialog = dialog.getDialogElements();
        if (Utils.isEmptyCollection((Collection)elementsOfDialog)) {
            return;
        }
        this.elementList.setData(elementsOfDialog);
    }
}

