/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.io.FilenameUtils;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.modules.botmanager.common.bean.Bot;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElementType;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogGroup;
import ru.bitel.bgbilling.modules.botmanager.common.bean.DialogProcessingWrapper;
import ru.bitel.bgbilling.modules.botmanager.common.bean.StatisticNote;
import ru.bitel.bgbilling.modules.botmanager.common.service.BotManagerService;
import ru.bitel.bgbilling.modules.botmanager.server.bots.BotManagement;
import ru.bitel.bgbilling.modules.botmanager.server.bots.RuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotDao;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotDialogDao;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotDialogElementDao;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotDialogGroupDao;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotStatisticDao;
import ru.bitel.bgbilling.modules.botmanager.server.filestorage.BotFileStorage;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.botmanager.common.service.BotManagerService")
public class BotManagerServiceImpl
extends AbstractService
implements BotManagerService {
    private BotDao botDao;
    private BotDialogDao dialogDao;
    private BotDialogElementDao dialogElementDao;
    private BotDialogGroupDao dialogGroupDao;
    private BotStatisticDao statisticDao;
    private FileStorage fileStorage;

    @PostConstruct
    public void init() throws Exception {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        this.botDao = new BotDao(connection, this.moduleId);
        this.dialogDao = new BotDialogDao(connection, this.moduleId);
        this.dialogElementDao = new BotDialogElementDao(connection, this.moduleId);
        this.dialogGroupDao = new BotDialogGroupDao(connection, this.moduleId);
        this.statisticDao = new BotStatisticDao(connection, this.moduleId);
        this.fileStorage = new BotFileStorage(connection, this.moduleId);
    }

    public List<BotDialog> getDialogs() throws Exception, BGMessageException {
        return this.dialogDao.getDialogs();
    }

    public void updateDialog(BotDialog dialog) throws Exception, BGMessageException {
        boolean needUpdateDialogOnRuntimeBot = dialog.getId() > 0;
        this.dialogDao.update(dialog);
        if (needUpdateDialogOnRuntimeBot) {
            BotManagement.getOrInitAndGet((ServerContext)ServerContext.get(), this.moduleId).getRuntimeBotMap().values().forEach(runtimeBot -> {
                try {
                    if (runtimeBot.getFirstDialog().getId() == dialog.getId()) {
                        runtimeBot.setFirstDialog(this.getDialogById(dialog.getId()));
                    }
                }
                catch (Exception ex) {
                    BotManagerServiceImpl.error((Throwable)ex);
                }
            });
        }
    }

    public void deleteDialog(BotDialog dialog) throws Exception, BGMessageException {
        for (BotDialogElement element : dialog.getDialogElements()) {
            element.getDialogIds().remove(dialog.getId());
            this.dialogElementDao.update(element);
        }
        this.dialogDao.delete(dialog.getId());
    }

    public List<Bot> getBots() throws Exception, BGMessageException {
        return this.botDao.getBots();
    }

    public void deleteBot(int botId) throws Exception, BGMessageException {
        BotManagement botManagement = BotManagement.getOrInitAndGet((ServerContext)ServerContext.get(), this.moduleId);
        try {
            RuntimeBot runtimeBot = botManagement.getBot(botId);
            if (runtimeBot.getBotState() == 1) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0431\u043e\u0442\u0430 \u0441 id=" + botId);
                }
                botManagement.stopBot(runtimeBot.getToken());
            }
            botManagement.getRuntimeBotMap().remove(runtimeBot.getToken());
        }
        catch (NoSuchElementException e) {
            this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 RuntimeBot'a:" + String.valueOf(e) + ". \u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 \u0441\u0435\u0440\u0432\u0435\u0440 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430.");
        }
        this.botDao.delete(botId);
    }

    public void updateBot(Bot bot) throws Exception, BGMessageException {
        ModuleSetup setup;
        int startDialogId;
        if (bot.getState() == 1 && (startDialogId = (setup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId))).getInt("bot." + bot.getId() + ".start.dialog.id", -1)) <= 0) {
            throw new Exception("\u041f\u0435\u0440\u0435\u0434 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435\u043c \u0431\u043e\u0442\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0434\u043b\u044f \u043d\u0435\u0433\u043e \u0441\u0442\u0430\u0440\u0442\u043e\u0432\u044b\u0439 \u0434\u0438\u0430\u043b\u043e\u0433 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f!");
        }
        this.botDao.update(bot);
        BotManagement.getOrInitAndGet((ServerContext)ServerContext.get(), this.moduleId).hotSwapBotData(bot);
    }

    public BotDialog getDialogById(int dialogId) throws Exception, BGMessageException {
        return (BotDialog)this.dialogDao.get(dialogId);
    }

    public BotDialog getDialogByCommand(String command) throws Exception, BGMessageException {
        return this.dialogDao.getByCommand(command);
    }

    public List<BotDialogElement> getDialogElements() throws Exception, BGMessageException {
        return this.dialogElementDao.getElements();
    }

    public List<BotDialogElement> getElementsByIds(List<Integer> ids) throws Exception, BGMessageException {
        return this.dialogElementDao.getElementsByIds(ids);
    }

    public int updateDialogElement(BotDialogElement element) throws Exception, BGMessageException {
        return this.dialogElementDao.updateElement(element);
    }

    public void updateDialogElements(List<BotDialogElement> elements) throws Exception, BGMessageException {
        if (elements != null) {
            for (BotDialogElement element : elements) {
                this.updateDialogElement(element);
            }
        }
    }

    public void updateDialogGroups(List<BotDialogGroup> groups) throws Exception, BGMessageException {
        groups.forEach(group -> {
            try {
                this.dialogGroupDao.update(group);
            }
            catch (Exception e) {
                BotManagerServiceImpl.error((Throwable)e);
            }
        });
    }

    public void deleteDialogElement(BotDialogElement element) throws Exception, BGMessageException {
        this.dialogDao.getDialogs().stream().filter(dialog -> element.getDialogIds().contains(dialog.getId())).toList().forEach(dialog -> {
            dialog.getDialogElements().removeIf(dialogElement -> dialogElement.getId() == element.getId());
            try {
                this.updateDialog((BotDialog)dialog);
            }
            catch (Exception e) {
                BotManagerServiceImpl.error((Throwable)e);
            }
        });
        if (element.getElementType().equals((Object)BotDialogElementType.ATTACHMENT)) {
            try {
                this.fileStorage.deleteByOwner(element.getId());
            }
            catch (SQLException ex) {
                throw new Exception(ex);
            }
        }
        this.dialogElementDao.delete(element.getId());
    }

    public List<BotDialogElement> getElementsOfDialog(int dialogId) throws Exception, BGMessageException {
        return this.dialogElementDao.getElementsOfDialog(dialogId);
    }

    public List<BotDialogGroup> getDialogGroups() throws Exception, BGMessageException {
        return this.dialogGroupDao.getGroupList();
    }

    public void updateDialogGroup(BotDialogGroup group) throws Exception, BGMessageException {
        this.dialogGroupDao.update(group);
    }

    public void deleteDialogGroup(BotDialogGroup group) throws Exception, BGMessageException {
        this.dialogGroupDao.delete(group.getId());
    }

    public List<BotDialog> getDialogsByGroupId(int dialogGroupId) throws Exception, BGMessageException {
        return this.dialogDao.getDialogListByGroupId(dialogGroupId);
    }

    public void reloadDialogProcessingClasses() throws Exception, BGMessageException {
        BotManagement.getOrInitAndGet((ServerContext)ServerContext.get(), this.moduleId).reloadDialogProcessing();
    }

    public List<DialogProcessingWrapper> getDialogProcessingClasses() throws Exception, BGMessageException {
        this.reloadDialogProcessingClasses();
        ArrayList<DialogProcessingWrapper> wrappers = new ArrayList<DialogProcessingWrapper>();
        BotManagement.getOrInitAndGet((ServerContext)ServerContext.get(), this.moduleId).getDialogProcessingClasses().values().forEach(clazz -> wrappers.add(new DialogProcessingWrapper(clazz.title(), clazz.getClass().getName())));
        return wrappers;
    }

    public byte[] getFile(int elementId) throws Exception {
        try {
            return this.getFileBytes(this.getFileByElementId(elementId));
        }
        catch (IOException e) {
            throw new Exception(e);
        }
    }

    public File getFileByElementId(int elementId) throws Exception {
        List files = this.fileStorage.getFilesListByOwner(elementId);
        if (files.size() == 0) {
            return null;
        }
        return new File(this.fileStorage.getFileName(((BGServerFile)files.get(0)).getId()));
    }

    private byte[] getFileBytes(File file) throws IOException {
        if (file == null) {
            return new byte[0];
        }
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] bytes = new byte[(int)file.length()];
            fis.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public void setFile(BotDialogElement element, byte[] fileBytes) throws Exception {
        if (fileBytes == null || fileBytes.length == 0) {
            return;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(fileBytes);){
            BGServerFile bgFile = new BGServerFile();
            bgFile.setTitle(element.getJSONConfig().optString("attachmentFileTitle"));
            bgFile.setSize((long)((InputStream)is).available());
            bgFile.setOwnerId(element.getId());
            bgFile.setComment("");
            bgFile.setDate(new Date());
            this.fileStorage.updateFile(bgFile);
            if (bgFile.getId() > 0) {
                this.fileStorage.saveStream(bgFile.getId(), (InputStream)is, FilenameUtils.getExtension((String)bgFile.getTitle()));
            }
        }
        catch (IOException ex) {
            throw new Exception(ex);
        }
    }

    public void updateSortPositionOfElements(Map<Integer, Integer> elementSorting) {
        this.dialogElementDao.updateSortingElements(elementSorting);
    }

    public SearchResult<StatisticNote> getStatistic(Page page) throws Exception, BGMessageException {
        SearchResult searchResult = new SearchResult(page);
        searchResult.setList(new ArrayList());
        this.statisticDao.getList((SearchResult<StatisticNote>)searchResult);
        return searchResult;
    }

    public List<StatisticNote> getStatisticByContractId(int contractId) throws Exception, BGMessageException {
        return this.statisticDao.getListByContractId(contractId);
    }

    public void clearStatisticByBotId(int botId) throws Exception, BGMessageException {
        this.statisticDao.deleteByBotId(botId);
    }

    public void clearStatisticByContractId(int contractId) throws Exception, BGMessageException {
        this.statisticDao.deleteByContractId(contractId);
    }

    public void updateStatisticNote(StatisticNote statisticNote) throws Exception {
        this.statisticDao.update(statisticNote);
    }
}

