/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean.extractor;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionValue;
import ru.bitel.bgbilling.modules.bill.server.bean.extractor.Extractor;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class KernelExtractor
extends Extractor {
    @Override
    public List<PositionValue> extract(String function, Connection con, String cids, Calendar month, List<String> paramList, String posName) {
        ArrayList<PositionValue> result = new ArrayList<PositionValue>();
        if (!this.chargeSimple(result, function, con, cids, month, paramList)) {
            this.chargeComment(result, function, con, cids, month, paramList);
        }
        return result;
    }

    private boolean chargeComment(List<PositionValue> result, String function, Connection con, String cids, Calendar month, List<String> paramList) {
        block17: {
            try {
                boolean charges = function.equals("CHARGES_EXT");
                boolean chargesExcept = function.equals("CHARGES_EXT_EXCEPT");
                if (!charges && !chargesExcept || paramList.size() <= 0) break block17;
                month = this.getMonthParam(month, paramList, 0);
                String query = "SELECT charge.pt, charge.summa AS summ, charge_type.title AS title, charge.comment FROM contract_charge AS charge LEFT JOIN contract_charge_types AS charge_type ON charge.pt=charge_type.id WHERE charge.cid IN (" + cids + ") ";
                String chargeTypes = null;
                if (paramList.size() > 1) {
                    chargeTypes = Utils.toString(paramList, (int)1);
                }
                if (Utils.notBlankString(chargeTypes)) {
                    query = charges ? query + " AND charge.pt IN ( " + chargeTypes + ") " : query + " AND charge.pt NOT IN ( " + chargeTypes + ") ";
                }
                query = query + " AND charge.dt>=? AND charge.dt<=? ";
                Calendar startMonth = TimeUtils.getStartMonth((Calendar)month);
                Calendar endMonth = TimeUtils.getEndMonth((Calendar)month);
                try (PreparedStatement ps = con.prepareStatement(query);){
                    ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)startMonth));
                    ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)endMonth));
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            PositionValue value = new PositionValue().setQuantity(BigDecimal.ONE).setSum(Utils.roundBigDecimalSumm((BigDecimal)rs.getBigDecimal(2))).setName(this.makeTitle(rs.getString(3), rs.getString(4)));
                            result.add(value);
                        }
                    }
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean chargeSimple(List<PositionValue> result, String function, Connection con, String cids, Calendar month, List<String> paramList) {
        block17: {
            try {
                boolean charges = function.equals("CHARGES");
                boolean chargesExcept = function.equals("CHARGES_EXCEPT");
                if (!charges && !chargesExcept || paramList.size() <= 0) break block17;
                month = this.getMonthParam(month, paramList, 0);
                String query = "SELECT charge.pt, COUNT(charge.id) AS col, SUM(charge.summa) AS summ, charge_type.title AS title FROM contract_charge AS charge LEFT JOIN contract_charge_types AS charge_type ON charge.pt=charge_type.id WHERE charge.cid IN (" + cids + ") ";
                String chargeTypes = null;
                if (paramList.size() > 1) {
                    chargeTypes = Utils.toString(paramList, (int)1);
                }
                if (Utils.notBlankString(chargeTypes)) {
                    query = charges ? query + " AND charge.pt IN ( " + chargeTypes + ") " : query + " AND charge.pt NOT IN ( " + chargeTypes + ") ";
                }
                query = query + " AND charge.dt>=? AND charge.dt<=? GROUP BY charge.pt";
                Calendar startMonth = TimeUtils.getStartMonth((Calendar)month);
                Calendar endMonth = TimeUtils.getEndMonth((Calendar)month);
                try (PreparedStatement ps = con.prepareStatement(query);){
                    ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)startMonth));
                    ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)endMonth));
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            PositionValue value = new PositionValue().setQuantity(rs.getBigDecimal(2)).setSum(Utils.roundBigDecimalSumm((BigDecimal)rs.getBigDecimal(3))).setName(rs.getString(4));
                            result.add(value);
                        }
                    }
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

