/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import bitel.billing.server.contract.bean.Contract;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.StartElement;
import org.xml.sax.Attributes;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentDeletedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.bill.common.bean.BankAccount;
import ru.bitel.bgbilling.modules.bill.common.bean.BillListFilter;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.SortMode;
import ru.bitel.bgbilling.modules.bill.server.bean.AbstractManager;
import ru.bitel.bgbilling.modules.bill.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.bill.server.bean.Bill;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDocumentDao;
import ru.bitel.bgbilling.modules.bill.server.bean.BillUtil;
import ru.bitel.bgbilling.modules.bill.server.bean.NumerationPoolManager;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionValue;
import ru.bitel.bgbilling.modules.bill.server.event.BillCreatedEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class BillManager
extends AbstractManager {
    private static Object addBillMutex = new Object();
    private static final String BILL_DATA_FIELDS = "bill_data.format_number, bill_data.number, bill_data.number_in_month, bill_data.number_in_year, bill_data.id, bill_data.payment_id, bill_data.account_id, bill_data.cid, bill_data.npid, bill_data.type, bill_data.status, bill_data.unload_status, bill_data.uid, bill_data.yy, bill_data.mm, bill_data.create_dt, bill_data.pay_dt, bill_data.pay_uid, bill_data.summ";

    public BillManager(Connection con, int moduleId) {
        super(con, moduleId, "bill_data_" + moduleId);
    }

    public List<Bill> getBillList(BillListFilter billListFilter, Period period, int dateType, int payedType, int userType, int unloadType, String contractLabels, String labelMode, boolean getXml, String type, int addressSortParam, String nameSortParam, int sortMode, int secondarySortMode, boolean forRegister) {
        PreparedStatement ps;
        ArrayList<Bill> result = new ArrayList<Bill>();
        List listIds = Utils.toList((String)contractLabels);
        StringBuffer query = new StringBuffer();
        if (listIds.size() > 0) {
            if (labelMode.equals("or")) {
                query.append("CREATE TEMPORARY TABLE IF NOT EXISTS cids AS SELECT DISTINCT contract_id FROM contract_label_link WHERE label_id IN ( " + Utils.toString((Iterable)listIds) + " )");
                try {
                    ps = this.con.prepareStatement(query.toString());
                    try {
                        ps.executeUpdate();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            } else if (labelMode.equals("and")) {
                query.append("CREATE TEMPORARY TABLE IF NOT EXISTS cids AS SELECT contract_id, count(*) as c FROM contract_label_link WHERE label_id IN ( " + Utils.toString((Iterable)listIds) + " ) GROUP BY contract_id HAVING c=?");
                try {
                    ps = this.con.prepareStatement(query.toString());
                    try {
                        ps.setInt(1, listIds.size());
                        ps.executeUpdate();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        try {
            String tDate;
            query.setLength(0);
            query.append("SELECT SQL_CALC_FOUND_ROWS ").append(BILL_DATA_FIELDS);
            if (getXml) {
                query.append(", bill_data.xml");
            }
            query.append(", contract.title, contract.comment, type.title");
            if (sortMode == SortMode.CONTRACT_WITH_SUB.getCode() || secondarySortMode == SortMode.CONTRACT_WITH_SUB.getCode()) {
                query.append(", if( super_contract.title is null, CONCAT(contract.title,\"-\"), CONCAT(CONCAT(super_contract.title,\"-\"),contract.title)) AS sub_sort ");
            }
            this.addStreetCol(addressSortParam, sortMode, secondarySortMode, query, forRegister);
            this.addNameCol(nameSortParam, sortMode, secondarySortMode, query);
            query.append(" FROM ").append(this.table).append(" AS bill_data ");
            if (listIds.size() > 0) {
                query.append(" INNER JOIN cids ON bill_data.cid=cids.contract_id ");
            }
            query.append(" LEFT JOIN bill_doc_type_" + this.moduleId + " AS type ON bill_data.type=type.id ");
            query.append(" LEFT JOIN contract ON bill_data.cid=contract.id");
            query.append(" LEFT JOIN contract AS super_contract ON super_contract.id=contract.scid ");
            this.addPackageFilterJoin(billListFilter.getPackageParamId(), billListFilter.getPackageId(), sortMode, query);
            this.addStreetJoin(addressSortParam, sortMode, secondarySortMode, query, forRegister);
            this.addNameJoin(nameSortParam, sortMode, secondarySortMode, query);
            query.append(" WHERE (true ");
            Object date = "";
            String string = tDate = dateType == 1 ? "create_dt" : "pay_dt";
            if (period.getDateFrom() != null && period.getDateTo() != null) {
                date = " AND (" + tDate + ">=? AND " + tDate + "<=?)";
            } else if (period.getDateFrom() != null && period.getDateTo() == null) {
                date = " AND (" + tDate + ">=?)";
            } else if (period.getDateFrom() == null && period.getDateTo() != null) {
                date = " AND (" + tDate + "<=?)";
            }
            query.append((String)date);
            if (billListFilter.getYear() > 0 && billListFilter.getMonth() >= 0) {
                query.append(" AND (yy=? AND mm=?)");
            }
            if (unloadType == 1) {
                query.append(" AND(unload_status=0)");
            } else if (unloadType == 2) {
                query.append(" AND(unload_status=1)");
            }
            if (userType == 2) {
                query.append(" AND (uid!=-1)");
            } else if (userType == 3) {
                query.append(" AND (uid=-1)");
            }
            if (billListFilter.getAccountId() > 0) {
                query.append(" AND(account_id=").append(billListFilter.getAccountId()).append(")");
            }
            if (payedType == 1) {
                query.append(" AND (bill_data.status=0)");
            } else if (payedType == 2) {
                query.append(" AND (bill_data.status!=0)");
            }
            if (billListFilter.getPackageId() > 0 && billListFilter.getPackageParamId() > 0) {
                query.append("AND (cp7.val=").append(billListFilter.getPackageId());
                query.append(" OR (cp7.val IS NULL AND cp7_super.val=").append(billListFilter.getPackageId()).append("))");
            }
            if (billListFilter.getContractTitle() != null && !billListFilter.getContractTitle().isEmpty()) {
                query.append(" AND (contract.title LIKE ?)");
            }
            if (billListFilter.getBillNumber() != null && !billListFilter.getBillNumber().isEmpty()) {
                query.append(" AND (format_number LIKE ?)");
            }
            if (Utils.notEmptyString((String)type)) {
                query.append(" AND bill_data.type IN ( ").append(type).append(" )");
            }
            query.append(") ");
            this.addSortMode(addressSortParam, nameSortParam, sortMode, secondarySortMode, query);
            query.append(billListFilter.getPage().sqlLimit());
            try (PreparedStatement ps2 = this.con.prepareStatement(query.toString(), 1);){
                int iter = 1;
                if (period.getDateFrom() != null) {
                    ps2.setDate(iter++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps2.setDate(iter++, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
                }
                if (billListFilter.getYear() > 0 && billListFilter.getMonth() >= 0) {
                    ps2.setInt(iter++, billListFilter.getYear());
                    ps2.setInt(iter++, billListFilter.getMonth());
                }
                if (billListFilter.getContractTitle() != null && !billListFilter.getContractTitle().isEmpty()) {
                    ps2.setString(iter++, "%" + billListFilter.getContractTitle() + "%");
                }
                if (billListFilter.getBillNumber() != null && !billListFilter.getBillNumber().isEmpty()) {
                    ps2.setString(iter++, "%" + billListFilter.getBillNumber() + "%");
                }
                try (ResultSet rs = ps2.executeQuery();){
                    while (rs.next()) {
                        Bill bill = this.getBillFromRS(rs);
                        this.loadContractFromRS(rs, bill);
                        this.loadTypeTitleFromRS(rs, bill);
                        if (forRegister) {
                            bill.setAddress(rs.getString("address"));
                            bill.setRecipient(rs.getString("contract.comment"));
                        }
                        if (getXml) {
                            bill.setXmlData(rs.getBytes("xml"));
                        }
                        result.add(bill);
                    }
                }
                billListFilter.getPage().setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        try {
            ps = this.con.prepareStatement("DROP TABLE IF EXISTS cids");
            try {
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public List<Bill> getBillList(BillListFilter billListFilter, Calendar from, Calendar until, int dateType, int payedType, int userType, int unloadType, String groups, String groupMode, boolean getXml, int type, int addressSortParam, String nameSortParam, int sortMode, int secondarySortMode, boolean forRegister) {
        ArrayList<Bill> result = new ArrayList<Bill>();
        try {
            long grMask;
            String tDate;
            StringBuffer query = new StringBuffer();
            query.append("SELECT SQL_CALC_FOUND_ROWS bill_data.* , contract.gr, contract.title, contract.comment, type.title ");
            this.addStreetCol(addressSortParam, sortMode, secondarySortMode, query, forRegister);
            this.addNameCol(nameSortParam, sortMode, secondarySortMode, query);
            query.append(" FROM ").append(this.table).append(" AS bill_data ");
            query.append(" LEFT JOIN bill_doc_type_" + this.mid + " AS type ON bill_data.type=type.id ");
            query.append(" LEFT JOIN contract on bill_data.cid=contract.id");
            this.addPackageFilterJoin(billListFilter.getPackageParamId(), billListFilter.getPackageId(), sortMode, query);
            this.addStreetJoin(addressSortParam, sortMode, secondarySortMode, query, forRegister);
            this.addNameJoin(nameSortParam, sortMode, secondarySortMode, query);
            query.append(" WHERE (");
            Object date = "(";
            String string = tDate = dateType == 1 ? "create_dt" : "pay_dt";
            if (from != null && until != null) {
                date = "(" + tDate + ">=? AND " + tDate + "<=?) AND (";
            } else if (from != null && until == null) {
                date = "(" + tDate + ">=?)AND(";
            } else if (from == null && until != null) {
                date = "(" + tDate + "<=?)AND(";
            }
            query.append((String)date);
            if (billListFilter.getYear() > 0 && billListFilter.getMonth() >= 0) {
                query.append("yy=? AND mm=?)");
            }
            if (unloadType == 1) {
                query.append(" AND (unload_status=0)");
            } else if (unloadType == 2) {
                query.append(" AND (unload_status=1)");
            }
            if (userType == 2) {
                query.append(" AND (uid!=-1)");
            } else if (userType == 3) {
                query.append(" AND (uid=-1)");
            }
            if (billListFilter.getAccountId() > 0) {
                query.append(" AND account_id=").append(billListFilter.getAccountId());
            }
            if (payedType == 1) {
                query.append(" AND (bill_data.status=0)");
            } else if (payedType == 2) {
                query.append(" AND (bill_data.status!=0)");
            }
            if (billListFilter.getPackageId() > 0 && billListFilter.getPackageParamId() > 0) {
                query.append(" AND (cp7.val=").append(billListFilter.getPackageId());
                query.append(" OR (cp7.val IS NULL AND cp7_super.val=").append(billListFilter.getPackageId()).append("))");
            }
            if ((grMask = Utils.enumToMask((String)groups)) > 0L && Utils.notEmptyString((String)groupMode)) {
                if (groupMode.equals("or")) {
                    query.append(" AND (contract.gr&").append(grMask).append(">0)");
                } else {
                    query.append(" AND (contract.gr&").append(grMask).append("=").append(grMask).append(")");
                }
            }
            if (billListFilter.getContractTitle() != null && !billListFilter.getContractTitle().isEmpty()) {
                query.append(" AND (contract.title LIKE ?)");
            }
            if (billListFilter.getBillNumber() != null && !billListFilter.getBillNumber().isEmpty()) {
                query.append(" AND (format_number LIKE ?)");
            }
            if (type > 0) {
                query.append(" AND bill_data.type=").append(type);
            }
            query.append(") ");
            this.addSortMode(addressSortParam, nameSortParam, sortMode, secondarySortMode, query);
            query.append(billListFilter.getPage().sqlLimit());
            try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
                int iter = 1;
                if (from != null) {
                    ps.setDate(iter++, TimeUtils.convertCalendarToSqlDate((Calendar)from));
                }
                if (until != null) {
                    ps.setDate(iter++, TimeUtils.convertCalendarToSqlDate((Calendar)until));
                }
                if (billListFilter.getYear() > 0 && billListFilter.getMonth() >= 0) {
                    ps.setInt(iter++, billListFilter.getYear());
                    ps.setInt(iter++, billListFilter.getMonth());
                }
                if (billListFilter.getContractTitle() != null && !billListFilter.getContractTitle().isEmpty()) {
                    ps.setString(iter++, "%" + billListFilter.getContractTitle() + "%");
                }
                if (billListFilter.getBillNumber() != null && !billListFilter.getBillNumber().isEmpty()) {
                    ps.setString(iter++, "%" + billListFilter.getBillNumber() + "%");
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        Bill bill = this.getBillFromRS(rs);
                        this.loadContractFromRS(rs, bill);
                        this.loadTypeTitleFromRS(rs, bill);
                        if (forRegister) {
                            bill.setAddress(rs.getString("address"));
                            bill.setRecipient(rs.getString("contract.comment"));
                        }
                        if (getXml) {
                            bill.setXmlData(rs.getBytes("xml"));
                        }
                        result.add(bill);
                    }
                }
                billListFilter.getPage().setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private Bill getBillFromRS(ResultSet rs) throws SQLException {
        return Bill.builder().setId(rs.getInt("id")).setFormatNumber(rs.getString("format_number")).setNumber(rs.getInt("number")).setNumberInMonth(rs.getInt("number_in_month")).setNumberInYear(rs.getInt("number_in_year")).setPaymentId(rs.getInt("payment_id")).setAccountId(rs.getInt("account_id")).setContractId(rs.getInt("cid")).setTypeId(rs.getInt("type")).setStatus(rs.getInt("status")).setUnloadStatus(rs.getInt("unload_status")).setUserId(rs.getInt("uid")).setYy(rs.getInt("yy")).setMm(rs.getInt("mm")).setCreateDate(rs.getDate("create_dt")).setPayDate(rs.getDate("pay_dt")).setPayUid(rs.getInt("pay_uid")).setSumm(rs.getBigDecimal("summ")).build();
    }

    private Bill loadContractFromRS(ResultSet rs, Bill bill) throws SQLException {
        bill.setContractTitle(rs.getString("contract.title"));
        bill.setContractComment(rs.getString("contract.comment"));
        return bill;
    }

    private Bill loadTypeTitleFromRS(ResultSet rs, Bill bill) throws SQLException {
        bill.setTypeTitle(rs.getString("type.title"));
        return bill;
    }

    public void setPayed(String ids, int userID, boolean pay, boolean value, Date date, String summComment) throws Exception {
        String[] idm = ids.split("\\s*[;,]\\s*");
        for (int i = 0; i < idm.length; ++i) {
            String[] par = idm[i].split(":");
            if (par.length >= 3) continue;
            int id = Utils.parseInt((String)par[0], (int)0);
            this.setPayed(id, userID, pay, value, date, summComment);
        }
    }

    private void setPayed(int id, int userID, boolean pay, boolean value, Date date, String summComment) throws Exception {
        Bill bill = this.getBill(id);
        if (bill.getStatus() == 1 != value) {
            if (value) {
                this.setPayed(bill, date, userID, pay, summComment);
            } else {
                this.setUnpayed(bill);
            }
        }
    }

    private void setPayed(Bill bill, Date date, int userId, boolean pay, String sumComment) throws BGException {
        String query = "UPDATE " + this.table + " SET status=?, pay_dt=?, pay_uid=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setBoolean(index++, true);
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setInt(index++, userId);
            ps.setInt(index++, bill.getId());
            ps.executeUpdate();
            ps.close();
            if (pay) {
                this.updatePayment(bill.getId(), userId, sumComment);
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private void setUnpayed(Bill bill) throws Exception {
        String query = "UPDATE " + this.table + " SET payment_id=?, status=?, pay_dt=?, pay_uid=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, 0);
            ps.setBoolean(index++, false);
            ps.setDate(index++, null);
            ps.setInt(index++, 0);
            ps.setInt(index++, bill.getId());
            ps.executeUpdate();
        }
        if (bill.getPaymentId() != 0 && bill.getPaymentId() != -1) {
            PaymentDao paymentDao = new PaymentDao(this.con);
            Payment contractPayment = (Payment)paymentDao.get(bill.getPaymentId());
            paymentDao.delete(bill.getPaymentId());
            Contract contract = this.contractManager.getContractById(bill.getContractId());
            this.con.commit();
            BalanceUtils bu = new BalanceUtils(this.con);
            bu.updateBalance(contractPayment.getDate(), contract);
            bu.close();
            this.con.commit();
            EventProcessor.getInstance().publish((Event)new PaymentDeletedEvent(0, contractPayment));
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contract.getId(), 3, contractPayment.getSum().negate()));
        }
    }

    private void updatePayment(int id, int userId, String sumComment) throws Exception {
        Bill bill = this.getBill(id);
        BigDecimal sum = bill.getSumm();
        Object comment = "\u041e\u043f\u043b\u0430\u0442\u0430 \u0441\u0447\u0435\u0442\u0430 " + bill.getFormatNumber() + " \u043e\u0442 \u0434\u0430\u0442\u044b: " + TimeUtils.formatDate((Date)bill.getCreateDate());
        if (sumComment != null) {
            String[] values = sumComment.split(";");
            sum = Utils.parseBigDecimal((String)values[0], (BigDecimal)bill.getSumm());
            if (values.length > 1) {
                comment = values[1];
            }
        }
        Payment payment = Payment.builder().setContractId(bill.getContractId()).setTypeId(AccountManager.getPaymentTypeId(this.con, this.moduleId, bill.getAccountId())).setDate(bill.getPayDate()).setUserId(userId).setSum(sum).setComment((String)comment).build();
        new PaymentDao(this.con).update((Object)payment);
        String query = "UPDATE " + this.table + " SET payment_id=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, payment.getId());
            ps.setInt(2, id);
            ps.executeUpdate();
        }
        Contract contract = this.contractManager.getContractById(bill.getContractId());
        this.con.commit();
        try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
            balanceUtils.updateBalance(payment.getDate(), contract);
        }
        this.con.commit();
        EventProcessor.getInstance().publish((Event)new PaymentEvent(userId, payment));
        EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contract.getId(), 3, payment.getSum()));
    }

    public void updateDocTypeId(List<Integer> documentIds, int documentTypeId) throws BGException {
        if (documentIds != null && !documentIds.isEmpty()) {
            String query = "UPDATE " + this.table + " SET type=? WHERE id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setInt(1, documentTypeId);
                for (int documentId : documentIds) {
                    ps.setInt(2, documentId);
                    ps.executeUpdate();
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public List<Bill> getBillList(Page page, int cid) {
        try {
            return BillDocumentDao.getBillDocumentList(this.con, this.moduleId, this.table, cid, page, rs -> {
                try {
                    Bill bill = this.getBillFromRS((ResultSet)rs);
                    this.loadTypeTitleFromRS((ResultSet)rs, bill);
                    return bill;
                }
                catch (SQLException ex) {
                    throw new BGRuntimeException((Throwable)ex);
                }
            });
        }
        catch (BGRuntimeException ex) {
            Throwable t = ex;
            if (t.getCause() instanceof SQLException) {
                t = ex.getCause();
            }
            this.getLogger().error(t.getMessage(), t);
            return new ArrayList<Bill>();
        }
    }

    public Bill getBill(int id) {
        Bill payBill = null;
        String query = "SELECT " + BILL_DATA_FIELDS + ", type.title FROM " + this.table + " AS bill_data LEFT JOIN bill_doc_type_" + this.moduleId + " AS type ON bill_data.type=type.id WHERE bill_data.id=" + id;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                payBill = this.getBillFromRS(rs);
                this.loadTypeTitleFromRS(rs, payBill);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return payBill;
    }

    public int deleteBill(int contractId, int id, boolean admin) {
        if (id == 0) {
            return 1;
        }
        int result = 0;
        try {
            Object query = "SELECT uid, status FROM " + this.table + " WHERE cid=" + contractId + " AND id=" + id;
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery((String)query);
            if (rs.next()) {
                if (rs.getInt("status") == 0) {
                    if (admin || rs.getInt("uid") == -1) {
                        query = "DELETE FROM " + this.table + " WHERE cid=" + contractId + " AND id=" + id;
                        st.executeUpdate((String)query);
                    } else {
                        result |= 1;
                    }
                } else {
                    result |= 2;
                }
            } else {
                result |= 4;
            }
            rs.close();
            st.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addBillDoc(int userId, BillDoc doc, List<PositionValue> posList, List<BillDoc> subList, boolean checkPast) {
        Bill bill = (Bill)doc;
        int yy = bill.getYy();
        int mm = bill.getMm();
        int contractId = bill.getContractId();
        int type = bill.getTypeId();
        int accountId = bill.getAccountId();
        int uid = bill.getUserId();
        BigDecimal summ = bill.getSumm();
        Date date = bill.getCreateDate();
        int npId = doc.getNpid();
        if (checkPast && !BillUtil.isPast(yy, mm)) {
            return -1;
        }
        if (contractId > 0) {
            int n;
            block13: {
                Connection con = this.setup.getDBConnectionFromPool();
                try {
                    int id;
                    String query = null;
                    PreparedStatement addBillPS = null;
                    Object object = addBillMutex;
                    synchronized (object) {
                        int[] numbers = this.getNextNumbers(con, npId, yy, mm);
                        query = "INSERT INTO " + this.table + "( cid, type, account_id, number, number_in_month, number_in_year, format_number, uid, yy, mm, create_dt, pay_dt, status, summ, xml, npid, unload_status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, null, ?, ?, ?, ?, ?)";
                        addBillPS = con.prepareStatement(query, 1);
                        String formatNumber = NumerationPoolManager.formatNumber(npId, yy, mm, numbers[0], numbers[1], numbers[2], con, this.moduleId, contractId);
                        bill.setFormatNumber(formatNumber);
                        int pos = 1;
                        addBillPS.setInt(pos++, contractId);
                        addBillPS.setInt(pos++, type);
                        addBillPS.setInt(pos++, accountId);
                        addBillPS.setInt(pos++, numbers[0]);
                        addBillPS.setInt(pos++, numbers[1]);
                        addBillPS.setInt(pos++, numbers[2]);
                        addBillPS.setString(pos++, formatNumber);
                        addBillPS.setInt(pos++, uid);
                        addBillPS.setInt(pos++, yy);
                        addBillPS.setInt(pos++, mm);
                        addBillPS.setDate(pos++, TimeUtils.convertDateToSqlDate((Date)date));
                        addBillPS.setInt(pos++, 0);
                        addBillPS.setBigDecimal(pos++, summ);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
                        this.serializeBillToXML(con, bos, bill, posList, subList, UserMap.getUser((Integer)userId).getName());
                        addBillPS.setBytes(pos++, bos.toByteArray());
                        addBillPS.setInt(pos++, npId);
                        addBillPS.setInt(pos++, 0);
                        addBillPS.executeUpdate();
                    }
                    n = id = ServerUtils.lastInsertId((PreparedStatement)addBillPS);
                    if (con == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                con.close();
            }
            return n;
        }
        return -1;
    }

    private void serializeBillToXML(Connection con, ByteArrayOutputStream bos, Bill billDoc, List<PositionValue> posList, List<BillDoc> subList, String userName) throws ParserConfigurationException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter doc = factory.createXMLStreamWriter(bos, "UTF-8");
        doc.writeStartDocument("UTF-8", "1.0");
        Contract contract = this.contractManager.getContractById(billDoc.getContractId());
        if (contract != null) {
            if (billDoc.getBankAccount() != null) {
                BankAccount bankAccount = billDoc.getBankAccount();
                doc.writeStartElement("data");
                doc.writeStartElement("bill");
                doc.writeAttribute("account", bankAccount.getAccount());
                doc.writeAttribute("bik", bankAccount.getBankIdentificationCode());
                doc.writeAttribute("bank_title", bankAccount.getBankTitle());
                doc.writeAttribute("corr_account", bankAccount.getCorrespondentAccount());
                int mm2 = billDoc.getMm();
                int yy2 = billDoc.getYy();
                if (--mm2 < 0) {
                    mm2 = 11;
                    --yy2;
                }
                Object cids = String.valueOf(billDoc.getContractId());
                if (contract.getSuperId() == -1 && Utils.notBlankString((String)contract.getDependSubList())) {
                    cids = (String)cids + "," + contract.getDependSubList();
                }
                GregorianCalendar month = new GregorianCalendar(billDoc.getYy(), billDoc.getMm(), 1);
                GregorianCalendar monthPrev = new GregorianCalendar(yy2, mm2, 1);
                doc.writeAttribute("saldo", Utils.formatBigDecimalSumm((BigDecimal)BillUtil.getDebt(month, billDoc.getContractId(), con).negate()));
                doc.writeAttribute("saldo_prev", Utils.formatBigDecimalSumm((BigDecimal)BillUtil.getDebt(monthPrev, billDoc.getContractId(), con).negate()));
                BigDecimal[] sumRef = new BigDecimal[2];
                BillUtil.getServiceAccount(month, (String)cids, null, con, sumRef);
                doc.writeAttribute("amounts", Utils.formatBigDecimalSumm((BigDecimal)sumRef[1]));
                doc.writeAttribute("payments", Utils.formatBigDecimalSumm((BigDecimal)BillUtil.getPayment(month, (String)cids, null, con)));
                doc.writeAttribute("charges", Utils.formatBigDecimalSumm((BigDecimal)BillUtil.getCharge(month, (String)cids, null, con)));
                this.addBillDocData(con, billDoc, posList, subList, doc, contract);
                doc.writeEndElement();
                doc.writeEndElement();
            } else {
                throw new RuntimeException("Account not found! Do you create accounts (banks)?");
            }
        }
        doc.writeEndDocument();
        doc.flush();
    }

    @Override
    protected BillDoc getBillDoc(Attributes attributes) {
        Bill bill = new Bill();
        this.setBankAccount(bill, Utils.parseInt((String)attributes.getValue("account_id"), (int)0));
        this.setOrganization(bill, Utils.parseInt((String)attributes.getValue("organization_id"), (int)0));
        return bill;
    }

    @Override
    protected BillDoc getBillDoc(XMLUtils.BGXMLEventReader reader, StartElement element) {
        Bill bill = new Bill();
        this.setBankAccount(bill, Utils.parseInt((String)reader.getAttributeValue(element, "account_id"), (int)0));
        this.setOrganization(bill, Utils.parseInt((String)reader.getAttributeValue(element, "organization_id"), (int)0));
        return bill;
    }

    @Override
    protected void publishEvent(int userID, BillDoc billDoc, int billId) throws BGException {
        EventProcessor.getInstance().publish((Event)new BillCreatedEvent(userID, this.moduleId, billDoc.getContractId(), billId));
    }
}

