/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.assist.common.bean.Transaction;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolRequestOperation;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolRequestOrder;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class AssistUtils {
    private static Pattern pcontr = Pattern.compile("\\$\\{contract\\}");
    private static Pattern pcontrComment = Pattern.compile("\\$\\{contract_comment\\}");
    private static Pattern pTotal = Pattern.compile("\\$\\{total\\}");
    private static Pattern pDate = Pattern.compile("\\$\\{date\\}");
    private static Pattern pBillnumber = Pattern.compile("\\$\\{billnumber\\}");
    private static Pattern pCardholder = Pattern.compile("\\$\\{cardholder\\}");
    private static Pattern pCardtype = Pattern.compile("\\$\\{cardtype\\}");
    private static Pattern pCardsubtype = Pattern.compile("\\$\\{cardsubtype\\}");
    private static Pattern pCardnumber = Pattern.compile("\\$\\{cardnumber\\}");
    private static Pattern pName = Pattern.compile("\\$\\{name\\}");

    public static String getPaymentDesc(Connection con, String pattern, int cid) {
        String desc = null;
        try {
            Contract contract = ContractDao.getContract((Connection)con, (int)cid);
            desc = pcontr.matcher(pattern).replaceAll(contract.getTitle());
            desc = pcontrComment.matcher(desc).replaceAll(contract.getComment());
        }
        catch (BGException ex) {
            ex.printStackTrace();
        }
        return desc;
    }

    public static String getPaymentComment(Connection con, String pattern, Transaction transaction) {
        Contract contract = null;
        try {
            contract = ContractDao.getContract((Connection)con, (int)transaction.getContractId());
        }
        catch (BGException e) {
            e.printStackTrace();
        }
        String desc = pcontr.matcher(pattern).replaceAll(contract != null && contract.getTitle() != null ? contract.getTitle() : "?");
        desc = pcontrComment.matcher(desc).replaceAll(contract != null && contract.getComment() != null ? contract.getComment() : "?");
        desc = pTotal.matcher(desc).replaceAll(transaction.getSum() != null ? Utils.formatCost((BigDecimal)transaction.getSum()) : "?");
        desc = pDate.matcher(desc).replaceAll(transaction.getCreateDate() != null ? TimeUtils.format((Date)transaction.getCreateDate(), (String)"dd.MM.yyyy HH:mm:ss") : "?");
        desc = pBillnumber.matcher(desc).replaceAll(String.valueOf(transaction.getBillnumber()));
        desc = pCardholder.matcher(desc).replaceAll(transaction.getCardholderName() != null ? transaction.getCardholderName() : "?");
        desc = pCardtype.matcher(desc).replaceAll(transaction.getCardtype() != null ? transaction.getCardtype() : "?");
        desc = pCardsubtype.matcher(desc).replaceAll(transaction.getCardsubtype() != null ? transaction.getCardsubtype() : "?");
        desc = pCardnumber.matcher(desc).replaceAll(transaction.getPan() != null ? transaction.getPan() : "?");
        desc = pName.matcher(desc).replaceAll(transaction.getName() != null ? transaction.getName() : "?");
        return desc;
    }

    public static void fillPayment(Transaction paymentDB, AssistProtocolRequestOrder order, AssistProtocolRequestOperation operation) {
        if (order != null) {
            if (Utils.notEmptyString((String)order.getBillnumber())) {
                paymentDB.setBillnumber(Long.valueOf(order.getBillnumber()));
            }
            if (Utils.notEmptyString((String)order.getOrdercomment())) {
                paymentDB.setComment(order.getOrdercomment());
            }
            if (order.getOrderdate() != null) {
                paymentDB.setCreateDate(order.getOrderdate());
            }
            if (Utils.notEmptyString((String)order.getEmail())) {
                paymentDB.setEmail(order.getEmail());
            }
            if (Utils.notEmptyString((String)order.getName())) {
                paymentDB.setName(order.getName());
            }
        }
        if (operation != null) {
            if (Utils.notEmptyString((String)operation.getCardholder())) {
                paymentDB.setCardholderName(operation.getCardholder());
            }
            if (Utils.notEmptyString((String)operation.getMeannumber())) {
                paymentDB.setPan(operation.getMeannumber());
            }
            if (Utils.notEmptyString((String)operation.getMeansubtype())) {
                paymentDB.setCardsubtype(operation.getMeansubtype());
            }
            if (Utils.notEmptyString((String)operation.getMeantypename())) {
                paymentDB.setCardtype(operation.getMeantypename());
            }
            if (Utils.notEmptyString((String)operation.getClientip())) {
                paymentDB.setIpaddress(operation.getClientip());
            }
            if (operation.getAmount() != null && operation.getAmount().compareTo(BigDecimal.ZERO) > 0) {
                paymentDB.setSum(operation.getAmount());
            }
            if (operation.getResponsecode() != null) {
                paymentDB.setResponseCode(operation.getResponsecode().name());
            }
        }
    }
}

