/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.aots.server.bean;

import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.modules.aots.common.bean.AOTSContractService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class AOTSContractServiceDao
extends AbstractDao<AOTSContractService> {
    public AOTSContractServiceDao(Connection con, int moduleId) {
        super(con, "aots_contract_service", moduleId);
    }

    public void searchAOTSContractService(SearchResult<AOTSContractService> searchResult, int contractId) throws SQLException {
        Objects.requireNonNull(searchResult, "searchResult must be not null");
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        String queryWhere = " WHERE true" + (contractId > 0 ? " AND contract_id=?" : "");
        String query = "SELECT * FROM " + this.tableName + queryWhere + " ORDER BY service_time" + this.sqlLimit(page);
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            if (contractId > 0) {
                ps.setInt(index++, contractId);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
            }
        }
    }

    protected AOTSContractService getFromRS(ResultSet rs) throws SQLException {
        return new AOTSContractService().setId(rs.getString("id")).setContractId(rs.getInt("contract_id")).setContractObjectId(rs.getInt("contract_object_id")).setEntityModuleId(rs.getInt("entity_module_id")).setEntityId(rs.getInt("entity_id")).setServiceId(rs.getInt("service_id")).setUserId(rs.getInt("user_id")).setServiceTime(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("service_time"))).setAmount(rs.getBigDecimal("amount")).setCost(rs.getBigDecimal("cost")).setServiceSum(rs.getBigDecimal("service_sum")).setComment(rs.getString("comment")).setNdsRate(rs.getBigDecimal("nds_rate"));
    }

    protected void updateImpl(AOTSContractService contractService) throws SQLException {
        Objects.requireNonNull(contractService);
        boolean update = contractService.getId() != null;
        String querySet = "contract_id=?, contract_object_id=?, entity_module_id=?, entity_id=?, service_id=?, user_id=?, service_time=?, amount=?, cost=?, nds_rate=?, service_sum=?, comment=?";
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET " + querySet + (update ? " WHERE id=?" : ", id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            if (!update) {
                contractService.setId(Utils.randomUUIDv7().toString());
            }
            int index = 1;
            ps.setInt(index++, contractService.getContractId());
            ps.setInt(index++, contractService.getContractObjectId());
            ps.setInt(index++, contractService.getEntityModuleId());
            ps.setInt(index++, contractService.getEntityId());
            ps.setInt(index++, contractService.getServiceId());
            ps.setInt(index++, contractService.getUserId());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)contractService.getServiceTime()));
            ps.setBigDecimal(index++, contractService.getAmount());
            ps.setBigDecimal(index++, contractService.getCost());
            ps.setBigDecimal(index++, contractService.getNdsRate());
            ps.setBigDecimal(index++, contractService.getServiceSum());
            ps.setString(index++, contractService.getComment());
            ps.setString(index++, contractService.getId());
            ps.executeUpdate();
        }
    }

    public int delete(@Nonnull String id) throws SQLException {
        Objects.requireNonNull(id, "id must be not null");
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, id);
            int n = ps.executeUpdate();
            return n;
        }
    }

    public AOTSContractService getById(String id) throws SQLException {
        Objects.requireNonNull(id, "id must not be null");
        AOTSContractService contractService = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setString(index++, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    contractService = this.getFromRS(rs);
                }
            }
        }
        return contractService;
    }

    public boolean deleteById(String id) throws SQLException {
        Objects.requireNonNull(id, "id must not be null");
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, id);
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
    }

    public BigDecimal getServiceSum(int contractId, int serviceId, Period period) throws SQLException {
        BigDecimal result = BigDecimal.ZERO;
        String query = "SELECT COALESCE(sum(service_sum),0) FROM " + this.tableName + " WHERE contract_id=? AND service_id=?" + this.queryPeriod(period, "DATE(service_time)");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setInt(index++, serviceId);
            this.psSetPeriod(ps, index, period);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = rs.getBigDecimal(1);
                }
            }
        }
        return result;
    }
}

