#!/bin/bash

cd ${0%${0##*/}}/..

FTP_DIR='ftp://ftp.bgbilling.ru/pub/bgbilling/runner/'

F=`curl -s -l ${FTP_DIR} | grep .jar`
RV=`echo $F | cut -d '_' -f 2 | cut -d '.' -f 1`

echo "REMOTE VERSION = ${RV}"

if [ ! -d runner ]; then
    echo "Create directory - ../runner"
    mkdir runner
fi

LV=`find runner -name "runner_*.jar" | cut -d "_" -f 2 | cut -d '.' -f 1`

echo "LOCAL VERSION = ${LV}"

if [ -z "${LV}" -o "$RV" \> "$LV" ]; then
    echo "Clear directory ../runner"
    rm -f runner/*
    echo "Download ${FTP_DIR}${F}"
    curl -s ${FTP_DIR}${F} -o runner/${F}
fi