/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.List;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.modules.voice.common.event.VoiceOperatorModifiedEvent;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceOperatorService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceOperatorDao;
import ru.bitel.common.model.Id;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceOperatorService")
public class VoiceOperatorServiceImpl
extends AbstractService
implements VoiceOperatorService {
    private VoiceOperatorDao voiceOperatorDao;

    @PostConstruct
    private void init() {
        this.voiceOperatorDao = new VoiceOperatorDao(this.getConnection(), this.moduleId);
    }

    public List<VoiceOperator> voiceOperatorList() throws Exception {
        return this.voiceOperatorDao.list();
    }

    public VoiceOperator voiceOperatorGet(int id) throws Exception {
        return (VoiceOperator)this.voiceOperatorDao.get(id);
    }

    public int voiceOperatorUpdate(VoiceOperator operator) throws Exception {
        VoiceOperator oldOperator = (VoiceOperator)this.voiceOperatorDao.getAndUpdate((Id)operator);
        this.voiceOperatorDao.update(operator);
        this.context.publishAfterCommit((Event)new VoiceOperatorModifiedEvent(this.moduleId, this.userId, oldOperator, operator));
        return operator.getId();
    }

    public int voiceOperatorDelete(int id) throws Exception {
        VoiceOperator oldOperator = (VoiceOperator)this.voiceOperatorDao.getAndDelete(id);
        this.context.publishAfterCommit((Event)new VoiceOperatorModifiedEvent(this.moduleId, this.userId, oldOperator, null));
        return this.voiceOperatorDao.delete(id);
    }
}

