/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.task;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.GregorianCalendar;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.VoiceAccountState;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.VoiceAccountStatus;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountDao;
import ru.bitel.bgbilling.modules.voice.server.event.om.OmVoiceAccountStateModifyEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class VoiceAccountPeriodTask
extends TaskBase {
    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            this.executeTaskImpl(con);
        }
        catch (BGException ex) {
            this.logError(ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private void executeTaskImpl(Connection con) throws BGException {
        Date now = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(now);
        int yy = calendar.get(1);
        int mm = calendar.get(2) + 1;
        EventProcessor eventProcessor = EventProcessor.getInstance();
        try (VoiceAccountDao accountDao = new VoiceAccountDao(con, this.moduleId);
             ContractDao contractDao = new ContractDao(con, 0);
             BalanceDao balanceDao = new BalanceDao(con);){
            for (VoiceAccount account : accountDao.listToCancel(now)) {
                eventProcessor.publish((Event)new OmVoiceAccountStateModifyEvent(this.moduleId, account, VoiceAccountState.STATE_DELETED.getCode()));
            }
            for (VoiceAccount account : accountDao.listToCreate(now)) {
                Contract contract = (Contract)contractDao.get(account.getContractId());
                VoiceAccountState deviceState = VoiceAccountState.STATE_ENABLE;
                if (account.getStatus().getCode() != VoiceAccountStatus.STATUS_ON.getCode()) {
                    deviceState = VoiceAccountState.STATE_DISABLE;
                } else if (!StatusCache.getInstance().isModuleActiveStatus(this.moduleId, (int)contract.getStatus())) {
                    deviceState = VoiceAccountState.STATE_DISABLE;
                } else {
                    int contractId = contract.isDependSub() ? contract.getSuperCid() : contract.getId();
                    BigDecimal balance = balanceDao.getBalance(contractId, yy, mm);
                    if (contract.getBalanceLimit().compareTo(balance) > 0) {
                        deviceState = VoiceAccountState.STATE_DISABLE;
                    }
                }
                eventProcessor.publish((Event)new OmVoiceAccountStateModifyEvent(this.moduleId, account, deviceState.getCode()));
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Voice. \u0417\u0430\u0434\u0430\u0447\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438/\u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432 \u043f\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0443. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }
}

