/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.processor.worker;

import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.apps.voice.processor.worker.ProcessorWorker;
import ru.bitel.bgbilling.apps.voice.processor.worker.ProcessorWorkerTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContextThreadFactory;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceLogProccessor;

public class ProcessorWorkerSet
extends BGLogger
implements Lifecycle {
    private final VoiceLogProccessor processor;
    private List<ProcessorWorker> workers;

    public ProcessorWorkerSet(VoiceLogProccessor processor) {
        this.processor = processor;
    }

    public void start() throws BGException {
        this.getLogger().debug("Starting processor workers");
        ServerContextThreadFactory threadContextFactory = new ServerContextThreadFactory(this.processor.getSetup(), this.processor.getModuleId(), null, null);
        this.workers = new ArrayList<ProcessorWorker>();
        boolean tariffication = false;
        boolean tracking = false;
        boolean flushing = false;
        boolean finishing = false;
        boolean sessionCountCheck = false;
        boolean restrictionCheck = false;
        boolean aliveEventGen = false;
        if (!tariffication) {
            this.getLogger().error("Tariffication worker not started. Check config!");
        }
        if (!tracking) {
            this.getLogger().error("Tracking worker not started. Check config!");
        }
        if (!flushing) {
            this.getLogger().error("Flushing worker not started. Check config!");
        }
        if (!finishing) {
            this.getLogger().error("Finishing worker not started. Check config!");
        }
    }

    public void stop() throws InterruptedException {
        this.getLogger().debug("Stopping accounting workers....");
        for (ProcessorWorker worker : this.workers) {
            worker.stop();
        }
        for (ProcessorWorker worker : this.workers) {
            worker.destroy();
        }
        this.workers.clear();
        this.workers = null;
        this.getLogger().debug("... done");
    }

    static interface BuildAccountingWorkerTask<A, B, C, D> {
        public ProcessorWorkerTask build(A var1, B var2, C var3, D var4);
    }
}

