/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vidimax.server.bean;

import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.vidimax.common.VidimaxCharge;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class VidimaxChargeDao
extends AbstractIdDao<VidimaxCharge> {
    private static final Object createTableMutex = new Object();
    Date date;

    public VidimaxChargeDao(Connection con, int moduleId, Date date) {
        super(con, "vidimax_charge", moduleId, date);
        this.date = date;
    }

    public List<VidimaxCharge> getChargeList(int contractId, Period period, Page page, Holder<BigDecimal> holderTotalSum) throws SQLException {
        List<Object> result = new ArrayList<VidimaxCharge>();
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            return result;
        }
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE contractId=" + contractId + this.queryPeriod(period, "date") + " ORDER BY date" + this.sqlLimit(page);
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            this.psSetPeriod(ps, 1, period);
            try (ResultSet rs = ps.executeQuery();){
                if (holderTotalSum != null) {
                    Double sumL = 0.0;
                    while (rs.next()) {
                        sumL = sumL + rs.getDouble("sum");
                        result.add(this.getFromRS(rs));
                    }
                    holderTotalSum.value = new BigDecimal(sumL);
                } else {
                    result = this.getListFromRS(rs);
                }
                if (page != null) {
                    page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
                }
            }
            List<Object> list = result;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkTable() throws SQLException {
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            Object object = createTableMutex;
            synchronized (object) {
                if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
                    String query = "CREATE TABLE " + this.tableName + " ( id INT(11) NOT NULL AUTO_INCREMENT,contractId INT NOT NULL,date DATETIME NOT NULL,operationId VARCHAR(45) NOT NULL,customerId VARCHAR(45) NOT NULL,deviceId VARCHAR(45) NULL,tariffId INT NOT NULL,serviceTypeId INT NOT NULL,sum DECIMAL(10,2) NOT NULL,comment VARCHAR(120) NULL,pin VARCHAR(45) NULL,PRIMARY KEY (`id`),INDEX `cid` (`contractId`),INDEX `operationId` (`operationId`) )";
                    try (Statement st = this.con.createStatement();){
                        st.execute(query);
                    }
                    ServerUtils.checkAndCreatePeriodicTableName((Connection)this.con, (String)this.tableName, (String)query);
                }
            }
        }
    }

    protected VidimaxCharge getFromRS(ResultSet rs) throws SQLException {
        VidimaxCharge vidimaxCharge = new VidimaxCharge();
        vidimaxCharge.setId(rs.getInt("id"));
        vidimaxCharge.setContractId(rs.getInt("contractId"));
        vidimaxCharge.setDate((Date)rs.getTimestamp("date"));
        vidimaxCharge.setOperationId(rs.getString("operationId"));
        vidimaxCharge.setCustomerId(rs.getString("customerId"));
        vidimaxCharge.setDeviceId(rs.getString("deviceId"));
        vidimaxCharge.setTariffId(rs.getInt("tariffId"));
        vidimaxCharge.setServiceTypeId(rs.getInt("serviceTypeId"));
        vidimaxCharge.setSum(rs.getBigDecimal("sum"));
        vidimaxCharge.setComment(rs.getString("comment"));
        vidimaxCharge.setPin(rs.getString("pin"));
        return vidimaxCharge;
    }

    protected void updateImpl(VidimaxCharge charge) throws SQLException {
        boolean update;
        Objects.requireNonNull(charge);
        boolean bl = update = charge.getId() > 0;
        if (!update) {
            this.checkTable();
            String query = "INSERT INTO " + this.tableName + " SET contractId=?, date=?, operationId=?, customerId=?, deviceId=?, tariffId=?, serviceTypeId=?, sum=?, comment=?, pin=?";
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                int index = 1;
                ps.setInt(index++, charge.getContractId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)charge.getDate()));
                ps.setString(index++, charge.getOperationId());
                ps.setString(index++, charge.getCustomerId());
                ps.setString(index++, charge.getDeviceId());
                ps.setInt(index++, charge.getTariffId());
                ps.setInt(index++, charge.getServiceTypeId());
                ps.setBigDecimal(index++, charge.getSum());
                ps.setString(index++, charge.getComment());
                ps.setString(index++, charge.getPin());
                ps.executeUpdate();
                charge.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public boolean uniqueOperationId(String operationId) throws SQLException {
        boolean result = true;
        String query = "SELECT * FROM " + this.tableName + " WHERE operationId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, operationId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = false;
                }
            }
        }
        return result;
    }
}

