/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vepay.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.vepay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.vepay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.vepay.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.vepay.server.event.VepayAutopaymentSumEvent;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public Map<String, String> fields = new HashMap<String, String>();

    public TransactionManager(Connection con, int moduleId) {
        super(con, "vepay_transaction", moduleId);
        this.fields.put("id", "id");
        this.fields.put("createDate", "create_date");
        this.fields.put("transactionDate", "transaction_date");
        this.fields.put("sum", "sum");
    }

    protected void queryStatus(StringBuilder query, String status) {
        if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
            query.append(" AND pt.result=?");
        }
    }

    protected int psStatus(PreparedStatement ps, String status, int index) throws SQLException {
        if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
            ps.setString(index++, status);
        }
        return index;
    }

    public Transaction getTransactionByTransactionId(String transactionId) throws BGException {
        Transaction transaction = null;
        try {
            String query = "SELECT " + this.tableName + ".*, c.title AS contract_title" + " FROM " + this.tableName + " LEFT JOIN contract c ON c.id=" + this.tableName + ".contract_id" + " WHERE " + "transaction_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, transactionId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                transaction = this.getFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return transaction;
    }

    public void doCheck(int contractId) {
        try {
            SearchParam searchParam = SearchParam.builder().setContractId(contractId).setStatus(TransactionStatus.CREATED.getCode()).build();
            SearchResult searchResult = new SearchResult(new Page(1, 25));
            this.searchTransaction(searchResult, searchParam);
            LocalDateTime checkTime = LocalDateTime.now().minusMinutes(30L);
            for (Transaction transaction : searchResult.getList()) {
                if (TimeUtils.convertDateToLocalDateTime((Date)transaction.getCreateDate()).isAfter(checkTime)) continue;
                this.doCheckRequest(transaction);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public void doCheckRequest(Transaction transaction) {
        try {
            JSONObject outputJSON = new JSONObject();
            outputJSON.put("id", Long.parseLong(transaction.getTransactionId()));
            String outputText = outputJSON.toString();
            String gateUrl = this.moduleSetup.get("vepay.url.gate", "https://test.vepay.online") + "/merchant/state";
            HashMap<String, String> requestProperties = new HashMap<String, String>();
            requestProperties.put("X-Login", this.moduleSetup.get("vepay.x.login", "noSetLogin"));
            requestProperties.put("X-Token", Utils.getDigest((String)(Utils.getDigest((String)this.moduleSetup.get("vepay.key", ""), (String)"UTF-8", (String)"SHA1").toLowerCase() + Utils.getDigest((String)outputText, (String)"UTF-8", (String)"SHA1").toLowerCase()), (String)"UTF-8", (String)"SHA1").toLowerCase());
            try {
                AutopaymentManager autopaymentManager;
                Autopayment autopayment;
                int cardId;
                JSONObject card;
                StringBuilder result = this.doConnection(gateUrl, "POST", true, outputText, requestProperties);
                JSONObject inputJSON = new JSONObject(result.toString());
                transaction.setParameters(this.setParameter(transaction.getParameters(), "json", inputJSON.toString()));
                transaction.setTransactionDate(new Date());
                PaymentDao paymentDao = new PaymentDao(this.con);
                this.doPayment(transaction, inputJSON.optString("status"), paymentDao);
                int autopaymentId = Utils.parseInt((String)this.getParameter(transaction.getParameters(), "autopaymentId"));
                if (autopaymentId > 0 && (card = inputJSON.optJSONObject("card")) != null && (cardId = card.optInt("id")) > 0 && (autopayment = (autopaymentManager = new AutopaymentManager(this.con, this.moduleId)).getAutopayment(autopaymentId)) != null) {
                    if (transaction.getStatus().equals(TransactionStatus.OK.getCode())) {
                        autopayment.setAccessToken(String.valueOf(cardId));
                        autopayment.getPeriod().setLocalDateTimeFrom(LocalDateTime.now());
                    } else {
                        autopayment.setAccessToken(null);
                        autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                    }
                    autopaymentManager.update(autopayment);
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public void doPayment(Transaction transaction, String status, PaymentDao paymentDao) throws Exception {
        if (transaction == null || status == null || transaction.getStatus().equals(status)) {
            return;
        }
        Payment payment = null;
        if (TransactionStatus.OK.getCode().equals(status) && transaction.getPaymentId() < 1) {
            transaction.setStatus(status);
            Date paymentDate = transaction.getTransactionDate();
            if (paymentDate == null) {
                paymentDate = new Date();
                transaction.setTransactionDate(paymentDate);
            }
            payment = Payment.builder().setDate(paymentDate).setTypeId(this.moduleSetup.getInt("vepay.payment.type.id", 0)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(this.moduleSetup.get("vepay.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441 vepay [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId()))).build();
            paymentDao.update((Object)payment);
            transaction.setPaymentId(payment.getId());
        } else if (TransactionStatus.CANCELED.getCode().equals(status)) {
            transaction.setStatus(status);
            if (transaction.getPaymentId() > 0) {
                payment = (Payment)paymentDao.get(transaction.getPaymentId());
                if (payment != null) {
                    paymentDao.delete(payment.getId());
                }
                transaction.setPaymentId(-1);
            }
        } else if (TransactionStatus.ERROR.getCode().equals(status)) {
            transaction.setStatus(status);
        } else {
            return;
        }
        this.update(transaction);
        if (payment != null) {
            try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                balanceUtils.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
            }
            EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
        }
    }

    public String doPaymentRequest(Transaction transaction, BigDecimal sum, String description, String successurl, String failurl, boolean regcard) {
        JSONObject outputJSON = new JSONObject();
        outputJSON.put("amount", (Object)sum.toPlainString());
        outputJSON.put("extid", (Object)String.valueOf(transaction.getId()));
        outputJSON.put("descript", (Object)description);
        outputJSON.put("timeout", this.moduleSetup.getInt("vepay.timeout", 10));
        outputJSON.put("successurl", (Object)successurl);
        outputJSON.put("failurl", (Object)failurl);
        outputJSON.put("cancelurl", (Object)this.moduleSetup.get("vepay.url.cancel", ""));
        if (regcard) {
            outputJSON.put("regcard", 1);
        }
        String outputText = outputJSON.toString();
        String gateUrl = this.moduleSetup.get("vepay.url.gate", "https://test.vepay.online") + "/merchant/pay";
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        requestProperties.put("X-Login", this.moduleSetup.get("vepay.x.login", "noSetLogin"));
        requestProperties.put("X-Token", Utils.getDigest((String)(Utils.getDigest((String)this.moduleSetup.get("vepay.key", ""), (String)"UTF-8", (String)"SHA1").toLowerCase() + Utils.getDigest((String)outputText, (String)"UTF-8", (String)"SHA1").toLowerCase()), (String)"UTF-8", (String)"SHA1").toLowerCase());
        try {
            StringBuilder result = this.doConnection(gateUrl, "POST", true, outputText, requestProperties);
            JSONObject inputJSON = new JSONObject(result.toString());
            transaction.setTransactionId(inputJSON.optString("id", null));
            this.update(transaction);
            return inputJSON.optString("url", null);
        }
        catch (Exception ex) {
            this.logError(ex);
            return null;
        }
    }

    public Transaction doRecurrentRequest(int contractId, BigDecimal sum, String cardId) throws Exception {
        VepayAutopaymentSumEvent event = new VepayAutopaymentSumEvent(this.moduleId, contractId, sum);
        BigDecimal newSum = ((VepayAutopaymentSumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
        if (newSum != null) {
            sum = newSum;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("sum = " + String.valueOf(sum));
        }
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(sum)).setContractId(contractId)).setCreateDate(new Date())).setAutopayment(true)).setTransactionId(String.valueOf(System.currentTimeMillis() + (long)(100.0 * Math.random())))).build();
        this.update(transaction);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("transaction = " + transaction.toString());
        }
        JSONObject outputJSON = new JSONObject();
        outputJSON.put("card", (Object)cardId);
        outputJSON.put("extid", (Object)String.valueOf(transaction.getId()));
        outputJSON.put("amount", (Object)this.getFormatSum(sum));
        String outputText = outputJSON.toString();
        String gateUrl = this.moduleSetup.get("vepay.url.gate", "https://test.vepay.online") + "/recarring/pay";
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        requestProperties.put("X-Login", this.moduleSetup.get("vepay.x.login", "noSetLogin"));
        requestProperties.put("X-Token", Utils.getDigest((String)(Utils.getDigest((String)this.moduleSetup.get("vepay.key", ""), (String)"UTF-8", (String)"SHA1").toLowerCase() + Utils.getDigest((String)outputText, (String)"UTF-8", (String)"SHA1").toLowerCase()), (String)"UTF-8", (String)"SHA1").toLowerCase());
        try {
            StringBuilder result = this.doConnection(gateUrl, "POST", true, outputText, requestProperties);
            JSONObject inputJSON = new JSONObject(result.toString());
            int status = inputJSON.optInt("status");
            if (status == 1) {
                transaction.setTransactionId(inputJSON.optString("id", null));
            } else {
                transaction.setStatus(TransactionStatus.ERROR.getCode());
            }
            transaction.setParameters(this.setParameter(transaction.getParameters(), "json", inputJSON.toString()));
            this.update(transaction);
            return transaction;
        }
        catch (Exception ex) {
            this.logError(ex);
            ArrayList resultCSV = new ArrayList();
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442: ");
                    for (String str : resultCSV) {
                        this.getLogger().debug("\t" + str);
                    }
                }
            }
            catch (Exception ex2) {
                this.getLogger().error(ex2.getMessage());
            }
            HashMap<String, String> dataMap = new HashMap<String, String>();
            if (resultCSV.size() > 0) {
                ArrayList<String> names = new ArrayList<String>();
                for (String name : ((String)resultCSV.get(0)).split(";")) {
                    names.add(name);
                }
                if (resultCSV.size() > 1) {
                    for (int index = 1; index < resultCSV.size(); ++index) {
                        String[] values = ((String)resultCSV.get(index)).split(";");
                        for (int indexV = 0; indexV < Math.min(names.size(), values.length); ++indexV) {
                            dataMap.put((String)names.get(indexV), values[indexV]);
                        }
                    }
                }
            }
            Payment payment = null;
            if (dataMap.containsKey("ErrorCode")) {
                transaction.setStatus(TransactionStatus.ERROR.getCode());
            } else {
                transaction.setStatus(TransactionStatus.OK.getCode());
                Date paymentDate = transaction.getTransactionDate();
                if (paymentDate == null) {
                    paymentDate = new Date();
                    transaction.setTransactionDate(paymentDate);
                }
                payment = Payment.builder().setDate(paymentDate).setTypeId(this.moduleSetup.getInt("vepay.payment.type.id", 0)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).build();
                new PaymentDao(this.con).update((Object)payment);
                transaction.setPaymentId(payment.getId());
            }
            transaction.setParameters(transaction.getParameters() + "\n" + Utils.toString(dataMap, (String)"\n"));
            this.update(transaction);
            if (payment != null) {
                ServerUtils.commitConnection((Connection)this.con);
                BalanceUtils balanceUtils = new BalanceUtils(this.con);
                balanceUtils.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                balanceUtils.close();
                ServerUtils.commitConnection((Connection)this.con);
                EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
            }
            return transaction;
        }
    }

    public String getFormatSum(BigDecimal sum) {
        DecimalFormat decimalFormat = new DecimalFormat("###########0.00");
        return decimalFormat.format(sum).replace(",", ".");
    }

    public String getReceipt(BigDecimal sum, String customerAddress, String contractTitle) {
        JSONObject customerJSON = new JSONObject();
        customerJSON.put("id", (Object)contractTitle);
        if (!Utils.isBlankString((String)customerAddress)) {
            if (customerAddress.contains("@")) {
                customerJSON.put("email", (Object)customerAddress);
            } else {
                customerJSON.put("phone", (Object)customerAddress);
            }
        }
        JSONObject lineJSON = new JSONObject();
        lineJSON.put("name", (Object)this.moduleSetup.get("vepay.fiscalization.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle));
        lineJSON.put("price", (Object)sum);
        lineJSON.put("qty", this.moduleSetup.getInt("vepay.fiscalization.receipt.qty", 1));
        lineJSON.put("sum", (Object)sum);
        lineJSON.put("vat", this.moduleSetup.getInt("vepay.fiscalization.receipt.vat", 0));
        lineJSON.put("payattr", this.moduleSetup.getInt("vepay.fiscalization.receipt.payattr", 1));
        lineJSON.put("lineattr", this.moduleSetup.getInt("vepay.fiscalization.receipt.lineattr", 4));
        JSONArray linesJSON = new JSONArray();
        linesJSON.put((Object)lineJSON);
        JSONObject paymentJSON = new JSONObject();
        paymentJSON.put("kind", this.moduleSetup.getInt("vepay.fiscalization.receipt.payments.kind", 1));
        paymentJSON.put("type", this.moduleSetup.getInt("vepay.fiscalization.receipt.payments.type", 0));
        paymentJSON.put("amount", (Object)sum);
        JSONArray paymentsJSON = new JSONArray();
        paymentsJSON.put((Object)paymentJSON);
        JSONObject receiptJSON = new JSONObject();
        receiptJSON.put("customer", (Object)customerJSON);
        receiptJSON.put("taxmode", this.moduleSetup.getInt("vepay.fiscalization.receipt.taxmode", 0));
        receiptJSON.put("lines", (Object)linesJSON);
        receiptJSON.put("payments", (Object)paymentsJSON);
        receiptJSON.put("total", (Object)sum);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("receipt = " + receiptJSON.toString());
        }
        return receiptJSON.toString();
    }

    public String getReceiptSignature(Object shopIdp, Object orderIdp, Object subTotalP, Object receipt) {
        String receiptSignature = new StringBuffer().append(Utils.getDigest((String)String.valueOf(shopIdp), (String)"ASCII", (String)"SHA-256").toLowerCase()).append("&").append(Utils.getDigest((String)String.valueOf(orderIdp), (String)"ASCII", (String)"SHA-256").toLowerCase()).append("&").append(Utils.getDigest((String)String.valueOf(subTotalP), (String)"ASCII", (String)"SHA-256").toLowerCase()).append("&").append(Utils.getDigest((String)String.valueOf(receipt), (String)"ASCII", (String)"SHA-256").toLowerCase()).append("&").append(Utils.getDigest((String)this.moduleSetup.get("vepay.key", ""), (String)"ASCII", (String)"SHA-256").toLowerCase()).toString();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("shopIdp = " + String.valueOf(shopIdp));
            this.getLogger().debug("orderIdp = " + String.valueOf(orderIdp));
            this.getLogger().debug("subTotalP = " + String.valueOf(subTotalP));
            this.getLogger().debug("receipt = " + String.valueOf(receipt));
            this.getLogger().debug("receiptSignature = " + receiptSignature);
        }
        return Utils.getDigest((String)receiptSignature, (String)"ASCII", (String)"SHA-256");
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("contract_id"))).setContractTitle(rs.getString("contract_title"))).setPaymentId(rs.getInt("payment_id"))).setCreateDate((Date)rs.getTimestamp("create_date"))).setTransactionDate((Date)rs.getTimestamp("transaction_date"))).setTransactionId(rs.getString("transaction_id"))).setStatus(rs.getString("result"))).setParameters(rs.getString("params"))).setSum(rs.getBigDecimal("sum"))).setAutopayment(rs.getBoolean("autopayment"))).build();
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, result=?, params=?, sum=?, autopayment=?";
        try (PreparedStatement ps = this.prepareStatement((Id)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getTransactionId());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getParameters());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setBoolean(index++, transaction.isAutopayment());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    protected void setConnectionTimeout(HttpsURLConnection connection) {
        connection.setConnectTimeout(this.moduleSetup.getInt("vepay.request.timeout", 10000));
        connection.setReadTimeout(this.moduleSetup.getInt("vepay.request.read.timeout", 5000));
    }
}

