/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.copy;

import jakarta.annotation.Resource;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.HandlerResolver;
import jakarta.xml.ws.handler.PortInfo;
import java.net.InetSocketAddress;
import java.net.URI;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.apps.tv.access.TvAccess;
import ru.bitel.bgbilling.apps.tv.access.om.AbstractOrderEvent;
import ru.bitel.bgbilling.apps.tv.access.om.AccountOrderEvent;
import ru.bitel.bgbilling.apps.tv.access.om.ProductOrderEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.enums.ContractFace;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDevice;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDeviceType;
import ru.bitel.bgbilling.modules.tv.common.om.OrderManager;
import ru.bitel.bgbilling.modules.tv.common.om.OrderManagerAdapter;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.common.CommonMngFacadeAPI;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.common.CommonMngFacadeAPIService;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.Address;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.EntityUniqueException_Exception;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.Household;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.InvalidParameterException_Exception;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.Name;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.OperationFailedException_Exception;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.ServiceArray;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.ServiceGroup;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.ServiceGroupArray;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.SubscriberMngFacadeAPI;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.SubscriberMngFacadeAPIService;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.LoggingSOAPHandlerClient;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.util.TimeoutMap;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.service.common.bean.ServiceSpec;

public class TelecomTvOrderManager
extends OrderManagerAdapter
implements OrderManager {
    @Resource(name="access")
    private TvAccess access;
    private Connection con;
    private String host;
    private int port;
    private CommonMngFacadeAPI commonMngFacadeAPI;
    private SubscriberMngFacadeAPI subscriberMngFacadeAPI;
    private String username;
    private String password;
    private long regionId;
    private String lang;
    private String integrationMode;
    private String clientId;
    private TimeoutMap<Long, Long> householdTariffMap;
    private ContractDao contractDao;
    private int customerTypePid;
    private int customerTypePidCorporate;
    private long customerTypeIndividual;
    private long customerTypeCorporate;
    private int customerLastNamePid;
    private int customerFirstNamePid;
    private int customerCompanyPid;
    private int customerAddressPid;
    private int customerPhonePid;
    private boolean productSyncMode;
    private boolean serviceMode;
    private String tariffDefault;
    private Set<Integer> tariffProductParentIds;
    private int tariffProductEntitySpecAttrId;
    private int tariffProductEntityAttrValue;

    private boolean isTariff(ProductSpec productSpec) {
        EntityAttrList ea;
        if (this.tariffProductParentIds != null && this.tariffProductParentIds.contains(productSpec.getParentId())) {
            return true;
        }
        return this.tariffProductEntitySpecAttrId > 0 && (ea = (EntityAttrList)productSpec.getEntityAttributes().get(this.tariffProductEntitySpecAttrId)) != null && ea.getValue() == this.tariffProductEntityAttrValue;
    }

    public Object init(ServerContext ctx, int moduleId, TvDevice tvDevice, TvDeviceType tvDeviceType, ParameterMap config) throws Exception {
        String host = null;
        int port = 0;
        List addressList = tvDevice.getHosts();
        if (addressList.size() > 0) {
            InetSocketAddress socketAddress = (InetSocketAddress)addressList.get(0);
            host = socketAddress.getAddress().getHostAddress();
            port = socketAddress.getPort();
        }
        if (Utils.isBlankString(host)) {
            host = "127.0.0.1";
        }
        if (port <= 0) {
            port = 8080;
        }
        this.username = config.get("om.login", config.get("om.username", tvDevice.getUsername()));
        this.password = config.get("om.password", tvDevice.getPassword());
        this.getLogger().info(this.username + "/" + this.password);
        this.regionId = config.getLong("om.regionId", -1L);
        this.lang = config.get("om.lang", "ru");
        this.integrationMode = config.get("om.integrationMode", "Prepaid 2.0");
        this.productSyncMode = config.getInt("om.product.syncMode", 1) > 0;
        this.serviceMode = config.getInt("om.product.serviceMode", 0) > 0;
        this.host = host;
        this.port = port;
        this.tariffDefault = config.get("om.tariff.default", "");
        this.tariffProductParentIds = Utils.toIntegerSet((String)config.get("om.tariff.product.parentIds", null));
        if (this.tariffProductParentIds.size() == 0) {
            this.tariffProductParentIds = null;
        }
        this.tariffProductEntitySpecAttrId = config.getInt("om.tariff.product.entitySpecAttrId", 0);
        this.tariffProductEntityAttrValue = config.getInt("om.tariff.product.entityAttrValue", 0);
        this.customerTypePid = config.getInt("customer.type.pid", 0);
        this.customerTypePidCorporate = config.getInt("customer.type.pid.corporate", 0);
        this.customerTypeIndividual = config.getInt("customer.type.individual", 1);
        this.customerTypeCorporate = config.getInt("customer.type.corporate", 2);
        this.customerLastNamePid = config.getInt("customer.lastName.pid", 0);
        this.customerFirstNamePid = config.getInt("customer.firstName.pid", 0);
        this.customerCompanyPid = config.getInt("customer.company.pid", 0);
        this.customerAddressPid = config.getInt("customer.address.pid", 0);
        this.customerPhonePid = config.getInt("customer.phone.pid", 0);
        this.householdTariffMap = new TimeoutMap("householdTariffMap" + tvDevice.getId() + "Cleaner");
        return null;
    }

    public Object destroy() throws Exception {
        return null;
    }

    public Object connect(ServerContext ctx) throws Exception {
        Connection con;
        this.con = con = ctx.getConnection();
        this.contractDao = new ContractDao(con, 0);
        if (this.commonMngFacadeAPI == null || this.subscriberMngFacadeAPI == null) {
            String urlString = "http://" + this.host + ":" + this.port;
            CommonMngFacadeAPIService commonMngFacadeAPIService = new CommonMngFacadeAPIService(URI.create(urlString + "/AdminAPI/CommonMngFacadeAPI?wsdl").toURL());
            commonMngFacadeAPIService.setHandlerResolver(this.newHandlerResolver(commonMngFacadeAPIService));
            this.commonMngFacadeAPI = commonMngFacadeAPIService.getCommonMngFacadeAPIPort();
            Map requestContext = ((BindingProvider)this.commonMngFacadeAPI).getRequestContext();
            requestContext.put("jakarta.xml.ws.service.endpoint.address", urlString + "/AdminAPI/CommonMngFacadeAPI");
            SubscriberMngFacadeAPIService subscriberMngFacadeAPIService = new SubscriberMngFacadeAPIService(URI.create(urlString + "/AdminAPI/SubscriberMngFacadeAPI?wsdl").toURL());
            subscriberMngFacadeAPIService.setHandlerResolver(this.newHandlerResolver(subscriberMngFacadeAPIService));
            this.subscriberMngFacadeAPI = subscriberMngFacadeAPIService.getSubscriberMngFacadeAPIPort();
            requestContext = ((BindingProvider)this.subscriberMngFacadeAPI).getRequestContext();
            requestContext.put("jakarta.xml.ws.service.endpoint.address", urlString + "/AdminAPI/SubscriberMngFacadeAPI");
        }
        this.clientId = this.commonMngFacadeAPI.login(this.username, this.password);
        return null;
    }

    public Object disconnect(ServerContext ctx) throws Exception {
        this.commonMngFacadeAPI.logout(this.clientId);
        return null;
    }

    public Object accountCreate(AccountOrderEvent e, ServerContext ctx) throws Exception {
        this.getLogger().info("accountCreate");
        return this.accountModify(e, ctx);
    }

    public Object accountModify(AccountOrderEvent e, ServerContext ctx) throws Exception {
        this.getLogger().info("accountModify");
        try {
            long householdId = this.accountModify0(e, ctx);
            if (e.isOptionsModified()) {
                this.accountOptionsModify0(e, ctx, householdId, false);
            }
            for (AccountOrderEvent.AccountEntry child : e.getChildrenEntryList()) {
                this.terminalModify(householdId, child, ctx);
            }
            this.productsModifySyncFull(householdId, e, ctx);
        }
        catch (EntityUniqueException_Exception ex) {
            this.logError(ex);
            return false;
        }
        catch (InvalidParameterException_Exception ex) {
            this.logError(ex);
            return false;
        }
        return null;
    }

    private long accountModify0(AccountOrderEvent e, ServerContext ctx) throws Exception {
        long householdId;
        EntityAttrAddress entityAttrAddress;
        Object name;
        String company;
        String phoneNumber;
        this.getLogger().info("accountModify0");
        int contractId = e.getContractId();
        TvAccount tvAccount = e.getNewTvAccount();
        Contract contract = (Contract)this.contractDao.get(contractId);
        long typeId = this.customerTypeIndividual;
        if (this.customerTypePid > 0) {
            if (this.contractDao.getContractParameterList(contractId, this.customerTypePid).map(EntityAttrList::getValue).orElse(0) == this.customerTypePidCorporate) {
                typeId = this.customerTypeCorporate;
            }
        } else if (contract.getFace() == ContractFace.URIC) {
            typeId = this.customerTypeCorporate;
        }
        String string = phoneNumber = this.customerPhonePid > 0 ? (String)this.contractDao.getContractParameterPhone(contractId, this.customerPhonePid).map(EntityAttrPhone::toString).orElse(null) : null;
        String string2 = this.customerCompanyPid > 0 ? (String)this.contractDao.optContractParameterTextAsString(contractId, this.customerCompanyPid).orElse(null) : (company = typeId == this.customerTypeIndividual ? "" : contract.getComment());
        Object lastName = this.customerLastNamePid > 0 ? (String)this.contractDao.optContractParameterTextAsString(contractId, this.customerLastNamePid).orElse(null) : (typeId == this.customerTypeIndividual ? contract.getComment() : "");
        Object firstName = "";
        if (this.customerFirstNamePid > 0) {
            firstName = this.contractDao.optContractParameterTextAsString(contractId, this.customerFirstNamePid).orElse(null);
        } else if (lastName != null && ((String[])(name = ((String)lastName).split("\\s+"))).length >= 2) {
            lastName = name[0];
            firstName = name[1];
        }
        name = new Name();
        if (Utils.notBlankString((String)lastName)) {
            ((Name)name).setLastName((String)lastName);
            ((Name)name).setFirstName((String)(Utils.notBlankString((String)lastName) ? firstName : "_"));
        } else {
            ((Name)name).setLastName("_");
            ((Name)name).setFirstName("_");
        }
        Address address = null;
        if (this.customerAddressPid > 0 && (entityAttrAddress = (EntityAttrAddress)this.contractDao.getContractParameterAddress(contractId, this.customerAddressPid).orElse(null)) != null) {
            try (HouseDao houseDao = new HouseDao(this.con);){
                House house = houseDao.get(entityAttrAddress.getHouseId());
                address = new Address();
                address.setState("");
                address.setCity(house.optCity().map(IdTitle::getTitle).orElse(""));
                address.setStreet(house.optStreet().map(IdTitle::getTitle).orElse(""));
                address.setPostIndex(house.getPostIndex());
                address.setHouseNum(String.valueOf(house.getHouse()) + house.getFrac());
                address.setBuild("");
                address.setFlatNum(entityAttrAddress.getFlat());
            }
            catch (Exception ex) {
                this.logError(ex);
                address = null;
            }
        }
        if (address == null) {
            address = new Address();
            address.setState("");
            address.setCity("");
            address.setStreet("");
            address.setPostIndex("");
            address.setHouseNum("");
            address.setBuild("");
            address.setFlatNum("");
        }
        String tariffIdentifier = this.getTariffIdentifier(e, null);
        if (e.getOldTvAccount() == null || Utils.isBlankString((String)e.getOldTvAccount().getDeviceAccountId())) {
            this.getLogger().debug(String.valueOf(e.getOldTvAccount()));
            householdId = this.subscriberMngFacadeAPI.createHousehold(this.clientId, tvAccount.getLogin(), tvAccount.getPassword(), typeId, 1L, contract.getTitle(), Utils.maskNull((String)company), (Name)name, address, this.lang, Utils.maskNull((String)phoneNumber), Utils.parseLong((String)tariffIdentifier), this.integrationMode, Utils.maskBlank((String)tvAccount.getPin(), (String)""), e.getNewState() == 1 && Utils.notBlankString((String)tariffIdentifier));
            e.getEntry().setDeviceAccountId(String.valueOf(householdId));
        } else {
            householdId = Utils.parseLong((String)e.getOldTvAccount().getDeviceAccountId());
            this.subscriberMngFacadeAPI.updateHousehold(this.clientId, householdId, tvAccount.getLogin(), tvAccount.getPassword(), typeId, this.regionId, contract.getTitle(), Utils.maskNull((String)company), (Name)name, address, this.lang, Utils.maskNull((String)phoneNumber), Utils.parseLong((String)tariffIdentifier), this.integrationMode);
            if (e.getOldState() != e.getNewState()) {
                this.accountStateModify0(e, householdId, tariffIdentifier);
            }
        }
        return householdId;
    }

    private String getTariffIdentifier(AbstractOrderEvent e, boolean[] isFromOptions) throws BGException {
        if (e.getNewDeviceOptionIds() != null) {
            for (Integer productSpecId : e.getNewDeviceOptionIds()) {
                ProductSpecRuntime productSpecRuntime = (ProductSpecRuntime)this.access.productSpecRuntimeMap.get(productSpecId);
                if (!this.isTariff(productSpecRuntime.getProductSpec())) continue;
                this.getLogger().info("Tariff: " + String.valueOf(productSpecRuntime.getProductSpec()));
                String tariffIdentifier = productSpecRuntime.getProductSpec().getIdentifier();
                if (Utils.isBlankString((String)tariffIdentifier)) continue;
                if (isFromOptions != null) {
                    isFromOptions[0] = true;
                }
                return tariffIdentifier;
            }
        }
        if (isFromOptions != null) {
            isFromOptions[0] = false;
        }
        for (ProductSpec productSpec : e.getFullProductSpecSetToEnable()) {
            if (!this.isTariff(productSpec)) continue;
            this.getLogger().info("Tariff: " + String.valueOf(productSpec));
            String tariffIdentifier = productSpec.getIdentifier();
            if (Utils.isBlankString((String)tariffIdentifier)) continue;
            return tariffIdentifier;
        }
        this.getLogger().info("Custom tariff not found. Tariff is " + this.tariffDefault);
        return this.tariffDefault;
    }

    public Object accountRemove(AccountOrderEvent e, ServerContext ctx) throws Exception {
        this.getLogger().info("accountRemove");
        TvAccount tvAccount = e.getOldTvAccount();
        long householdId = Utils.parseLong((String)tvAccount.getDeviceAccountId());
        if (householdId <= 0L) {
            this.getLogger().info("householdId=" + householdId);
            return null;
        }
        this.subscriberMngFacadeAPI.removeHousehold(this.clientId, householdId);
        return null;
    }

    public Object accountStateModify(AccountOrderEvent e, ServerContext ctx) throws Exception {
        if (e.getOldTvAccount() == null || Utils.isBlankString((String)e.getOldTvAccount().getDeviceAccountId())) {
            return this.accountModify(e, ctx);
        }
        long householdId = Utils.parseLong((String)e.getNewTvAccount().getDeviceAccountId());
        String tariffIdentifier = this.getTariffIdentifier(e, null);
        this.accountStateModify0(e, householdId, tariffIdentifier);
        for (AccountOrderEvent.AccountEntry child : e.getChildrenEntryList()) {
            this.terminalModify(householdId, child, ctx);
        }
        if (e.isOptionsModified()) {
            this.accountOptionsModify0(e, ctx, householdId, false);
        }
        return null;
    }

    private void accountStateModify0(AccountOrderEvent e, long householdId, String tariffIdentifier) throws Exception {
        if (e.getNewState() == 1 && Utils.notBlankString((String)tariffIdentifier)) {
            this.subscriberMngFacadeAPI.activateHousehold(this.clientId, householdId);
        } else {
            this.subscriberMngFacadeAPI.inactivateHousehold(this.clientId, householdId);
        }
    }

    public Object accountOptionsModify(AbstractOrderEvent e, ServerContext ctx) throws Exception {
        this.getLogger().debug("accountOptionsModify");
        long householdId = Utils.parseLong((String)e.getTvAccountRuntime().getTvAccount().getDeviceAccountId());
        return this.accountOptionsModify0(e, ctx, householdId, true);
    }

    private Object accountOptionsModify0(AbstractOrderEvent e, ServerContext ctx, long householdId, boolean tariffModify) throws Exception {
        this.getLogger().debug("accountOptionsModify0");
        if (tariffModify && e.getNewDeviceOptionIds() != null) {
            for (Integer productSpecId : e.getNewDeviceOptionIds()) {
                ProductSpecRuntime productSpecRuntime;
                ProductSpec productSpec;
                if (e.getOldDeviceOptionIds() != null && e.getOldDeviceOptionIds().contains(productSpecId) || !this.isTariff(productSpec = (productSpecRuntime = (ProductSpecRuntime)this.access.productSpecRuntimeMap.get(productSpecId)).getProductSpec())) continue;
                this.getLogger().info("Options modify: need change tariff to " + productSpec.getIdentifier() + " (" + productSpec.getTitle() + ")");
                if (this.tariffModify(householdId, productSpec.getIdentifier())) continue;
                this.getLogger().info("Reset options to " + String.valueOf(e.getOldDeviceOptionIds()));
                e.setNewDeviceOptionIds(e.getOldDeviceOptionIds());
            }
        }
        return null;
    }

    private void terminalModify(long householdId, AccountOrderEvent.AccountEntry entry, ServerContext ctx) throws Exception {
        this.getLogger().info("terminalModify");
        TvAccount tvAccount = entry.getNewTvAccount() != null ? entry.getNewTvAccount() : entry.getOldTvAccount();
        byte[] macAddress = tvAccount.getMacAddressListBytes();
        if (entry.getNewState() == -1 || macAddress == null || macAddress.length == 0) {
            if (macAddress == null || macAddress.length == 0) {
                this.getLogger().error("MAC-address is null for tvAccount:" + tvAccount.getId());
            }
            this.getLogger().info("deleteTerminal");
            long terminalId = Utils.parseLong((String)entry.getOldTvAccount().getDeviceAccountId());
            try {
                this.subscriberMngFacadeAPI.deleteTerminal(this.clientId, terminalId);
                entry.setDeviceAccountId("");
            }
            catch (InvalidParameterException_Exception ex) {
                this.getLogger().error("deleteTerminal: InvalidParameterException_Exception: " + ex.getMessage());
            }
            catch (Exception ex) {
                this.logError(ex);
            }
            return;
        }
        TvAccountSpecRuntime tvAccountSpecRuntime = (TvAccountSpecRuntime)this.access.tvAccountSpecRuntimeMap.get(tvAccount.getSpecId());
        long terminalTypeId = tvAccountSpecRuntime.config.getLong("terminal.typeId", 0L);
        long bandwidth = tvAccountSpecRuntime.config.getLong("terminal.bandwidth", 0L);
        if (entry.getOldTvAccount() == null || Utils.isBlankString((String)entry.getOldTvAccount().getDeviceAccountId())) {
            this.getLogger().info("addTerminal");
            try {
                long terminalId = this.subscriberMngFacadeAPI.addTerminal(this.clientId, householdId, terminalTypeId, Utils.bytesToString((byte[])macAddress, (boolean)true, (String)":"), bandwidth, tvAccount.getIdentifier(), "asd", this.regionId);
                entry.setDeviceAccountId(String.valueOf(terminalId));
            }
            catch (OperationFailedException_Exception ex) {
                this.getLogger().error("addTerminal: OperationFailedException_Exception: " + ex.getMessage());
            }
            catch (InvalidParameterException_Exception ex) {
                this.getLogger().error("addTerminal: InvalidParameterException_Exception: " + ex.getMessage());
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        } else {
            this.getLogger().info("updateTerminal");
            try {
                long terminalId = Utils.parseLong((String)entry.getOldTvAccount().getDeviceAccountId());
                this.subscriberMngFacadeAPI.updateTerminal(this.clientId, terminalId, terminalTypeId, Utils.bytesToString((byte[])macAddress, (boolean)true, (String)":"), bandwidth, tvAccount.getIdentifier(), "active", Utils.maskNull((String)tvAccount.getComment()), this.regionId);
            }
            catch (OperationFailedException_Exception ex) {
                this.getLogger().error("updateTerminal: OperationFailedException_Exception: " + ex.getMessage(), (Throwable)ex);
            }
            catch (InvalidParameterException_Exception ex) {
                if (Utils.maskNull((String)ex.getMessage()).contains("not found")) {
                    this.getLogger().info(ex.getMessage());
                    try {
                        long terminalId = this.subscriberMngFacadeAPI.addTerminal(this.clientId, householdId, terminalTypeId, Utils.bytesToString((byte[])macAddress, (boolean)true, (String)":"), bandwidth, tvAccount.getIdentifier(), "asd", this.regionId);
                        entry.setDeviceAccountId(String.valueOf(terminalId));
                    }
                    catch (OperationFailedException_Exception ex1) {
                        this.getLogger().error("updateTerminal/addTerminal: OperationFailedException_Exception: " + ex1.getMessage());
                    }
                    catch (Exception ex1) {
                        this.logError(ex1);
                    }
                } else {
                    this.getLogger().error("updateTerminal: OperationFailedException_Exception: " + ex.getMessage(), (Throwable)ex);
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    private Object productsModifySyncFull(long householdId, AbstractOrderEvent e, ServerContext ctx) throws Exception {
        this.getLogger().debug("productsModifyFullSync");
        HashSet<Long> servicesToAdd = new HashSet<Long>();
        boolean[] isTariffFromOptions = new boolean[]{false};
        String tariffIdentifier = this.getTariffIdentifier(e, isTariffFromOptions);
        if (this.serviceMode) {
            for (ServiceSpec serviceSpec : e.getFullServiceSpecSetToEnable()) {
                servicesToAdd.add(Utils.parseLong((String)serviceSpec.getIdentifier().trim()));
            }
        } else {
            for (ProductSpec productSpec : e.getFullProductSpecSetToEnable()) {
                this.getLogger().info("Product: " + String.valueOf(productSpec));
                if (this.isTariff(productSpec)) continue;
                servicesToAdd.add(Utils.parseLong((String)productSpec.getIdentifier().trim()));
            }
        }
        servicesToAdd.remove(0L);
        HashSet<Long> currentServiceIds = new HashSet<Long>();
        ServiceGroupArray serviceGroupArray = this.subscriberMngFacadeAPI.getServiceGroupsByHousehold(this.clientId, householdId);
        for (ServiceGroup serviceGroup : serviceGroupArray.getItem()) {
            ServiceArray serviceArray = this.subscriberMngFacadeAPI.getServicesInServiceGroupByHousehold(this.clientId, serviceGroup.getId(), householdId);
            for (ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.Service service : serviceArray.getItem()) {
                currentServiceIds.add(service.getId());
            }
        }
        this.getLogger().info("Current serviceIds: " + String.valueOf(currentServiceIds) + ", need serviceIds: " + String.valueOf(servicesToAdd));
        for (Long serviceId : currentServiceIds) {
            if (servicesToAdd.contains(serviceId)) continue;
            try {
                this.getLogger().debug("removeServiceFromHousehold: " + serviceId);
                this.subscriberMngFacadeAPI.removeServiceFromHousehold(this.clientId, serviceId, householdId);
            }
            catch (OperationFailedException_Exception ex) {
                this.getLogger().error("Can't remove service " + serviceId + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (Utils.notBlankString((String)tariffIdentifier) && !this.tariffModify(householdId, tariffIdentifier) && isTariffFromOptions[0]) {
            e.setNewDeviceOptionIds(e.getOldDeviceOptionIds());
        }
        for (Long serviceId : servicesToAdd) {
            if (currentServiceIds.contains(serviceId)) continue;
            try {
                this.getLogger().debug("addServiceToHousehold: " + serviceId);
                this.subscriberMngFacadeAPI.addServiceToHousehold(this.clientId, serviceId, householdId);
            }
            catch (OperationFailedException_Exception ex) {
                this.getLogger().error("Can't add service " + serviceId + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    public Object productsModify(ProductOrderEvent e, ServerContext ctx) throws Exception {
        this.getLogger().debug("productsModify");
        long householdId = Utils.parseLong((String)e.getTvAccount().getDeviceAccountId());
        if (e.isOptionsModified()) {
            this.accountOptionsModify0(e, ctx, householdId, true);
        }
        if (this.productSyncMode) {
            return this.productsModifySyncFull(householdId, e, ctx);
        }
        HashSet<Long> servicesToRemove = new HashSet<Long>();
        HashSet<Long> servicesToAdd = new HashSet<Long>();
        String tariffIdentifier = null;
        if (this.serviceMode) {
            for (ProductSpec productSpec : e.getProductSpecSetToRemove()) {
                if (!this.isTariff(productSpec)) continue;
                tariffIdentifier = this.tariffDefault;
            }
            for (ProductSpec productSpec : e.getProductSpecSetToAdd()) {
                if (!this.isTariff(productSpec)) continue;
                tariffIdentifier = productSpec.getIdentifier();
            }
            for (ServiceSpec serviceSpec : e.getServiceSpecSetToRemove()) {
                servicesToRemove.add(Utils.parseLong((String)serviceSpec.getIdentifier().trim()));
            }
            for (ServiceSpec serviceSpec : e.getServiceSpecSetToAdd()) {
                servicesToAdd.add(Utils.parseLong((String)serviceSpec.getIdentifier().trim()));
            }
        } else {
            for (ProductSpec productSpec : e.getProductSpecSetToRemove()) {
                if (!this.isTariff(productSpec)) {
                    servicesToRemove.add(Utils.parseLong((String)productSpec.getIdentifier().trim()));
                    continue;
                }
                if (!Utils.isBlankString(tariffIdentifier)) continue;
                tariffIdentifier = this.tariffDefault;
            }
            for (ProductSpec productSpec : e.getProductSpecSetToAdd()) {
                if (!this.isTariff(productSpec)) {
                    servicesToAdd.add(Utils.parseLong((String)productSpec.getIdentifier().trim()));
                    continue;
                }
                tariffIdentifier = productSpec.getIdentifier();
            }
        }
        servicesToRemove.remove(0L);
        servicesToAdd.remove(0L);
        for (Long serviceId : servicesToRemove) {
            try {
                this.getLogger().debug("removeServiceFromHousehold: " + serviceId);
                this.subscriberMngFacadeAPI.removeServiceFromHousehold(this.clientId, serviceId, householdId);
            }
            catch (OperationFailedException_Exception ex) {
                this.getLogger().error("Can't remove service " + serviceId + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (Utils.notBlankString((String)tariffIdentifier)) {
            this.tariffModify(householdId, tariffIdentifier);
        }
        for (Long serviceId : servicesToAdd) {
            try {
                this.getLogger().debug("addServiceToHousehold: " + serviceId);
                this.subscriberMngFacadeAPI.addServiceToHousehold(this.clientId, serviceId, householdId);
            }
            catch (OperationFailedException_Exception ex) {
                this.getLogger().error("Can't add service " + serviceId + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    private boolean tariffModify(long householdId, String tariffIdentifier) throws Exception {
        Household household;
        this.getLogger().debug("tariffModify");
        long tariffPlanId = Utils.parseLong((String)tariffIdentifier);
        Long householdTariffPlanId = (Long)this.householdTariffMap.get((Object)householdId);
        if (householdTariffPlanId == null) {
            household = this.subscriberMngFacadeAPI.getHousehold(this.clientId, householdId);
            if (tariffPlanId == household.getTariffPlanId()) {
                this.householdTariffMap.put((Object)householdId, (Object)household.getTariffPlanId(), TimeUnit.SECONDS.toMillis(30L));
                this.getLogger().info("Tariff plan already " + tariffPlanId);
                return true;
            }
        } else {
            if (tariffPlanId == householdTariffPlanId) {
                this.getLogger().info("Tariff plan already " + tariffPlanId + "(from cache)");
                return true;
            }
            household = this.subscriberMngFacadeAPI.getHousehold(this.clientId, householdId);
        }
        try {
            this.subscriberMngFacadeAPI.updateHousehold(this.clientId, householdId, household.getUsername(), household.getPassword(), household.getTypeId(), this.regionId, household.getContract(), household.getCompany(), household.getName(), household.getAddress(), this.lang, household.getPhoneNumber(), tariffPlanId, this.integrationMode);
            this.householdTariffMap.put((Object)householdId, (Object)tariffPlanId, TimeUnit.SECONDS.toMillis(30L));
            return true;
        }
        catch (OperationFailedException_Exception ex) {
            this.logError(ex);
            return true;
        }
    }

    private HandlerResolver newHandlerResolver(final Service webService) {
        return new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo portInfo) {
                ArrayList<Handler> result = new ArrayList<Handler>();
                result.add((Handler)new LoggingSOAPHandlerClient(webService));
                return result;
            }
        };
    }
}

