/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sqleditor.server.service;

import jakarta.jws.WebService;
import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.sqleditor.common.service.SqlEditorService;
import ru.bitel.bgbilling.plugins.sqleditor.server.mail.MailQueryResult;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Pair;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.sqleditor.common.service.SqlEditorService")
public class SqlEditorServiceImpl
extends AbstractService
implements SqlEditorService {
    public String templateList() throws BGException, BGMessageException {
        JSONArray templateList = new JSONArray();
        try (PreparedStatement ps = this.getConnection().prepareStatement("SELECT * FROM sql_template WHERE user_id=-1 OR user_id=? ORDER BY title asc");){
            ps.setInt(1, this.userId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                JSONObject queryInfo = new JSONObject();
                queryInfo.put("id", rs.getInt("id"));
                queryInfo.put("title", (Object)rs.getString("title"));
                queryInfo.put("query", (Object)rs.getString("text"));
                queryInfo.put("allSee", rs.getInt("user_id") == -1);
                templateList.put((Object)queryInfo);
            }
            rs.close();
        }
        catch (Exception e) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432: " + e.toString());
        }
        return templateList.toString();
    }

    public void templateUpdate(String sqlTemplateTitle, String query, boolean all) throws BGException, BGMessageException {
        int index;
        PreparedStatement ps;
        String queryInsert = "INSERT sql_template SET text=?, title=?, user_id=?";
        String queryUpdate = "UPDATE sql_template SET text=? WHERE title=? AND user_id=?";
        int updateRowsCount = 0;
        try {
            ps = this.getConnection().prepareStatement(queryUpdate);
            try {
                index = 1;
                ps.setString(index++, query);
                ps.setString(index++, sqlTemplateTitle);
                ps.setInt(index, all ? -1 : this.userId);
                updateRowsCount = ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430: " + e.toString());
        }
        if (updateRowsCount == 0) {
            try {
                ps = this.getConnection().prepareStatement(queryInsert);
                try {
                    index = 1;
                    ps.setString(index++, query);
                    ps.setString(index++, sqlTemplateTitle);
                    ps.setInt(index, all ? -1 : this.userId);
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception e) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430: " + e.toString());
            }
        }
    }

    public void templateDelete(int sqlTemplateId) throws BGException, BGMessageException {
        try (PreparedStatement ps = this.getConnection().prepareStatement("DELETE FROM sql_template WHERE id=?");){
            ps.setInt(1, sqlTemplateId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430: " + e.toString());
        }
    }

    public String databaseList() throws BGException, BGMessageException {
        JSONArray databases = new JSONArray();
        JSONObject mainDB = new JSONObject();
        mainDB.put("id", (Object)"main");
        mainDB.put("title", (Object)"\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f");
        databases.put((Object)mainDB);
        for (String id : Setup.getSetup().getSlaveBaseId()) {
            JSONObject slave = new JSONObject();
            slave.put("id", (Object)("slave@" + id));
            slave.put("title", (Object)("\u0420\u0435\u043f\u043b\u0438\u043a\u0430 [ " + id + " ]"));
            databases.put((Object)slave);
        }
        for (String id : Setup.getSetup().getTrashBaseId()) {
            JSONObject trash = new JSONObject();
            trash.put("id", (Object)("trash@" + id));
            trash.put("title", (Object)("\u041c\u0443\u0441\u043e\u0440\u043d\u0430\u044f [ " + id + " ]"));
            databases.put((Object)trash);
        }
        return databases.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doQuery(String databaseId, String query, Page page, String email) throws BGException {
        Connection con;
        Connection baseCon = con = this.getConnection();
        JSONObject resultTable = new JSONObject();
        try {
            if (Utils.isBlankString((String)query)) {
                String string = resultTable.toString();
                return string;
            }
            Object clientQuery = query.trim();
            String sqlQuery = ((String)clientQuery).trim().toLowerCase();
            Connection slaveOrTrashDBConnection = this.defineDBConnection(databaseId);
            if (slaveOrTrashDBConnection != null) {
                baseCon = slaveOrTrashDBConnection;
            }
            boolean pages = false;
            try {
                if (sqlQuery.startsWith("select")) {
                    clientQuery = ((String)clientQuery).replaceFirst("(?i)select", "SELECT SQL_CALC_FOUND_ROWS ");
                    if (!Pattern.compile("(?i)limit((,)?\\s*\\d+\\s*){1,2}").matcher((CharSequence)clientQuery).find()) {
                        pages = true;
                        if (page != null && page.getPageSize() > 0) {
                            clientQuery = (String)clientQuery + page.sqlLimit();
                        }
                    }
                }
                Statement statement = baseCon.createStatement();
                boolean haveResultSet = statement.execute((String)clientQuery);
                if (sqlQuery.startsWith("select") && page != null) {
                    try {
                        page.setRecordCount(ServerUtils.foundRows((Connection)baseCon));
                    }
                    catch (SQLException e) {
                        page.setRecordCount(50000);
                    }
                }
                if (haveResultSet) {
                    if (Utils.isBlankString((String)email)) {
                        int recordCount = this.putResultToResultTable(statement, resultTable);
                        if (page != null && page.getRecordCount() == 0) {
                            page.setRecordCount(recordCount);
                        }
                    } else {
                        this.sendResultToEmail(email, statement, (String)clientQuery);
                    }
                } else {
                    this.setSqlMessage(resultTable, "UpdateCount", String.valueOf(statement.getUpdateCount()));
                }
                statement.close();
                if (page != null && !pages) {
                    page.setPageCount(1);
                    page.setPageIndex(1);
                }
                if (page != null) {
                    resultTable.put("page", (Object)Page.toJson((Page)page));
                }
            }
            catch (SQLException ex) {
                this.setSqlMessage(resultTable, "Error", ex.getMessage());
            }
        }
        finally {
            if (baseCon != con) {
                ServerUtils.closeConnection((Connection)baseCon);
            }
        }
        return resultTable.toString();
    }

    private Connection defineDBConnection(String databaseId) throws BGIllegalArgumentException {
        Connection dbConnection = null;
        if (databaseId != null && !databaseId.equals("main")) {
            String[] databaseType = databaseId.split("@");
            if (databaseType.length < 2) {
                throw new BGIllegalArgumentException();
            }
            if (databaseType[0].equals("slave")) {
                dbConnection = Setup.getSetup().getSlaveConnectionFromPool(databaseType[1]);
            } else if (databaseType[0].equals("trash")) {
                dbConnection = Setup.getSetup().getTrashConnectionFromPool(databaseType[1]);
            } else {
                throw new BGIllegalArgumentException();
            }
        }
        return dbConnection;
    }

    private int putResultToResultTable(Statement statement, JSONObject resultTable) throws SQLException {
        ResultSet rs = statement.getResultSet();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        String[] columns = new String[columnCount];
        JSONArray array = new JSONArray();
        for (int i = 0; i < columnCount; ++i) {
            columns[i] = "c" + i;
            array.put((Object)meta.getColumnLabel(i + 1));
        }
        resultTable.put("columns", (Object)array);
        array = new JSONArray();
        int recordCount = 0;
        while (rs.next()) {
            JSONObject row = new JSONObject();
            for (int i = 0; i < columnCount; ++i) {
                row.put(columns[i], (Object)rs.getString(i + 1));
            }
            array.put((Object)row);
            ++recordCount;
        }
        rs.close();
        resultTable.put("rows", (Object)array);
        return recordCount;
    }

    private void sendResultToEmail(String email, Statement statement, String clientQuery) throws BGMessageException {
        try {
            int i;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(50000);
            String charset = "UTF-8";
            ResultSet rs = statement.getResultSet();
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            for (i = 0; i < columnCount; ++i) {
                baos.write(meta.getColumnLabel(i + 1).getBytes(charset));
                if (i >= columnCount - 1) continue;
                baos.write(";".getBytes(charset));
            }
            baos.write("\r\n\r\n".getBytes(charset));
            while (rs.next()) {
                for (i = 0; i < columnCount; ++i) {
                    if (rs.getString(i + 1) != null) {
                        baos.write(rs.getString(i + 1).getBytes(charset));
                    }
                    if (i >= columnCount - 1) continue;
                    baos.write(";".getBytes(charset));
                }
                baos.write("\r\n".getBytes(charset));
            }
            rs.close();
            MailData mailData = new MailQueryResult().setRecipients(email).setSubject("query result").addTextPart("text", clientQuery).addPart("file", "attachment", "text/csv", "sql" + System.currentTimeMillis() + ".csv", baos.toByteArray());
            new MailMsg((Preferences)Setup.getSetup()).sendMessage(mailData);
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438");
        }
    }

    private void setSqlMessage(JSONObject table, String columnName, String rowData) {
        JSONArray array = new JSONArray();
        array.put((Object)columnName);
        table.put("columns", (Object)array);
        JSONObject rowJson = new JSONObject();
        rowJson.put("c0", (Object)rowData);
        array = new JSONArray();
        array.put((Object)rowJson);
        table.put("rows", (Object)array);
    }

    public List<String> getTableNamesList() throws BGException {
        ArrayList<String> result = new ArrayList<String>();
        try (Statement st = this.getConnection().createStatement();
             ResultSet rs = st.executeQuery("show tables");){
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0442\u0430\u0431\u043b\u0438\u0446: " + e.toString());
        }
        return result;
    }

    public List<Pair<String, String>> getColumnsOfTable(String tableName) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        try (Statement statement = this.getConnection().createStatement();
             ResultSet rs = statement.executeQuery("select * from " + tableName + " LIMIT 1");){
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i < columnCount; ++i) {
                result.add((Pair<String, String>)new Pair((Object)metaData.getColumnTypeName(i), (Object)metaData.getColumnName(i)));
            }
        }
        catch (SQLException ex) {
            this.logError(ex);
            return result;
        }
        return result;
    }
}

