/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.task;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskParameter;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.bgbilling.modules.sorm.server.upload.SormProjectUpload;

public class SormPaymentUploadTask
extends TaskBase {
    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        List<SormProject> activeSormProjects = this.getActiveSormProjects();
        this.getLogger().info("\u0412\u0441\u0435\u0433\u043e \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0440\u043e\u0435\u043a\u0442\u043e\u0432 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: " + activeSormProjects.size());
        for (SormProject sormProject : activeSormProjects) {
            try {
                int uploadType;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0434\u043b\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u0421\u041e\u0420\u041c: " + sormProject.getTitle());
                }
                boolean isFullPaymentsUpload = (uploadType = this.taskSetup.getInt("typeUpload." + sormProject.getId(), 0)) == 1;
                SormProjectUpload.Builder uploadBuilder = SormProjectUpload.newUploadBuilder(this.getModuleId(), sormProject);
                if (isFullPaymentsUpload) {
                    uploadBuilder.fullUploadOnlyPayments();
                } else {
                    uploadBuilder.uploadOnlyPayments();
                }
                uploadBuilder.build().startUpload();
            }
            catch (BGException ex) {
                this.logError(ex);
            }
        }
    }

    private List<SormProject> getActiveSormProjects() {
        try {
            ServerContext serverContext = (ServerContext)ServerContext.get();
            return ((SormService)serverContext.getService(SormService.class, this.getModuleId())).getActiveSormProject();
        }
        catch (Exception ex) {
            this.logError(ex);
            return Collections.emptyList();
        }
    }

    public String getDescription() {
        return "\u0421\u041e\u0420\u041c. \u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432";
    }

    public List<TaskParameter> taskParameters() {
        return this.getActiveSormProjects().stream().map(sormProject -> new TaskParameter().setKey("typeUpload." + sormProject.getId()).setTitle("\u0422\u0438\u043f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438, 0-\u0438\u043d\u043a\u0440\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u0430\u044f(\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c), 1-\u043f\u043e\u043b\u043d\u0430\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430").setDefaultValue("0")).collect(Collectors.toList());
    }
}

