/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormUploadStatistic;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.SearchResult;

public class SormStatisticDao
extends AbstractIdDao<SormUploadStatistic> {
    private static final String SORM_UPLOAD_STATISTIC_TABLE = "sorm_upload_statistic";

    public SormStatisticDao(Connection con, int moduleId) {
        this(con, SORM_UPLOAD_STATISTIC_TABLE, moduleId);
    }

    private SormStatisticDao(Connection con, String tableName, int moduleId) {
        super(con, tableName, moduleId);
    }

    public void getList(SearchResult<SormUploadStatistic> searchResult) throws SQLException {
        List result = searchResult.getList();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + searchResult.optAttribute("where").map(a -> " WHERE " + a).orElse("") + " ORDER BY id DESC" + this.sqlLimit(searchResult.getPage());
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            int foundRows = ServerUtils.foundRows((Connection)this.con);
            searchResult.optPage().ifPresent(a -> a.setRecordCount(foundRows));
        }
    }

    public void getListByProject(SearchResult<SormUploadStatistic> searchResult, int sormProjectId) throws BGException {
        List result = searchResult.getList();
        String query = "SELECT * FROM " + this.tableName + " WHERE sormProjectId=" + sormProjectId;
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected SormUploadStatistic getFromRS(ResultSet rs) throws SQLException {
        SormUploadStatistic statistic = new SormUploadStatistic();
        statistic.setId(rs.getInt("id"));
        statistic.setSormProjectId(rs.getInt("sormProjectId"));
        statistic.setEndUploadTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("endUploadTime")));
        statistic.setContractUploadCount(rs.getInt("uploadContractCount"));
        statistic.setFirstUploadContractId(rs.getInt("firstUploadContractId"));
        statistic.setLastUploadContractId(rs.getInt("lastUploadContract"));
        statistic.setUploadToFtpStatus(rs.getInt("uploadFtpStatus") == 0);
        statistic.setFtpUploadErrorMessage(rs.getString("error_message"));
        statistic.setStartUploadTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("startUploadTime")));
        statistic.setUploadFilesInfo(rs.getString("files_info"));
        return statistic;
    }

    protected void updateImpl(SormUploadStatistic statistic) throws SQLException {
        String querySet = "sormProjectId=?, uploadContractCount=?, lastUploadContract=?, firstUploadContractId=?, uploadFtpStatus=?, endUploadTime=NOW(), error_message=?, startUploadTime=?, files_info=? ";
        try (PreparedStatement ps = this.prepareStatement((Id)statistic, querySet);){
            int index = 1;
            ps.setInt(index++, statistic.getSormProjectId());
            ps.setInt(index++, statistic.getContractUploadCount());
            ps.setInt(index++, statistic.getLastUploadContractId());
            ps.setInt(index++, statistic.getFirstUploadContractId());
            ps.setInt(index++, statistic.getUploadToFtpStatus() ? 0 : 1);
            ps.setString(index++, statistic.getFtpUploadErrorMessage());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)statistic.getStartUploadTime()));
            ps.setString(index, Utils.maskNull((String)statistic.getUploadFilesInfo()));
            this.executeUpdate((Id)statistic, index, ps);
        }
    }

    public void deleteStatisticForSormProject(int sormProjectId, Date dateFilter) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE sormProjectId=?";
        if (dateFilter != null) {
            query = query + " AND uploadDate<?";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, sormProjectId);
            if (dateFilter != null) {
                ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)dateFilter));
            }
            ps.executeUpdate();
        }
    }
}

