/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload.cdr.voice;

import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.voice.VoiceCDRUpload;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public abstract class VoiceCDRUploadCommon
implements VoiceCDRUpload {
    protected final SormProject sormProject;
    protected final Preferences config;
    protected String localUserPath;
    protected String regionId;
    private final JSONArray cdrNumberConverters;

    public VoiceCDRUploadCommon(SormProject sormProject, String cdrNumberConverters) throws BGException {
        this.sormProject = sormProject;
        this.config = sormProject.getLoadedConfig();
        this.cdrNumberConverters = new JSONArray(cdrNumberConverters);
        this.localUserPath = Utils.maskBlank((String)this.config.get("sorm.local.catalog"), (String)"");
        if (this.localUserPath.endsWith("/")) {
            this.localUserPath = this.localUserPath.substring(0, this.localUserPath.length() - 1);
        }
        this.regionId = this.config.get("sorm.upload.regionid", "1");
    }

    protected String getServiceId() {
        return this.config.get("sorm.upload.cdr.serviceId", "\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e");
    }

    protected boolean isOurNumber(String number) {
        long numA = Utils.parseLong((String)number);
        return SormUtils.getUploadVoiceNumberingResources(this.config, (ServerContext)ServerContext.get()).stream().anyMatch(n -> numA >= n.getFromNumber() && numA <= n.getToNumber());
    }

    @Override
    public void uploadCDR() {
        throw new UnsupportedOperationException();
    }

    protected String applyCallingNumberConverterRule(String number) {
        return this.toE164(number, true);
    }

    protected String applyCalledNumberConverterRule(String number) {
        return this.toE164(number, false);
    }

    private String toE164(String number, boolean calling) {
        String value = number;
        for (int i = 0; i < this.cdrNumberConverters.length(); ++i) {
            JSONObject converter = this.cdrNumberConverters.getJSONObject(i);
            String pattern = converter.optString("rule");
            String replacement = converter.optString("value");
            String applyTo = converter.optString("applyTo", "ALL");
            if (applyTo.equals("ALL")) {
                value = value.replaceAll(pattern, replacement);
                continue;
            }
            if (applyTo.equals("CALLING") && calling) {
                value = value.replaceAll(pattern, replacement);
                continue;
            }
            if (!applyTo.equals("CALLED") || calling) continue;
            value = value.replaceAll(pattern, replacement);
        }
        return value;
    }
}

