/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionHistory;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionStatus;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionSuspendReason;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class SubscriptionHistoryDao
extends AbstractDao<SoftLineSubscriptionHistory> {
    public SubscriptionHistoryDao(Connection con, int moduleId) {
        this(con, "softline_subscriptions_history", moduleId);
    }

    private SubscriptionHistoryDao(Connection con, String tableName, int moduleId) {
        super(con, tableName, moduleId);
    }

    protected SoftLineSubscriptionHistory getFromRS(ResultSet rs) throws SQLException {
        SoftLineSubscriptionHistory history = new SoftLineSubscriptionHistory();
        history.setSubscriptionId(rs.getInt("subscriptionID"));
        int status = rs.getInt("status");
        if (status == SoftLineSubscriptionStatus.SUSPEND.getCode()) {
            history.setSuspendReason(SoftLineSubscriptionSuspendReason.getReason((int)rs.getInt("suspendReason")));
        }
        history.setStatus(status);
        history.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("modifyDate")));
        history.setContractId(rs.getInt("contractId"));
        history.setProductId(rs.getInt("productId"));
        return history;
    }

    protected void updateImpl(SoftLineSubscriptionHistory history) throws SQLException {
        String query = "INSERT INTO " + this.tableName + " (subscriptionId, status, suspendReason, modifyDate, contractId, productId) VALUES (?,?,?,?,?,?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, history.getSubscriptionId());
            int status = history.getStatus();
            ps.setInt(index++, status);
            if (status == SoftLineSubscriptionStatus.SUSPEND.getCode()) {
                ps.setInt(index++, history.getSuspendReason().ordinal());
            } else {
                ps.setNull(index++, 4);
            }
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)history.getDate()));
            ps.setInt(index++, history.getContractId());
            ps.setInt(index, history.getProductId());
            ps.executeUpdate();
        }
    }

    public void searchHistory(SearchResult<SoftLineSubscriptionHistory> searchResult, int contractId, int subscriptionId, int productId) throws SQLException {
        if (searchResult != null) {
            StringBuilder query = new StringBuilder("SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE true");
            Page page = searchResult.getPage();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            if (contractId > 0) {
                query.append(" AND contractId=?");
            }
            if (subscriptionId > 0) {
                query.append(" AND subscriptionId=?");
            }
            if (productId > 0) {
                query.append(" AND productId=?");
            }
            if (period != null) {
                Date dateFrom = period.getDateFrom();
                Date dateTo = period.getDateTo();
                if (dateFrom != null && dateTo != null) {
                    query.append(" AND modifyDate BETWEEN ? AND ?");
                }
            }
            query.append(this.sqlLimit(page));
            try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
                int index = 1;
                if (contractId > 0) {
                    ps.setInt(index++, contractId);
                }
                if (subscriptionId > 0) {
                    ps.setInt(index++, subscriptionId);
                }
                if (productId > 0) {
                    ps.setInt(index++, productId);
                }
                if (period != null) {
                    Date dateFrom = period.getDateFrom();
                    Date dateTo = period.getDateTo();
                    if (dateFrom != null && dateTo != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)dateFrom));
                        ps.setTimestamp(index, TimeUtils.convertDateToTimestamp((Date)dateTo));
                    }
                }
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
                if (page != null) {
                    page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
                }
                rs.close();
            }
        }
    }

    public void deleteHistoryOfSubscription(int subscriptionId) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE subscriptionId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, subscriptionId);
            ps.executeUpdate();
        }
    }
}

