/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.bean;

import bitel.billing.server.contract.bean.ServiceCostCache;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractService;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractServiceInstallment;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractServiceInstallmentStatus;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMCalculatorUtils;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMTariffRequestResult;
import ru.bitel.bgbilling.modules.rscm.server.tariff.RscmTariffContext;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.sql.ConnectionSet;

public class RSCMContractServiceManager
extends AbstarctDaoConstant
implements AutoCloseable {
    private String tableNameAccount;
    private String tableNameInstallment;

    public RSCMContractServiceManager(Connection con, int moduleId) {
        super(con, "", moduleId);
        this.tableNameAccount = "rscm_service_account_" + moduleId;
        this.tableNameInstallment = "rscm_service_account_installment_" + moduleId;
        BGNestedContext.push((String)"rscm");
    }

    public String checkBalanceForService(int contractId, int serviceId, int amountUp, int amountDown, LocalDate localDate, BigDecimal costFromContract, ConnectionSet connectionSet) throws BGException {
        Object result = null;
        try (ContractDao contractDao = new ContractDao(connectionSet.getConnection(), 0);
             BalanceUtils bu = new BalanceUtils(connectionSet.getConnection());){
            Contract contract = (Contract)contractDao.get(contractId);
            BigDecimal limit = contract != null ? contract.getBalanceLimit() : BigDecimal.ZERO;
            int domainId = contract != null ? contract.getDomainId() : 0;
            RscmTariffContext rscmTariffContext = new RscmTariffContext(new Period(localDate, localDate), this.moduleId, connectionSet);
            RSCMTariffRequestResult rscmTariffRequestResult = RSCMCalculatorUtils.processTariffRequest(new ServiceCostCache(), domainId, contractId, serviceId, amountUp, amountUp, amountDown, false, localDate, costFromContract, rscmTariffContext, this.getLogger());
            if (rscmTariffRequestResult.accepted) {
                BigDecimal cost = rscmTariffRequestResult.cost;
                BigDecimal divisor = rscmTariffRequestResult.divisor;
                if (cost != null && divisor != null && divisor.longValue() > 0L) {
                    BigDecimal summa = cost.divide(divisor, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP).divide(new BigDecimal(amountDown), RoundingMode.DOWN).multiply(new BigDecimal(amountUp));
                    BigDecimal balance = bu.getBalance(localDate, contractId);
                    if (balance.subtract(limit).compareTo(summa) < 0) {
                        result = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u043f\u043b\u0430\u0442\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443\nsumma=" + String.valueOf(summa) + ", balance=" + String.valueOf(balance) + ", limit=" + String.valueOf(limit);
                    }
                }
            } else {
                result = "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0430\u0440\u0438\u0444 \u0438\u043b\u0438 \u0446\u0435\u043d\u0430 \u043d\u0430 \u0443\u0441\u043b\u0443\u0433\u0443 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443!";
            }
        }
        return result;
    }

    public void checkTariffsForService(int contractId, int serviceId, LocalDate localDate, ConnectionSet connectionSet) throws BGException {
        RscmTariffContext rscmTariffContext = new RscmTariffContext(new Period(localDate, localDate), this.moduleId, connectionSet);
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.con, Integer.valueOf(contractId));
        int domainId = contractRuntime != null ? contractRuntime.getDomainId() : 0;
        RSCMTariffRequestResult rscmTariffRequestResult = RSCMCalculatorUtils.processTariffRequest(new ServiceCostCache(), domainId, contractId, serviceId, 1, 1, 1, false, localDate, null, rscmTariffContext, this.getLogger());
        if (!rscmTariffRequestResult.accepted) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443! " + rscmTariffRequestResult.tariffRequestString);
        }
    }

    public List<RSCMContractService> getContractServiceList(int contractId, Calendar month) throws BGException {
        if (month == null) {
            month = new GregorianCalendar();
        }
        Period period = new Period();
        month.set(5, 1);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)month);
        period.setDateFrom(month.getTime());
        month.add(2, 1);
        month.add(14, -1);
        period.setDateTo(month.getTime());
        return this.getContractServiceList(contractId, period, new Page(1, 0), true);
    }

    public List<RSCMContractService> getContractServiceList(int contractId, Period period, Page page, boolean dateAscOrder) throws BGException {
        ArrayList<RSCMContractService> result = new ArrayList<RSCMContractService>();
        String query = "SELECT SQL_CALC_FOUND_ROWS rscm.*, service.title, rscm_service.unit FROM " + this.tableNameAccount + " AS rscm LEFT JOIN service ON service.id=rscm.sid LEFT JOIN rscm_service_" + this.moduleId + " AS rscm_service ON rscm.sid=rscm_service.sid WHERE rscm.cid=" + contractId + " AND rscm.date >= ? AND rscm.date < ?" + " ORDER BY rscm.date" + (dateAscOrder ? "" : " DESC") + (page != null && page.getPageSize() > 0 ? page.sqlLimit() : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            ps.setDate(2, TimeUtils.convertLocalDateToSqlDate((LocalDate)period.getLocalDateTo().plusDays(1L)));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getContractServiceFromRS(rs, true, true));
                }
            }
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    private RSCMContractService getContractServiceFromRS(ResultSet rs, boolean loadTitle, boolean loadUnit) throws SQLException {
        return RSCMContractService.builder().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setServiceId(rs.getInt("sid")).setInstallmentId(rs.getInt("installment_id")).setServiceTitle(loadTitle ? rs.getString("title") : null).setUnit(loadUnit ? rs.getString("unit") : null).setAmountUp(rs.getInt("amount_up")).setAmountDown(rs.getInt("amount_down")).setLast(rs.getInt("amount_last") > 0).setCost(rs.getBigDecimal("cost")).setComment(rs.getString("comment")).setDate(TimeUtils.convertDateToLocalDate((Date)rs.getDate("date"))).build();
    }

    public void updateContractService(RSCMContractService contractService) throws BGException {
        if (contractService == null) {
            return;
        }
        boolean update = contractService.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableNameAccount + " SET cid=?, sid=?, installment_id=?, date=?, amount_up=?, amount_down=?, amount_last=?, cost=?, comment=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int parameterIndex = 1;
            ps.setInt(parameterIndex++, contractService.getContractId());
            ps.setInt(parameterIndex++, contractService.getServiceId());
            ps.setInt(parameterIndex++, contractService.getInstallmentId());
            ps.setDate(parameterIndex++, TimeUtils.convertLocalDateToSqlDate((LocalDate)contractService.getDate()));
            ps.setInt(parameterIndex++, contractService.getAmountUp());
            ps.setInt(parameterIndex++, contractService.getAmountDown());
            ps.setInt(parameterIndex++, contractService.isLast() ? 1 : 0);
            ps.setBigDecimal(parameterIndex++, contractService.getCost());
            ps.setString(parameterIndex++, contractService.getComment());
            if (update) {
                ps.setInt(parameterIndex++, contractService.getId());
            }
            ps.executeUpdate();
            if (!update) {
                contractService.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteContractService(int id, int contractId, LocalDate month) throws SQLException {
        String query = "DELETE FROM " + this.tableNameAccount + " WHERE id=" + id + " AND cid=" + contractId;
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(query);
        }
    }

    public RSCMContractService getContractService(int contractId, int id) throws SQLException {
        RSCMContractService result = null;
        String query = "SELECT rscm.*, service.title, rscm_service.unit FROM " + this.tableNameAccount + " AS rscm LEFT JOIN service ON service.id=rscm.sid LEFT JOIN rscm_service_" + this.moduleId + " AS rscm_service ON rscm.sid=rscm_service.id WHERE rscm.id=? AND rscm.cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.setInt(2, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = this.getContractServiceFromRS(rs, true, true);
                }
            }
        }
        return result;
    }

    public void updateRSCMContractServiceInstallment(RSCMContractServiceInstallment rscmContractServiceInstallment) throws SQLException {
        if (rscmContractServiceInstallment == null) {
            return;
        }
        boolean insert = rscmContractServiceInstallment.getId() < 1;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableNameInstallment + " SET contract_id=?, service_id=?, status=?, date_from=?, date_next=?, amount_up=?, amount_down=?, payment_count=?, installment=?" + (insert ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int parameterIndex = 1;
            ps.setInt(parameterIndex++, rscmContractServiceInstallment.getContractId());
            ps.setInt(parameterIndex++, rscmContractServiceInstallment.getServiceId());
            ps.setInt(parameterIndex++, rscmContractServiceInstallment.getStatus().getCode());
            ps.setDate(parameterIndex++, TimeUtils.convertLocalDateToSqlDate((LocalDate)rscmContractServiceInstallment.getDateFrom()));
            ps.setDate(parameterIndex++, TimeUtils.convertLocalDateToSqlDate((LocalDate)rscmContractServiceInstallment.getDateNext()));
            ps.setInt(parameterIndex++, rscmContractServiceInstallment.getAmountUp());
            ps.setInt(parameterIndex++, rscmContractServiceInstallment.getAmountDown());
            ps.setInt(parameterIndex++, rscmContractServiceInstallment.getPaymentCount());
            ps.setString(parameterIndex++, rscmContractServiceInstallment.getInstallment());
            if (!insert) {
                ps.setInt(parameterIndex++, rscmContractServiceInstallment.getId());
            }
            ps.executeUpdate();
            if (insert) {
                rscmContractServiceInstallment.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public void hotCalc(int contractId, LocalDate date, ConnectionSet connectionSet) throws BGException, BGMessageException {
        LocalDate now;
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        boolean hotCalc = moduleSetup.getBoolean("hot.calc", false);
        boolean notCalculateFutureServices = moduleSetup.getBoolean("not.calculate.future.services", false);
        this.getLogger().debug("hot.calc={}; not.calculate.future.services={};", (Object)hotCalc, (Object)notCalculateFutureServices);
        if (!hotCalc) {
            return;
        }
        LocalDate dateStart = date.withDayOfMonth(1);
        LocalDate dateEnd = dateStart.plusMonths(1L);
        if (notCalculateFutureServices && (now = LocalDate.now()).isBefore(dateEnd)) {
            dateEnd = now;
            dateEnd = dateEnd.plusDays(1L);
        }
        try {
            RscmTariffContext rscmTariffContext = new RscmTariffContext(new Period(dateStart, dateEnd), this.moduleId, connectionSet);
            RSCMCalculatorUtils.doCalc(rscmTariffContext, Arrays.asList(contractId), null, this.getLogger());
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void searchContractServiceInstallment(SearchResult<RSCMContractServiceInstallment> searchResult, int contractId, int status, Page page) throws SQLException {
        if (searchResult == null) {
            return;
        }
        List list = searchResult.getList();
        String query = "SELECT * FROM " + this.tableNameInstallment + " WHERE contract_id=" + contractId + (String)(status > -1 ? " AND status=" + status : "") + (page != null && page.getPageSize() > 0 ? page.sqlLimit() : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                list.add(this.getContractServiceInstallmentFromRS(rs));
            }
        }
    }

    public RSCMContractService getContractServiceByInstallmentId(int installmentId, int contractId, LocalDate month) throws SQLException {
        RSCMContractService contractService = null;
        String query = "SELECT * FROM " + this.tableNameAccount + " AS rscm LEFT JOIN service ON service.id=rscm.sid WHERE cid=? AND installment_id=? AND date>=? AND date<=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int paramIndex = 1;
            ps.setInt(paramIndex++, contractId);
            ps.setInt(paramIndex++, installmentId);
            ps.setDate(paramIndex++, TimeUtils.convertLocalDateToSqlDate((LocalDate)month.withDayOfMonth(1)));
            ps.setDate(paramIndex++, TimeUtils.convertLocalDateToSqlDate((LocalDate)month.withDayOfMonth(month.lengthOfMonth())));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    contractService = this.getContractServiceFromRS(rs, true, false);
                }
            }
        }
        return contractService;
    }

    public List<RSCMContractServiceInstallment> getContractServiceInstallmentList() throws SQLException {
        ArrayList<RSCMContractServiceInstallment> list = new ArrayList<RSCMContractServiceInstallment>();
        String query = "SELECT * FROM " + this.tableNameInstallment;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                list.add(this.getContractServiceInstallmentFromRS(rs));
            }
        }
        return list;
    }

    public RSCMContractServiceInstallment getContractServiceInstallment(int id) throws BGException, BGMessageException {
        RSCMContractServiceInstallment installment = null;
        String query = "SELECT * FROM " + this.tableNameInstallment + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    installment = this.getContractServiceInstallmentFromRS(rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return installment;
    }

    public RSCMContractServiceInstallment deleteContractServiceInstallment(int id) throws SQLException {
        RSCMContractServiceInstallment installment = null;
        String query = "DELETE FROM " + this.tableNameInstallment + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        return installment;
    }

    @Override
    public void close() throws Exception {
        BGNestedContext.pop();
    }

    private RSCMContractServiceInstallment getContractServiceInstallmentFromRS(ResultSet rs) throws SQLException {
        return RSCMContractServiceInstallment.builder().setId(rs.getInt("id")).setContractId(rs.getInt("contract_id")).setServiceId(rs.getInt("service_id")).setStatus(RSCMContractServiceInstallmentStatus.getRSCMContractServiceInstallmentStatusByCode((int)rs.getInt("status"))).setDateFrom(TimeUtils.convertDateToLocalDate((Date)rs.getDate("date_from"))).setDateNext(TimeUtils.convertDateToLocalDate((Date)rs.getDate("date_next"))).setAmountUp(rs.getInt("amount_up")).setAmountDown(rs.getInt("amount_down")).setPaymentCount(rs.getInt("payment_count")).setInstallment(rs.getString("installment")).build();
    }
}

