/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.datasource;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.commons.beanutils.ConvertUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public final class BGXmlDataSource
implements JRRewindableDataSource {
    private Map<String, Field> fieldMap = new HashMap<String, Field>();
    private final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private Node contextNode;
    private String selectExpression;
    private NodeList nodeList;
    private int lastNode;
    private Node currentNode;
    private Element currentElement;
    private int currentNodeIndex = -1;
    private XPathFactory xPathFactory = null;
    private Map<String, XPathExpression> xPathCache = new HashMap<String, XPathExpression>();

    public BGXmlDataSource(Node contextNode) throws JRException {
        this(contextNode, null, (JasperReport)null);
    }

    public BGXmlDataSource(Node contextNode, String selectExpression) throws JRException {
        this(contextNode, selectExpression, (JasperReport)null);
    }

    public BGXmlDataSource(Node contextNode, String selectExpression, JasperReport report) throws JRException {
        this.contextNode = contextNode;
        this.selectExpression = selectExpression;
        this.moveFirst();
    }

    public BGXmlDataSource(Node contextNode, String selectExpression, JRField[] fields) throws JRException {
        this.contextNode = contextNode;
        this.selectExpression = selectExpression;
        this.moveFirst();
    }

    public void moveFirst() throws JRException {
        if (this.contextNode == null) {
            throw new JRException("document cannot be not null");
        }
        try {
            this.currentNode = null;
            this.currentElement = null;
            this.currentNodeIndex = -1;
            this.nodeList = this.selectExpression != null ? (NodeList)this.getXPathExpression(this.selectExpression).evaluate(this.contextNode, XPathConstants.NODESET) : this.contextNode.getChildNodes();
            this.lastNode = this.nodeList.getLength() - 1;
        }
        catch (XPathException e) {
            this.lastNode = -1;
            throw new JRException("XPath selection failed. Expression: " + this.selectExpression, (Throwable)e);
        }
    }

    public boolean next() throws JRException {
        if (this.currentNodeIndex >= this.lastNode) {
            return false;
        }
        this.currentNode = this.nodeList.item(++this.currentNodeIndex);
        if (this.currentNode.getNodeType() == 1) {
            this.currentElement = (Element)this.currentNode;
        }
        return true;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        if (this.currentNode == null) {
            return null;
        }
        Field f = this.fieldMap.get(jrField.getName());
        if (f == null) {
            f = this.newField(jrField);
            this.fieldMap.put(jrField.getName(), f);
        }
        return f.getValue(this.currentElement);
    }

    private Field newField(JRField f) {
        boolean fromName;
        Field result = null;
        String desc = f.getDescription();
        final Class clazz = f.getValueClass();
        boolean bl = fromName = desc == null || desc.length() == 0;
        if (fromName) {
            String expression = f.getName();
            if (clazz.equals(String.class)) {
                result = new Field(this, expression){

                    @Override
                    public Object getValue(String val) throws JRException {
                        return val;
                    }
                };
            }
            result = clazz.equals(BigDecimal.class) ? new Field(this, expression){

                @Override
                public BigDecimal getValue(String text) throws JRException {
                    return Utils.parseBigDecimal((String)text, (BigDecimal)BigDecimal.ZERO);
                }
            } : (clazz.equals(Integer.class) ? new Field(this, expression){

                @Override
                public Object getValue(String text) throws JRException {
                    return Utils.parseInt((String)text);
                }
            } : (clazz.equals(Long.class) ? new Field(this, expression){

                @Override
                public Object getValue(String text) throws JRException {
                    return Utils.parseLong((String)text);
                }
            } : (clazz.equals(Float.class) ? new Field(this, expression){

                @Override
                public Object getValue(String text) throws JRException {
                    return Float.valueOf(Utils.parseFloat((String)text, (float)0.0f));
                }
            } : (clazz.equals(Double.class) ? new Field(this, expression){

                @Override
                public Object getValue(String text) throws JRException {
                    return Float.valueOf(Utils.parseFloat((String)text, (float)0.0f));
                }
            } : (clazz.equals(Date.class) ? new Field(expression){

                @Override
                public Object getValue(String text) throws JRException {
                    return TimeUtils.parseDate((String)text, (DateFormat)BGXmlDataSource.this.dateFormat);
                }
            } : (clazz.equals(Calendar.class) ? new Field(expression){

                @Override
                public Object getValue(String text) throws JRException {
                    return TimeUtils.parseCalendar((String)text, (DateFormat)BGXmlDataSource.this.dateFormat);
                }
            } : new Field(this, expression){

                @Override
                public Object getValue(String text) throws JRException {
                    return ConvertUtils.convert((String)text.trim(), (Class)clazz);
                }
            }))))));
        } else {
            String expression = desc;
            if (clazz.equals(String.class)) {
                result = new ExpressionField(this, expression){

                    @Override
                    public Object getValue(String val) throws JRException {
                        return val;
                    }
                };
            }
            result = clazz.equals(BigDecimal.class) ? new ExpressionField(this, expression){

                @Override
                public BigDecimal getValue(String text) throws JRException {
                    return Utils.parseBigDecimal((String)text, (BigDecimal)BigDecimal.ZERO);
                }
            } : (clazz.equals(Integer.class) ? new ExpressionField(this, expression){

                @Override
                public Object getValue(String text) throws JRException {
                    return Utils.parseInt((String)text);
                }
            } : (clazz.equals(Long.class) ? new ExpressionField(this, expression){

                @Override
                public Object getValue(String text) throws JRException {
                    return Utils.parseLong((String)text);
                }
            } : (clazz.equals(Float.class) ? new ExpressionField(this, expression){

                @Override
                public Object getValue(String text) throws JRException {
                    return Float.valueOf(Utils.parseFloat((String)text, (float)0.0f));
                }
            } : (clazz.equals(Double.class) ? new ExpressionField(this, expression){

                @Override
                public Object getValue(String text) throws JRException {
                    return Float.valueOf(Utils.parseFloat((String)text, (float)0.0f));
                }
            } : (clazz.equals(Date.class) ? new ExpressionField(expression){

                @Override
                public Object getValue(String text) throws JRException {
                    return TimeUtils.parseDate((String)text, (DateFormat)BGXmlDataSource.this.dateFormat);
                }
            } : (clazz.equals(Calendar.class) ? new ExpressionField(expression){

                @Override
                public Object getValue(String text) throws JRException {
                    return TimeUtils.parseCalendar((String)text, (DateFormat)BGXmlDataSource.this.dateFormat);
                }
            } : new ExpressionField(this, expression){

                @Override
                public Object getValue(String text) throws JRException {
                    return ConvertUtils.convert((String)text.trim(), (Class)clazz);
                }
            }))))));
        }
        return result;
    }

    public String getText(Node node) {
        if (!node.hasChildNodes()) {
            return node.getNodeValue();
        }
        StringBuilder result = new StringBuilder();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String value;
            Node subnode = list.item(i);
            if (subnode.getNodeType() == 3) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() == 4) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() != 5 || (value = this.getText(subnode)) == null) continue;
            result.append(value);
        }
        return result.toString();
    }

    protected final String select(Node node, String expression) {
        try {
            Node result = (Node)this.getXPathExpression(expression).evaluate(node, XPathConstants.NODE);
            return result != null ? result.getNodeValue() : "";
        }
        catch (XPathException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String select(String expression) {
        return this.select(this.contextNode, expression);
    }

    public String selectOnCurrent(String expression) {
        return this.select(this.currentNode, expression);
    }

    public Object selectObject(String expression, Class<?> clazz) {
        return this.convert(this.select(expression), clazz);
    }

    public Object selectObjectOnCurrent(String expression, Class<?> clazz) {
        return this.convert(this.selectOnCurrent(expression), clazz);
    }

    protected final Object convert(String text, Class<?> clazz) {
        if (clazz == String.class || clazz == Object.class) {
            return text;
        }
        if (clazz == Float.class) {
            return Float.valueOf(Utils.parseFloat((String)text, (float)0.0f));
        }
        if (clazz == Double.class) {
            return Utils.parseDouble((String)text, (double)0.0);
        }
        if (clazz == Date.class) {
            return TimeUtils.parseDate((String)text, (DateFormat)this.dateFormat);
        }
        if (clazz == Calendar.class) {
            return TimeUtils.parseCalendar((String)text, (DateFormat)this.dateFormat);
        }
        if (clazz == Integer.class) {
            return Utils.parseInt((String)text);
        }
        return ConvertUtils.convert((String)text.trim(), clazz);
    }

    private XPathFactory getXPathFactory() {
        if (this.xPathFactory == null) {
            this.xPathFactory = XPathFactory.newInstance();
        }
        return this.xPathFactory;
    }

    private XPathExpression getXPathExpression(String expression) throws XPathException {
        XPathExpression xPathExpression = this.xPathCache.get(expression);
        if (xPathExpression == null) {
            xPathExpression = this.getXPathFactory().newXPath().compile(expression);
            this.xPathCache.put(expression, xPathExpression);
        }
        return xPathExpression;
    }

    private abstract class Field {
        protected final String expression;

        protected Field(BGXmlDataSource bGXmlDataSource, String expression) {
            this.expression = expression;
        }

        public Object getValue(Element currentElement) throws JRException {
            return this.getValue(currentElement.getAttribute(this.expression));
        }

        public abstract Object getValue(String var1) throws JRException;
    }

    private abstract class ExpressionField
    extends Field {
        protected ExpressionField(String expression) {
            super(BGXmlDataSource.this, expression);
        }

        @Override
        public Object getValue(Element currentElement) throws JRException {
            Node node = null;
            try {
                node = (Node)BGXmlDataSource.this.getXPathExpression(this.expression).evaluate(BGXmlDataSource.this.currentNode, XPathConstants.NODE);
            }
            catch (XPathException e) {
                throw new JRException("XPath selection failed. Expression: " + this.expression, (Throwable)e);
            }
            if (node != null) {
                return this.getValue(BGXmlDataSource.this.getText(node));
            }
            return this.getValue("");
        }
    }
}

