/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.qiwi.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.qiwi.common.bean.Transaction;
import ru.bitel.bgbilling.modules.qiwi.common.bean.TransactionStatusRest;
import ru.bitel.bgbilling.modules.qiwi.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.SerialUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.io.Base64;

@WebServlet(name="QiwiApi", urlPatterns={"/qiwiexecuter/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final String ERROR_DB = "error.db";
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(ModuleExecutor.class);
    private static final String ERROR_CONFIG_AUTH_MISSING = "config.auth.missing";
    private static final String ERROR_PASSWORD = "incorrect.login.password";
    private static final String ERROR_SIGN = "incorrect.sign";
    private static final String ERROR_INCORRECT_REQUEST = "incorrect.request";
    private static final String REST_PREFIX = "/rest/";
    private static final Pattern midPattern = Pattern.compile("(\\d+)");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (Utils.notBlankString((String)pathInfo)) {
            this.getLogger().debug("pathInfo: {}", (Object)pathInfo);
            if (pathInfo.startsWith(REST_PREFIX)) {
                ResultCode resultCode = null;
                Setup setup = Setup.getSetup();
                try {
                    try (Connection con = setup.getDBConnectionFromPool();){
                        Transaction transaction;
                        int moduleId = 0;
                        Object matcher = midPattern.matcher(pathInfo);
                        if (((Matcher)matcher).find()) {
                            moduleId = Utils.parseInt((String)((Matcher)matcher).group());
                        }
                        if (moduleId <= 0) {
                            throw new BGException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d mid \u0432 url!", ERROR_INCORRECT_REQUEST);
                        }
                        this.printRequestParameters(req);
                        ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(moduleId));
                        this.authorize(req, moduleSetup);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0438\u0437 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                        }
                        String transactionId = req.getParameter("bill_id");
                        String transactionStatus = req.getParameter("status");
                        String amount = req.getParameter("amount");
                        if (Utils.isBlankString((String)transactionId) || Utils.isBlankString((String)transactionStatus) || Utils.isBlankString((String)amount)) {
                            throw new BGException("\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u043e\u0434\u0438\u043d \u0438\u0437 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 ( bill_id,status,amount)", ERROR_INCORRECT_REQUEST);
                        }
                        TransactionManager manager = new TransactionManager(con, moduleId);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("\u041f\u043e\u0438\u0441\u043a \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0441 \u043a\u043e\u0434\u043e\u043c " + transactionId);
                        }
                        if ((transaction = manager.getTransaction(Utils.parseInt((String)transactionId))) != null) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("\u041d\u0430\u0439\u0434\u0435\u043d\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u0441 \u043a\u043e\u0434\u043e\u043c " + transactionId + " (\u0441\u0442\u0430\u0442\u0443\u0441: " + transaction.getStatus() + "; \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + transaction.getContractId() + ")");
                            }
                            if (!transaction.getStatus().equals(transactionStatus)) {
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("\u0421\u0442\u0430\u0442\u0443\u0441 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0432 \u0411\u0414. \u041e\u0431\u043d\u043e\u0432\u043b\u044f\u0435\u043c.");
                                }
                                transaction.setStatus(transactionStatus);
                                manager.update(transaction);
                                if (TransactionStatusRest.PAID.getCode().equals(transactionStatus)) {
                                    if (this.getLogger().isDebugEnabled()) {
                                        this.getLogger().debug("\u0424\u0438\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438. \u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u043f\u043b\u0430\u0442\u0435\u0436");
                                    }
                                    try (BalanceUtils bu = new BalanceUtils(con);){
                                        Payment payment = new Payment().setDate(transaction.getPaymentDate()).setTypeId(moduleSetup.getInt("qiwi.payment.type.id", -1)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(moduleSetup.get("qiwi.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441 QIWI [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", transactionId));
                                        new PaymentDao(con).update((Object)payment);
                                        ServerUtils.commitConnection((Connection)con);
                                        bu.updateBalance(transaction.getPaymentDate(), transaction.getContractId());
                                        EventProcessor.getInstance().publishAfterCommit((Event)new PaymentEvent(0, payment));
                                        EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                                    }
                                }
                            }
                        }
                        resultCode = ResultCode.SUCCESS;
                    }
                    catch (Exception ex) {
                        throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 \u0411\u0414: " + ex.getMessage(), ERROR_DB);
                    }
                }
                catch (BGException ex) {
                    int status = -1;
                    switch (ex.getTag()) {
                        case "error.db": {
                            resultCode = ResultCode.DB_ERROR;
                            status = 500;
                            break;
                        }
                        case "incorrect.request": {
                            resultCode = ResultCode.REQUEST_FORMAT;
                            status = 400;
                            break;
                        }
                        case "incorrect.login.password": {
                            resultCode = ResultCode.INCORRECT_PASSWORD;
                            status = 401;
                            break;
                        }
                        case "incorrect.sign": {
                            resultCode = ResultCode.INCORRECT_SIGN;
                            status = 401;
                            break;
                        }
                        case "config.auth.missing": {
                            resultCode = ResultCode.SERVER_LINK_ERROR;
                            status = 500;
                        }
                    }
                    resp.sendError(status, ex.getMessage());
                    this.getLogger().error(ex.getMessage(), (Throwable)ex);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\u0424\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u0430");
                }
                try (ServletOutputStream sout = resp.getOutputStream();){
                    Document answerDocument = XMLUtils.newDocument();
                    Element rootElement = XMLUtils.createElement((Document)answerDocument, (String)"result");
                    answerDocument.appendChild(rootElement);
                    Element resultCodeElement = XMLUtils.createElement((Element)rootElement, (String)"result_code");
                    resultCodeElement.setTextContent(resultCode.getCode());
                    resp.setContentType("text/xml");
                    resp.setStatus(200);
                    XMLUtils.serialize((Node)answerDocument, (OutputStream)sout, (String)"UTF-8");
                    sout.flush();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442: " + XMLUtils.serializeToString((Node)answerDocument, (boolean)false));
                    }
                }
                catch (Exception ex) {
                    this.getLogger().error("error serialize xml", (Throwable)ex);
                }
            }
            return;
        }
    }

    private void authorize(HttpServletRequest req, ModuleSetup moduleSetup) throws BGException {
        String incomeSign;
        String authorization;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
        if (Utils.notBlankString((String)(authorization = req.getHeader("Authorization"))) && authorization.startsWith("Basic")) {
            String[] userPassword;
            String unencoded;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\t\u041f\u0440\u043e\u0431\u0443\u0435\u043c Basic-\u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044e...");
            }
            if ((unencoded = Base64.decodeUTF8((String)(authorization = authorization.substring(6).trim()))).contains(":") && (userPassword = unencoded.split(":")).length == 2) {
                String requestUsername = userPassword[0];
                String requestPassword = userPassword[1];
                String moduleUsername = moduleSetup.get("qiwi.shop.id", null);
                String modulePassword = moduleSetup.get("qiwi.notification.password", null);
                if (Utils.isBlankString((String)moduleUsername) || Utils.isBlankString((String)modulePassword)) {
                    throw new BGException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439!", ERROR_CONFIG_AUTH_MISSING);
                }
                if (Utils.isBlankString((String)requestUsername) || !requestUsername.equals(moduleUsername) || Utils.isBlankString((String)requestPassword) || !requestPassword.equals(modulePassword)) {
                    throw new BGException("\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u043f\u0430\u0440\u0430 \u043b\u043e\u0433\u0438\u043d/\u043f\u0430\u0440\u043e\u043b\u044c", ERROR_PASSWORD);
                }
            }
        }
        if (Utils.notBlankString((String)(incomeSign = req.getHeader("X-Api-Signature")))) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\t\u041f\u0440\u043e\u0431\u0443\u0435\u043c \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443 \u043f\u043e\u0434\u043f\u0438\u0441\u0438...");
            }
            Map incomeParameterMap = req.getParameterMap();
            List sortedKeyList = incomeParameterMap.entrySet().stream().map(x -> (String)x.getKey()).collect(Collectors.toList());
            Collections.sort(sortedKeyList);
            String str2Sign = sortedKeyList.stream().map(x -> ((String[])incomeParameterMap.get(x))[0]).collect(Collectors.joining("|"));
            try {
                SecretKeySpec signingKey = new SecretKeySpec(moduleSetup.get("qiwi.notification.password").getBytes("UTF-8"), "HmacSHA1");
                Mac mac = Mac.getInstance("HmacSHA1");
                mac.init(signingKey);
                byte[] rawHmac = mac.doFinal(str2Sign.getBytes("UTF-8"));
                String calculatedSign = Base64.encode((byte[])rawHmac).toString();
                if (!incomeSign.equals(calculatedSign)) {
                    throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u0438", ERROR_SIGN);
                }
            }
            catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u0432\u0435\u0440\u043a\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0435\u0439: " + e.getMessage());
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\t\u0423\u0441\u043f\u0435\u0445!");
        }
    }

    private void printRequestParameters(HttpServletRequest request) {
        Object message = "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: ";
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            message = (String)message + (String)entry.getKey() + "=" + Arrays.toString((Object[])entry.getValue()) + "; ";
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((String)message);
        }
    }

    private static enum ResultCode {
        SUCCESS("0"),
        REQUEST_FORMAT("5"),
        DB_ERROR("13"),
        INCORRECT_PASSWORD("150"),
        INCORRECT_SIGN("151"),
        SERVER_LINK_ERROR("300");

        private String code;

        private ResultCode(String c) {
            this.code = c;
        }

        public String getCode() {
            return this.code;
        }
    }
}

