/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paykeeper.server.action.web;

import bitel.billing.server.ActionResultContentType;
import java.io.IOException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.modules.paykeeper.common.bean.Transaction;
import ru.bitel.bgbilling.modules.paykeeper.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.paykeeper.server.bean.Constants;
import ru.bitel.bgbilling.modules.paykeeper.server.bean.TransactionManager;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Paykeeper")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("paykeeper");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.setResultParam("gateUrl", this.moduleSetup.get("paykeeper.gate.url"));
        this.paymentForm(this.moduleName, Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"createDatetime:1"});
        new TransactionManager(this.con, this.moduleId).searchTransaction((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    public void success() throws Exception {
        this.execute();
    }

    public void fail() throws Exception {
        this.execute();
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        Transaction transaction = new Transaction().setContractId(this.contractId).setSum(this.sum).setCreateDate(new Date());
        new TransactionManager(this.con, this.moduleId).update(transaction);
        this.setResultParam("gateUrl", this.moduleSetup.get("paykeeper.gate.url"));
        this.setResultParam("formFields", new String[]{"clientid", "sum", "orderid", "phone"});
        this.setResultParam("clientid", this.contractId);
        this.setResultParam("orderid", transaction.getId());
        this.setResultParam("sum", this.sum);
        this.setResultParam("phone", this.customerAddress);
    }

    protected void doRedirect() throws Exception {
        Object formUrl = this.getResultParam("formUrl");
        if (formUrl != null) {
            try {
                this.setResultParam("contentType", ActionResultContentType.binary);
                this.context.getResponse().sendRedirect(String.valueOf(formUrl));
                return;
            }
            catch (IOException ex) {
                this.execute();
                throw new BGMessageException(ex.getMessage());
            }
        }
        this.execute();
        throw new BGMessageException(String.valueOf(this.getResultParam("errorMessage")) + " [errorCode=" + String.valueOf(this.getResultParam("errorCode")) + "]");
    }
}

