/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.packer.server.service;

import jakarta.jws.WebService;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.packer.common.bean.PackerKit;
import ru.bitel.bgbilling.plugins.packer.common.bean.PackerOptionLibrary;
import ru.bitel.bgbilling.plugins.packer.common.service.PackerService;
import ru.bitel.bgbilling.plugins.packer.server.bean.PackerKitDao;
import ru.bitel.bgbilling.plugins.packer.server.bean.PackerOptionLibraryDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.packer.common.service.PackerService")
public class PackerServiceImpl
extends AbstractService
implements PackerService {
    public List<PackerKit> packerKitList() throws BGException {
        try (PackerKitDao packerKitDao = new PackerKitDao(this.getConnection());){
            List<PackerKit> list = packerKitDao.list();
            return list;
        }
    }

    public PackerKit packerKitGet(int packerKitId) throws BGException {
        try (PackerKitDao packerKitDao = new PackerKitDao(this.getConnection());){
            PackerKit packerKit = (PackerKit)packerKitDao.get(packerKitId);
            return packerKit;
        }
    }

    public int packerKitUpdate(PackerKit packerKit) throws BGException {
        int n;
        PackerKitDao packerKitDao = new PackerKitDao(this.getConnection());
        try {
            packerKitDao.update(packerKit);
            n = packerKit.getId();
        }
        catch (Throwable throwable) {
            try {
                try {
                    packerKitDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        packerKitDao.close();
        return n;
    }

    public int packerKitDelete(int packerKitId) throws BGException, BGMessageException {
        int n;
        PackerKitDao packerKitDao = new PackerKitDao(this.getConnection());
        try {
            n = packerKitDao.delete(packerKitId);
        }
        catch (Throwable throwable) {
            try {
                try {
                    packerKitDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        packerKitDao.close();
        return n;
    }

    public SearchResult<PackerOptionLibrary> searchPackerOptionLibraryList(String title, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        new PackerOptionLibraryDao(this.getConnection()).searchPackerOptionLibraryList((SearchResult<PackerOptionLibrary>)searchResult, title);
        return searchResult;
    }

    public void packerOptionLibraryUpdate(PackerOptionLibrary packerOptionLibrary) throws Exception {
        new PackerOptionLibraryDao(this.getConnection()).update(packerOptionLibrary);
    }

    public void packerOptionLibraryDelete(int packerOptionLibraryId) throws Exception {
        new PackerOptionLibraryDao(this.getConnection()).delete(packerOptionLibraryId);
    }
}

