/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mtsbank.server.service;

import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.mtsbank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mtsbank.common.service.MTSBankService;
import ru.bitel.bgbilling.modules.mtsbank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.mtsbank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.mtsbank.server.event.MTSbankAutopaymentEvent;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.mtsbank.common.service.MTSBankService")
public class MTSBankServiceImpl
extends AbstractService
implements MTSBankService {
    private TransactionManager getTransactionManager() {
        return new TransactionManager(this.getConnection(), this.moduleId);
    }

    public SearchResult<Transaction> searchTransactionList(SearchParam searchParam) throws Exception {
        SearchResult transactionSearchResult = new SearchResult(searchParam.getPeriod(), searchParam.getPage(), searchParam.getSort());
        this.getTransactionManager().searchTransaction(transactionSearchResult, searchParam);
        return transactionSearchResult;
    }

    public void checkTransactions(int contractId) throws Exception {
        this.getTransactionManager().doCheckRequest(contractId, null);
    }

    public List<String[]> getAutopaymentBindingData(int contractId) throws Exception {
        return null;
    }

    public SearchResult<Autopayment> searchAutopaymentList(int contractId, Period period, String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(period, page, sort);
        AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
        autopaymentManager.searchAutopayment(searchResult, contractId);
        return searchResult;
    }

    public void doManualAutopayment(int contractId, BigDecimal sum) throws BGException {
        if (contractId > 0) {
            this.tryCall(() -> {
                Autopayment autopayment = new AutopaymentManager(this.getConnection(), this.moduleId).getCurrentAutopayment(contractId);
                if (autopayment != null && autopayment.getMode().getCode() == AutopaymentMode.AUTO.getCode() && sum != null) {
                    EventProcessor.getInstance().publish((Event)new MTSbankAutopaymentEvent(this.moduleId, contractId, AutopaymentMode.AUTO.getCode(), sum));
                }
            });
        }
    }

    public Autopayment getAutopaymentCurrentMode(int contractId) throws BGException {
        return (Autopayment)this.tryReturn(() -> new AutopaymentManager(this.getConnection(), this.moduleId).getCurrentAutopayment(contractId));
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws Exception {
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws Exception {
    }
}

