/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.moneta.server.action.apps;

import bitel.billing.server.contract.bean.ContractModuleManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.HashMap;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.apps.server.bean.AppsAbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.modules.moneta.common.bean.Transaction;
import ru.bitel.bgbilling.modules.moneta.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;

public class ActionDoPayment
extends AppsAbstractAction {
    public void execute() throws Exception {
        int moduleId = this.getIntParameter("module_id", -1);
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(moduleId)) {
            throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d.");
        }
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        BigDecimal sum = this.getBigDecimal("amount", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal sumMin = moduleSetup.getBigDecimal("moneta.sum.min", new BigDecimal(100));
        BigDecimal sumMax = moduleSetup.getBigDecimal("moneta.sum.max", new BigDecimal(5000));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
        }
        Contract contract = ContractDao.getContract((Connection)this.con, (int)this.contractId);
        if (contract == null) {
            throw new BGMessageException("Contract don't found!");
        }
        String adress = this.getParameter("customerAddress");
        ContractUtils.saveCustomerAddress((Connection)this.con, (int)moduleId, (int)this.contractId, (String)adress);
        String description = moduleSetup.get("moneta.mnt.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle()).replace("{CONTRACT_COMMENT}", contract.getComment());
        String urlSuccess = moduleSetup.get("moneta.mnt.success.url", "https://mobileapp.redirect.url.ru");
        HashMap<String, Object> payData = new HashMap<String, Object>();
        payData.put("MNT_ID", moduleSetup.get("moneta.mnt.id", ""));
        payData.put("MNT_AMOUNT", sum.toPlainString().replace(',', '.'));
        payData.put("MNT_CURRENCY_CODE", moduleSetup.get("moneta.mnt.currency.code", "RUB"));
        payData.put("MNT_SUBSCRIBER_ID", String.valueOf(this.contractId));
        payData.put("MNT_TEST_MODE", moduleSetup.get("moneta.mnt.test.mode", "0"));
        Transaction transaction = new TransactionManager(this.con, moduleId).doSign(this.contractId, sum, false, moduleSetup.get("moneta.sign.check.code", ""), payData);
        String formUrl = moduleSetup.get("moneta.gate.url", "https://www.moneta.ru/assistant.htm") + "?MNT_ID=" + URLEncoder.encode(String.valueOf(payData.get("MNT_ID")), "UTF-8") + "&MNT_AMOUNT=" + URLEncoder.encode(String.valueOf(payData.get("MNT_AMOUNT")), "UTF-8") + "&MNT_TRANSACTION_ID=" + URLEncoder.encode(String.valueOf(payData.get("MNT_TRANSACTION_ID")), "UTF-8") + "&MNT_CURRENCY_CODE=" + URLEncoder.encode(String.valueOf(payData.get("MNT_CURRENCY_CODE")), "UTF-8") + "&MNT_TEST_MODE=" + URLEncoder.encode(String.valueOf(payData.get("MNT_TEST_MODE")), "UTF-8") + "&MNT_SUBSCRIBER_ID=" + URLEncoder.encode(String.valueOf(payData.get("MNT_SUBSCRIBER_ID")), "UTF-8") + "&MNT_SUCCESS_URL=" + URLEncoder.encode(urlSuccess, "UTF-8") + "&" + (String)(description != null ? "MNT_DESCRIPTION=" + URLEncoder.encode(description, "UTF-8") + "&" : "") + "MNT_SIGNATURE=" + URLEncoder.encode(String.valueOf(payData.get("MNT_SIGNATURE")), "UTF-8");
        if (formUrl != null) {
            this.actionMap.put("urlRedirect", formUrl);
            this.actionMap.put("urlSuccess", urlSuccess + "/?orderId=" + transaction.getTransactionId());
        }
    }
}

