/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobilePushTokenLink;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class MobilePushTokenLinkDao
extends AbstractIdDao<MobilePushTokenLink> {
    public MobilePushTokenLinkDao(Connection con, int moduleId) {
        super(con, "mobile_push_tokens_link", moduleId);
    }

    protected MobilePushTokenLink getFromRS(ResultSet rs) throws SQLException {
        MobilePushTokenLink link = new MobilePushTokenLink();
        link.setId(rs.getInt("id"));
        link.setContractId(rs.getInt("contractId"));
        link.setTokenId(rs.getInt("tokenId"));
        return link;
    }

    protected void updateImpl(MobilePushTokenLink link) throws SQLException {
        Objects.requireNonNull(link);
        boolean update = link.getId() > 0;
        String query = "INSERT INTO " + this.tableName + " SET tokenId=?, contractId=?";
        if (!update) {
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                int index = 0;
                ps.setInt(++index, link.getTokenId());
                ps.setInt(++index, link.getContractId());
                ps.executeUpdate();
                link.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public List<MobilePushTokenLink> getListByContractId(int contractId) throws SQLException {
        return this.list("contractId=?", null, new Object[]{contractId});
    }

    public MobilePushTokenLink getToken(int contractId, int tokenId) throws SQLException {
        return (MobilePushTokenLink)((Object)this.get("contractId=? AND tokenId=?", new Object[]{contractId, tokenId}));
    }
}

