/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductStatus;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;

public class MegafonContractOptionDao
extends AbstractIdDao<MegafonContractOption> {
    public MegafonContractOptionDao(Connection con, int moduleId) {
        super(con, "megafon_contract_option", moduleId);
    }

    public Result<MegafonContractOption> list(Page page, String filter, String orderBy, Object ... params) throws SQLException {
        return super.list(page, filter, orderBy, params);
    }

    protected MegafonContractOption getFromRS(ResultSet rs) throws SQLException {
        MegafonContractOption contractOption = new MegafonContractOption();
        contractOption.setId(rs.getInt("id"));
        contractOption.setOrderId(rs.getLong("order_id"));
        contractOption.setOptionId(rs.getInt("option_id"));
        contractOption.setContractId(rs.getInt("contract_id"));
        contractOption.setContractProductId(rs.getInt("contract_product_id"));
        contractOption.setStartTime(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("start_time")));
        contractOption.setEndTime(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("end_time")));
        contractOption.setStatus(MegafonContractProductStatus.getStatusByCode((int)rs.getInt("status")));
        return contractOption;
    }

    protected void updateImpl(MegafonContractOption contractOption) throws SQLException {
        try (PreparedStatement ps = this.prepareStatement((Id)contractOption, "order_id=?, option_id=?, contract_id=?, contract_product_id=?, start_time=?, end_time=?, status=?");){
            int index = 1;
            ps.setLong(index++, contractOption.getOrderId());
            ps.setInt(index++, contractOption.getOptionId());
            ps.setInt(index++, contractOption.getContractId());
            ps.setInt(index++, contractOption.getContractProductId());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)contractOption.getStartTime()));
            ps.setTimestamp(index++, contractOption.getEndTime() != null ? TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)contractOption.getEndTime()) : null);
            ps.setInt(index++, contractOption.getStatus() != null ? contractOption.getStatus().getStatus() : -1);
            this.executeUpdate((Id)contractOption, index, ps);
        }
    }
}

