/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.client.contract;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDateTime;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProduct;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOptionKit;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonProduct;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonContractService;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGTextDialog;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class MegafonContractProductPanel
extends BGUPanel {
    private MegafonService megafonService;
    private MegafonContractService megafonContractService;
    private BGUTable productTable;
    private ProductTableModel tableModel;
    private List<MegafonProduct> products;
    private BGUPanel.WebServiceHolder<TariffService> tariffService = new BGUPanel.WebServiceHolder((BGUPanel)this, TariffService.class, 0);

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.tableModel = new ProductTableModel();
        this.productTable = new BGUTable((TableModel)((Object)this.tableModel));
        this.productTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    int selectedColumnIndex = MegafonContractProductPanel.this.productTable.getSelectedColumn();
                    if (selectedColumnIndex == 7) {
                        MegafonContractProduct selected = (MegafonContractProduct)MegafonContractProductPanel.this.tableModel.getSelectedRow();
                        if (selected != null && Utils.notBlankString((String)selected.getMnpOrderComment())) {
                            MegafonContractProductPanel.this.createBGTextDialogWindow(selected.getMnpOrderComment());
                        }
                    } else {
                        MegafonContractProductPanel.this.performAction("edit");
                    }
                } else if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1 && MegafonContractProductPanel.this.tableModel.getSelectedRow() != null) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem item = new JMenuItem("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u043f\u0446\u0438\u044e");
                    item.addActionListener(ev -> new ProductOptionDialog((MegafonContractProduct)MegafonContractProductPanel.this.tableModel.getSelectedRow()).open());
                    menu.add(item);
                    menu.show((Component)MegafonContractProductPanel.this.productTable, e.getX(), e.getY());
                }
            }
        });
        BGDialogToolBar toolBar = new BGDialogToolBar();
        BGSwingUtilites.buildToolBar((BGDialogToolBar)toolBar, (JComponent)((Object)this));
        toolBar.compact();
        JButton synchronizeContractProducts = new JButton("\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 \u0441 \u041c\u0435\u0433\u0430\u0444\u043e\u043d");
        synchronizeContractProducts.addActionListener(e -> this.synchronizeContractProducts());
        JButton checkOrderStatus = new JButton("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441\u044b \u0437\u0430\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0445 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 \u0438 \u043e\u043f\u0446\u0438\u0439");
        checkOrderStatus.addActionListener(e -> this.checkOrderStatus());
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add(checkOrderStatus, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add(synchronizeContractProducts, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add(BGSwingUtilites.createHelpLabel((String)"\u041f\u043e \u0434\u0432\u043e\u0439\u043d\u043e\u043c\u0443 \u043a\u043b\u0438\u043a\u0443 \u043d\u0430 \u0441\u0442\u043e\u043b\u0431\u0446\u0435 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u043f\u043e\u043b\u043d\u044b\u0439 \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440", (int)-1), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add(new JScrollPane((Component)this.productTable), new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.performAction("refresh");
    }

    private void checkOrderStatus() {
        try {
            this.megafonContractService.checkOrderStatus();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private void synchronizeContractProducts() {
        JDialog dialog = new JDialog();
        dialog.setDefaultCloseOperation(2);
        dialog.setSize(400, 200);
        JTextField msisdn = new JTextField();
        JTextField additionalMsisdn = new JTextField();
        JButton synchronize = new JButton("\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        synchronize.addActionListener(e -> {
            if (ClientUtils.confirm((String)"\u041f\u0440\u0438 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0437\u0430\u043f\u0440\u043e\u0441 \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 \u041c\u0435\u0433\u0430\u0444\u043e\u043d \u0438 \u0432\u0441\u0435 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b, \u043d\u043e \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0432 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0435 \u0431\u0443\u0434\u0443\u0442 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u044b \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440. \u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044e?", (String)"\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f")) {
                try {
                    this.megafonContractService.synchronizeContractProducts(((ClientContext)this.getContext()).getContractId(), msisdn.getText(), additionalMsisdn.getText());
                    this.performAction("refresh");
                    dialog.dispose();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 MSISDN \u0434\u043b\u044f \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        p.add((Component)msisdn, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        p.add((Component)new JLabel("\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 (\u043f\u043e\u0434\u043c\u0435\u043d\u043d\u044b\u0439) MSISDN (\u0415\u0441\u043b\u0438 MNP!)"), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        p.add((Component)additionalMsisdn, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        p.add((Component)synchronize, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        dialog.add(p);
        dialog.setLocationRelativeTo(null);
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.products = this.getMegafonService().getProductList();
            this.tableModel.setData(this.getMegafonContractService().getContractProductList(null, ((ClientContext)this.getContext()).getContractId(), null).getList());
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new ProductEditorDialog("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", null, (ClientContext)this.getContext()).open()).setIcon((Icon)ClientUtils.getIcon((String)"fugue/present--plus"));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            MegafonContractProduct contractProduct = (MegafonContractProduct)this.tableModel.getSelectedRow();
            if (contractProduct == null) {
                BGToolTip.showErrorMessage((JComponent)this.productTable, (String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442");
            } else {
                new ProductEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438", contractProduct, (ClientContext)this.getContext()).open();
            }
        }).setIcon((Icon)ClientUtils.getIcon((String)"item_edit"));
    }

    private MegafonService getMegafonService() {
        if (this.megafonService == null) {
            this.megafonService = (MegafonService)((ClientContext)this.getContext()).getPort(MegafonService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.megafonService;
    }

    private MegafonContractService getMegafonContractService() {
        if (this.megafonContractService == null) {
            this.megafonContractService = (MegafonContractService)((ClientContext)this.getContext()).getPort(MegafonContractService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.megafonContractService;
    }

    private void createBGTextDialogWindow(String text) {
        BGTextDialog dialog = new BGTextDialog();
        dialog.setModal(true);
        dialog.getTextArea().setEditable(false);
        dialog.getTextArea().setText(text);
        dialog.setVisible(true);
    }

    private final class ProductTableModel
    extends BGTableModel<MegafonContractProduct> {
        public ProductTableModel() {
            super("megafonContractProductTable");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0440\u043e\u0434\u0443\u043a\u0442", -1, -1, -1, "productId", false);
            this.addColumn("MSISDN", -1, 60, -1, "msisdn", false);
            this.addColumn("\u0414\u043e\u043f. MSISDN", -1, 60, -1, "additionalMsisdn", false);
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 60, -1, "status", false);
            this.addColumn("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430", -1, 80, -1, "dateFrom", false);
            this.addColumn("\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f", -1, 80, -1, "dateTo", false);
            this.addColumn("MNP \u043f\u0440\u043e\u0446\u0435\u0441\u0441", -1, 80, -1, "mnpProcessNumber", false);
            this.addColumn("MNP \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "mnpOrderComment", false);
        }

        public Object getValueAt(MegafonContractProduct val, int column) throws Exception {
            return switch (column) {
                case 1 -> MegafonContractProductPanel.this.products.stream().filter(p -> p.getId() == val.getProductId()).findFirst().map(IdTitle::getTitle).orElse("<\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d>");
                case 4 -> {
                    if (val.getStatus() != null) {
                        yield val.getStatus().getComment();
                    }
                    yield "<\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                }
                case 5 -> {
                    if (val.getStartTime() != null) {
                        yield TimeUtils.format((LocalDateTime)val.getStartTime(), (String)"dd.MM.yyyy HH:mm:ss");
                    }
                    yield "";
                }
                case 6 -> {
                    if (val.getEndTime() != null) {
                        yield TimeUtils.format((LocalDateTime)val.getEndTime(), (String)"dd.MM.yyyy HH:mm:ss");
                    }
                    yield "";
                }
                default -> super.getValueAt((Object)val, column);
            };
        }
    }

    private final class ProductEditorDialog
    extends BGEditorDialog<MegafonContractProduct> {
        private final BGUComboBox<MegafonProduct> productsComboBox;
        private final JTextField msisdn;
        private final JTextField additionalMsisdn;
        private final JTextField mnpProcessNumber;
        private final JButton checkAllowActivate;
        private final JTextArea conflicts;
        private final JButton forceActivate;
        private final JPanel activationConflictsInfoPanel;
        private final BGUComboBox<TariffPlan> tariffs;
        private boolean activateIsAllow;
        AbstractBGUPanel.AsyncAction<Window> productActivate;

        public ProductEditorDialog(String title, MegafonContractProduct data, ClientContext context) {
            super(title, (Object)data, context);
            this.productsComboBox = new BGUComboBox();
            this.msisdn = new JTextField();
            this.additionalMsisdn = new JTextField();
            this.mnpProcessNumber = new JTextField();
            this.checkAllowActivate = new JButton("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438");
            this.conflicts = new JTextArea();
            this.forceActivate = new JButton("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e");
            this.tariffs = new BGUComboBox();
            this.activateIsAllow = false;
            this.productActivate = new AbstractBGUPanel.AsyncAction<Window>("", "\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430"){

                protected Window doInBackground() {
                    Window waitwindow = ClientUtils.showWaitWindow((String)"\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430...");
                    try {
                        MegafonContractProduct contractProduct = ProductEditorDialog.this.getProductFromForm();
                        ProductEditorDialog.this.checkMSISDN(contractProduct);
                        MegafonContractProductPanel.this.getMegafonContractService().productActivateRequest(contractProduct);
                    }
                    catch (Exception ex) {
                        waitwindow.dispose();
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                    return waitwindow;
                }

                protected void done(Window result) {
                    if (result != null) {
                        result.dispose();
                    }
                    ProductEditorDialog.this.optionPane.getDialog().dispose();
                    MegafonContractProductPanel.this.performAction("refresh");
                }
            };
            this.productsComboBox.setData(MegafonContractProductPanel.this.products);
            this.loadTariffs();
            this.productsComboBox.addItemListener(e -> this.loadTariffs());
            this.checkAllowActivate.addActionListener(e -> this.checkAllowActivate());
            this.activationConflictsInfoPanel = this.activationConflictsInfoPanel();
            this.activationConflictsInfoPanel.setVisible(false);
            this.forceActivate.addActionListener(e -> this.productActivate.perform());
        }

        public void doDialogPanel() {
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0);
            this.panel.add((Component)new JLabel("\u041f\u0440\u043e\u0434\u0443\u043a\u0442"), constraints);
            this.panel.add((Component)this.productsComboBox, constraints);
            this.panel.add((Component)new JLabel("MSISDN"), constraints);
            this.panel.add((Component)this.msisdn, constraints);
            this.panel.add((Component)new JLabel("\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 MSISDN"), constraints);
            this.panel.add((Component)this.additionalMsisdn, constraints);
            this.panel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430 MNP"), constraints);
            this.panel.add((Component)this.mnpProcessNumber, constraints);
            this.panel.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444"), constraints);
            this.panel.add((Component)this.tariffs, constraints);
            this.panel.add((Component)this.activationConflictsInfoPanel, constraints);
            if (this.data != null) {
                this.productsComboBox.setSelectedItem((Object)this.productsComboBox.getData().stream().filter(p -> p.getId() == ((MegafonContractProduct)this.data).getProductId()).findFirst().get());
                this.msisdn.setText(((MegafonContractProduct)this.data).getMsisdn());
                this.additionalMsisdn.setText(((MegafonContractProduct)this.data).getAdditionalMsisdn());
                this.mnpProcessNumber.setText(((MegafonContractProduct)this.data).getMnpProcessNumber());
                this.loadTariffs();
                this.productsComboBox.setEnabled(false);
                this.msisdn.setEnabled(false);
                this.additionalMsisdn.setEnabled(true);
                this.mnpProcessNumber.setEnabled(true);
            } else {
                this.mnpProcessNumber.setEnabled(false);
            }
        }

        private void loadTariffs() {
            MegafonProduct selectedProduct = (MegafonProduct)this.productsComboBox.getSelectedItem();
            if (selectedProduct == null) {
                return;
            }
            this.tryCall(() -> this.tariffs.setData(((TariffService)MegafonContractProductPanel.this.tariffService.get()).getTariffListByLabelId(selectedProduct.getTariffLabelId())));
        }

        private void checkAllowActivate() {
            try {
                if (MegafonContractProductPanel.this.getMegafonContractService().checkAllowActivateProduct(this.getProductFromForm())) {
                    this.activateIsAllow = true;
                    BGToolTip.showMessage((JComponent)this.checkAllowActivate, (String)"\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430");
                }
            }
            catch (Exception e) {
                this.activateIsAllow = false;
                String error = e.getLocalizedMessage();
                if (!error.contains("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u044b:")) {
                    ClientUtils.showErrorMessageDialog((String)e.getMessage());
                }
                this.conflicts.setText(error);
                this.activationConflictsInfoPanel.setVisible(true);
                this.optionPane.getDialog().pack();
            }
        }

        private MegafonContractProduct getProductFromForm() {
            MegafonContractProduct contractProduct = new MegafonContractProduct();
            contractProduct.setId(this.data != null ? ((MegafonContractProduct)this.data).getId() : 0);
            contractProduct.setMnpProcessNumber(this.data != null ? ((MegafonContractProduct)this.data).getMnpProcessNumber() : null);
            contractProduct.setStatus(this.data != null ? ((MegafonContractProduct)this.data).getStatus() : null);
            contractProduct.setContractId(((ClientContext)MegafonContractProductPanel.this.getContext()).getContractId());
            contractProduct.setProductId(this.productsComboBox.getSelectedItem() != null ? ((MegafonProduct)this.productsComboBox.getSelectedItem()).getId() : -1);
            contractProduct.setMsisdn(Utils.maskNull((String)this.msisdn.getText()).trim());
            contractProduct.setAdditionalMsisdn(Utils.maskNull((String)this.additionalMsisdn.getText()).trim());
            contractProduct.setStartTime(LocalDateTime.now());
            TariffPlan tariffPlan = (TariffPlan)this.tariffs.getSelectedItem();
            contractProduct.setTariffId(tariffPlan == null ? 0 : tariffPlan.getId());
            return contractProduct;
        }

        private JPanel activationConflictsInfoPanel() {
            JPanel p = new JPanel(new GridBagLayout());
            p.add((Component)new JLabel("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u044b \u0438 \u043e\u0448\u0438\u0431\u043a\u0438 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u0438 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            p.add((Component)new JScrollPane(this.conflicts), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            p.add((Component)this.forceActivate, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            p.setPreferredSize(new Dimension(500, 300));
            return p;
        }

        public boolean doApply() throws Exception {
            if (this.data != null) {
                String oldMNPProcessNumber = ((MegafonContractProduct)this.data).getMnpProcessNumber();
                this.data = this.getProductFromForm();
                String newMNPProcessNumber = this.mnpProcessNumber.getText();
                if (Utils.isBlankString((String)oldMNPProcessNumber) && Utils.notBlankString((String)newMNPProcessNumber)) {
                    ((MegafonContractProduct)this.data).setMnpProcessNumber(newMNPProcessNumber);
                }
                if (newMNPProcessNumber != null && !newMNPProcessNumber.equals(oldMNPProcessNumber)) {
                    if (Utils.isBlankString((String)((MegafonContractProduct)this.data).getAdditionalMsisdn())) {
                        BGToolTip.showErrorMessage((JComponent)this.additionalMsisdn, (String)"\u041f\u0440\u0438 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c \u043d\u043e\u043c\u0435\u0440\u0435 MNP \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440");
                        return false;
                    }
                    if (ClientUtils.confirm((String)"\u0411\u044b\u043b \u0437\u0430\u0434\u0430\u043d \u043d\u043e\u043c\u0435\u0440 MNP-\u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430 - \u0431\u0443\u0434\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0440\u0435\u0437\u0435\u0440\u0432 \u043d\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0435 \u0437\u0430 \u043f\u0435\u0440\u0435\u043d\u043e\u0441 \u043d\u043e\u043c\u0435\u0440\u0430. \u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?", (String)"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435")) {
                        int reserveId = MegafonContractProductPanel.this.getMegafonContractService().MNPProcessStart(((MegafonContractProduct)this.data).getContractId(), ((MegafonContractProduct)this.data).getMsisdn(), ((MegafonContractProduct)this.data).getAdditionalMsisdn());
                        ((MegafonContractProduct)this.data).setReserveId(reserveId);
                    }
                }
                MegafonContractProductPanel.this.getMegafonContractService().contractProductUpdate((MegafonContractProduct)this.data);
                this.optionPane.getDialog().dispose();
                MegafonContractProductPanel.this.performAction("refresh");
                return true;
            }
            this.productActivate.perform();
            return true;
        }

        private void checkMSISDN(MegafonContractProduct contractProduct) throws BGException {
            if (Utils.isBlankString((String)contractProduct.getMsisdn())) {
                throw new BGException("\u0414\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u043d\u043e\u043c\u0435\u0440 \u0434\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0438\u043d\u0442\u0435\u0433\u0440\u0430\u0446\u0438\u0438");
            }
            if (this.notValidPhoneFormat(contractProduct.getMsisdn()) || Utils.notBlankString((String)contractProduct.getAdditionalMsisdn()) && this.notValidPhoneFormat(contractProduct.getAdditionalMsisdn())) {
                throw new BGException("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u0438\u043b\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0444\u043e\u0440\u043c\u0430\u0442\u0443 XXXXXXXXXX");
            }
        }

        private boolean notValidPhoneFormat(String phone) {
            return phone == null || !phone.matches("^\\d{10}$");
        }
    }

    private final class ProductOptionDialog
    extends BGEditorDialog<MegafonContractProduct> {
        private final BGUComboBox<MegafonOption> options;

        public ProductOptionDialog(MegafonContractProduct data) {
            super("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0434\u043e\u043f.\u043e\u043f\u0446\u0438\u0438", (Object)data);
            this.options = new BGUComboBox();
            this.init();
        }

        private void init() {
            try {
                MegafonProduct product = MegafonContractProductPanel.this.megafonService.getProduct(((MegafonContractProduct)this.data).getProductId());
                if (product == null) {
                    ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430: \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 productId=" + ((MegafonContractProduct)this.data).getProductId()));
                    return;
                }
                if (product.getOptionKitId() > 0) {
                    MegafonOptionKit kit = MegafonContractProductPanel.this.megafonService.getOptionKit(product.getOptionKitId());
                    if (kit == null) {
                        ClientUtils.showErrorMessageDialog((String)String.format("\u0412 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0435 %s \u0437\u0430\u0434\u0430\u043d \u043d\u0430\u0431\u043e\u0440 \u043e\u043f\u0446\u0438 \u0441 ID=%s, \u043d\u043e \u0442\u0430\u043a\u043e\u0439 \u043d\u0430\u0431\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", product.getId(), product.getOptionKitId()));
                        return;
                    }
                    this.options.setData(kit.getOptions());
                } else {
                    this.options.setData(MegafonContractProductPanel.this.megafonService.getOptionList());
                }
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }

        public void doDialogPanel() {
            GridBagConstraints c = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0);
            this.panel.add((Component)new JLabel("\u041e\u043f\u0446\u0438\u044f \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438:"), c);
            this.panel.add((Component)this.options, c);
        }

        public boolean doApply() throws Exception {
            MegafonOption selectedOption = (MegafonOption)this.options.getSelectedItem();
            if (selectedOption == null) {
                BGToolTip.showErrorMessage(this.options, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e");
                return false;
            }
            if (ClientUtils.confirm((String)String.format("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u043f\u0446\u0438\u044e \"%s\"", selectedOption.getTitle()), (String)"\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043e\u043f\u0446\u0438\u0438")) {
                MegafonContractProductPanel.this.megafonContractService.optionActivateRequest((MegafonContractProduct)this.data, selectedOption);
                return true;
            }
            return false;
        }
    }
}

