/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOptionKit;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonOptionDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class MegafonOptionKitDao
extends AbstractIdDao<MegafonOptionKit> {
    private final MegafonOptionDao optionDao;
    private final String OPTION_KIT_LINK_TABLE;

    public MegafonOptionKitDao(Connection con, int moduleId) {
        super(con, "megafon_option_kit", moduleId);
        this.OPTION_KIT_LINK_TABLE = ServerUtils.getModuleTableName((String)"option_kit_link", (int)moduleId);
        this.optionDao = new MegafonOptionDao(con, moduleId);
    }

    public List<MegafonOptionKit> list(String filter, String orderBy, Object ... params) throws SQLException {
        return super.list(filter, orderBy, params);
    }

    protected MegafonOptionKit getFromRS(ResultSet rs) throws SQLException {
        MegafonOptionKit kit = new MegafonOptionKit();
        kit.setId(rs.getInt("id"));
        kit.setTitle(rs.getString("title"));
        kit.setOptions(this.getOptionsByKitId(kit.getId()));
        return kit;
    }

    private List<MegafonOption> getOptionsByKitId(int kitId) throws SQLException {
        ArrayList<MegafonOption> optionList = new ArrayList<MegafonOption>();
        String query = "SELECT option_id FROM " + this.OPTION_KIT_LINK_TABLE + " WHERE kit_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, kitId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    MegafonOption option = (MegafonOption)this.optionDao.get(rs.getInt("option_id"));
                    if (option == null) continue;
                    optionList.add(option);
                }
            }
        }
        return optionList;
    }

    protected void updateImpl(MegafonOptionKit kit) throws SQLException {
        String querySet = "title=?";
        try (PreparedStatement ps = this.prepareStatement((Id)kit, querySet);){
            int index = 1;
            ps.setString(1, kit.getTitle());
            this.executeUpdate((Id)kit, index, ps);
            this.updateOptionKitLink(kit.getId(), kit.getOptions());
        }
    }

    private void updateOptionKitLink(int kitId, List<MegafonOption> options) throws SQLException {
        if (Utils.notEmptyCollection(options)) {
            PreparedStatement ps;
            String query;
            if (this.needClear(kitId)) {
                query = "DELETE FROM " + this.OPTION_KIT_LINK_TABLE + " WHERE kit_id=?";
                ps = this.con.prepareStatement(query);
                try {
                    ps.setInt(1, kitId);
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            query = "INSERT INTO " + this.OPTION_KIT_LINK_TABLE + " SET kit_id=?, option_id=?";
            ps = this.con.prepareStatement(query);
            try {
                for (MegafonOption option : options) {
                    ps.setInt(1, kitId);
                    ps.setInt(2, option.getId());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    private boolean needClear(int kitId) throws SQLException {
        String query = "SELECT count(*) FROM " + this.OPTION_KIT_LINK_TABLE + " WHERE kit_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            boolean bl;
            block12: {
                ps.setInt(1, kitId);
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }
}

