/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.server.bean;

import bitel.billing.server.tariff.voice.bean.TableManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.CostMap;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.CostMapItem;
import ru.bitel.bgbilling.kernel.base.phone.server.bean.GeographicCodeManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;

public class CostMapManager
extends AbstractDirectoryIdDao<CostMap> {
    private final String itemTableName;
    private final String destTableName;
    private final String codesTableName;
    private PreparedStatement insertItemPS = null;
    private PreparedStatement updateItemPS = null;

    public CostMapManager(Connection con, int mid) {
        super(con, mid, TableManager.getPrefix((Connection)con, (int)mid) + "cost_map");
        String prefix = TableManager.getPrefix((Connection)con, (int)mid);
        this.codesTableName = prefix + "geographic_code_" + mid;
        this.destTableName = prefix + "dest_" + mid;
        this.itemTableName = prefix + "cost_map_item_" + mid;
    }

    @Override
    protected CostMap getFromRS(ResultSet rs) throws SQLException {
        CostMap result = new CostMap();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        return result;
    }

    @Override
    protected void updateImpl(CostMap b) throws SQLException {
        PreparedStatement ps;
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title) VALUES (?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=? WHERE id=?");
            ps.setInt(2, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
        ServerUtils.changeLastModificationTime((Connection)this.con, (String)("zone_map_" + this.moduleId));
    }

    public List<CostMap> list(String orderBy) throws BGException {
        if (orderBy == null) {
            orderBy = "title";
        }
        return this.list(null, orderBy, new Object[0]);
    }

    @Override
    public List<CostMap> list() throws BGException {
        return this.list(null);
    }

    @Override
    public CostMap get(String title) throws BGException {
        return (CostMap)this.get("title=?", title);
    }

    public CostMapItem getTree(int costMapId, boolean destination) throws BGException {
        try {
            CostMapItem root = new CostMapItem();
            root.setCode("");
            if (destination) {
                PreparedStatement ps = this.con.prepareStatement("SELECT item.id, item.code, item.cost, codes.dest_id, dest.title, item.title FROM " + this.itemTableName + " as item LEFT JOIN " + this.codesTableName + " AS codes ON codes.code=item.code LEFT JOIN " + this.destTableName + " AS dest ON dest.id=codes.dest_id WHERE item.map_id=? ORDER BY item.code");
                CostMapItem[] path = new CostMapItem[20];
                String lastCode = root.getCode();
                int level = 0;
                path[level] = root;
                ps.setInt(1, costMapId);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    String currCode = rs.getString(2);
                    CostMapItem code = new CostMapItem();
                    code.setId(rs.getInt(1));
                    code.setCode(currCode);
                    code.setCost(rs.getBigDecimal(3));
                    code.setDestinationId(rs.getInt(4));
                    code.setDestination(rs.getString(5));
                    code.setTitle(rs.getString(6));
                    if (!currCode.startsWith(lastCode)) {
                        while (--level >= 0 && !currCode.startsWith(path[level].getCode())) {
                        }
                    }
                    CostMapItem parent = path[level];
                    parent.addChild(code);
                    path[++level] = code;
                    lastCode = currCode;
                }
                rs.close();
                ps.close();
            } else {
                PreparedStatement ps = this.con.prepareStatement("SELECT item.id, item.code, item.cost FROM " + this.itemTableName + " as item WHERE item.map_id=? ORDER BY item.code");
                CostMapItem[] path = new CostMapItem[20];
                String lastCode = root.getCode();
                int level = 0;
                path[level] = root;
                ps.setInt(1, costMapId);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    String currCode = rs.getString(2);
                    CostMapItem code = new CostMapItem();
                    code.setId(rs.getInt(1));
                    code.setCode(currCode);
                    code.setCost(rs.getBigDecimal(3));
                    if (!currCode.startsWith(lastCode)) {
                        while (--level >= 0 && !currCode.startsWith(path[level].getCode())) {
                        }
                    }
                    CostMapItem parent = path[level];
                    parent.addChild(code);
                    path[++level] = code;
                    lastCode = currCode;
                }
                rs.close();
                ps.close();
            }
            return root;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void updateItem(int costMapId, CostMapItem item) throws BGException {
        try {
            this.updateItemImpl(costMapId, item);
            if (this.updateItemPS != null) {
                this.updateItemPS.close();
                this.updateItemPS = null;
            }
            if (this.insertItemPS != null) {
                this.insertItemPS.close();
                this.insertItemPS = null;
            }
            ServerUtils.changeLastModificationTime((Connection)this.con, (String)("zone_map_" + this.moduleId));
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    private void updateItemImpl(int costMapId, CostMapItem item) throws SQLException {
        if (this.updateItemPS == null) {
            this.updateItemPS = this.con.prepareStatement("UPDATE " + this.itemTableName + " SET cost=?, title=?, comment=? WHERE map_id=? AND code=?");
        }
        this.updateItemPS.setBigDecimal(1, item.getCost());
        this.updateItemPS.setString(2, item.getTitle());
        this.updateItemPS.setString(3, item.getComment());
        this.updateItemPS.setInt(4, costMapId);
        this.updateItemPS.setString(5, item.getCode());
        if (this.updateItemPS.executeUpdate() == 0) {
            if (this.insertItemPS == null) {
                this.insertItemPS = this.con.prepareStatement("INSERT INTO " + this.itemTableName + " (map_id, code, cost, title, comment) VALUES (?,?,?,?,?)");
            }
            this.insertItemPS.setInt(1, costMapId);
            this.insertItemPS.setString(2, item.getCode());
            this.insertItemPS.setBigDecimal(3, item.getCost());
            this.insertItemPS.setString(4, item.getTitle());
            this.insertItemPS.setString(5, item.getComment());
            this.insertItemPS.executeUpdate();
        }
        ServerUtils.changeLastModificationTime((Connection)this.con, (String)("zone_map_" + this.moduleId));
    }

    public void deleteItem(int costMapId, String code) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.itemTableName + " WHERE map_id=? AND code=?");
            ps.setInt(1, costMapId);
            ps.setString(2, code);
            ps.executeUpdate();
            ps.close();
            ServerUtils.changeLastModificationTime((Connection)this.con, (String)("zone_map_" + this.moduleId));
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void importMap(int costMapId, String data, String prfx, boolean update) throws BGException {
        try {
            if (Utils.isBlankString(prfx)) {
                prfx = null;
            }
            ArrayList<CostMapItem> result = new ArrayList<CostMapItem>();
            String[] strings = data.split("\n");
            for (String string : strings) {
                String title;
                BigDecimal cost;
                String[] params = string.split("[\\t]+");
                if (params.length <= 1) continue;
                String comment = null;
                if (params.length > 3) {
                    comment = params[3];
                }
                if (Utils.isBlankString(comment)) {
                    comment = params[0];
                }
                if (params.length > 2) {
                    cost = Utils.parseBigDecimal(params[2].trim().replaceAll(",", "."), null);
                    title = params[1];
                    if (Utils.isBlankString(title)) {
                        title = null;
                    }
                } else {
                    cost = Utils.parseBigDecimal(params[1].trim().replaceAll(",", "."), null);
                    title = null;
                }
                List<String> prefixes = GeographicCodeManager.parsePrefixes(params[0], true);
                for (String prefix : prefixes) {
                    CostMapItem item = new CostMapItem();
                    if (prfx == null) {
                        item.setCode(prefix);
                    } else {
                        item.setCode(prfx + prefix);
                    }
                    item.setCost(cost);
                    item.setTitle(title);
                    item.setComment(params[0]);
                    result.add(item);
                }
            }
            if (!update) {
                PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.itemTableName + " WHERE map_id=?");
                ps.setInt(1, costMapId);
                ps.executeUpdate();
                ps.close();
            }
            for (CostMapItem item : result) {
                this.updateItemImpl(costMapId, item);
            }
            ServerUtils.changeLastModificationTime((Connection)this.con, (String)("zone_map_" + this.moduleId));
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public String exportMap(int costMapId, String code) throws BGException {
        CostMapItem root = this.getTree(costMapId, false);
        if (Utils.notBlankString(code)) {
            root = (CostMapItem)root.findCode(code);
        }
        StringBuilder result = new StringBuilder(100);
        if (root != null) {
            this.exportMap(root, result);
        }
        return result.toString();
    }

    private void exportMap(CostMapItem item, StringBuilder sb) {
        List children = item.getChildren();
        if (children != null) {
            for (CostMapItem child : children) {
                String cost = child.getCost() != null ? child.getCost().toString() : "";
                sb.append(child.getCode()).append("\t").append(Utils.maskNull(child.getTitle())).append("\t").append(cost).append("\t").append(Utils.maskNull(child.getComment())).append("\n");
                this.exportMap(child, sb);
            }
        }
    }
}

