/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.server.service;

import jakarta.jws.WebService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.PersonalTariffManager;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOptionData;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionActivateManager;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.TariffOptionActivateModeDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.TariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.event.TariffOptionListAvailableEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService")
public class TariffOptionServiceImpl
extends AbstractService
implements TariffOptionService {
    private TariffOptionDao tariffOptionDao;
    private ContractLabelManager contractLabelManager;
    private PersonalTariffManager personalTariffManager;
    private ContractTariffOptionDao contractTariffOptionDao;
    private TariffOptionActivateModeDao tariffOptionActivateModeDao;
    private ContractTariffOptionActivateManager contractTariffOptionActivateManager;

    @Override
    public TariffOption tariffOptionGet(int id) throws BGException {
        return (TariffOption)((Object)this.tryReturn(() -> ((TariffOption)this.getTariffOptionDao().get(id)).setActivateModeList(this.getTariffOptionActivateModeDao().getOptionActivateModeList(id, null))));
    }

    @Override
    public List<TariffOption> tariffOptionList() throws BGException {
        return (List)this.tryReturn(() -> this.getTariffOptionDao().list((Date)null));
    }

    @Override
    public List<TariffOption> tariffOptionListAvailable(int contractId, Date date, List<ContractTariffOption> currentContractOptionList, boolean onlyAvailable, boolean web) throws BGException {
        return (List)this.tryReturn(() -> {
            List<TariffOption> result;
            Date onDate = date;
            List<Object> localCurrentContractOptionList = currentContractOptionList;
            if (contractId <= 0) {
                throw new BGIllegalArgumentException();
            }
            if (onDate == null) {
                onDate = new Date();
            }
            if (this.getSetup().getBoolean("tariffOption.dontCheckOnActivateAlreadyActivated", this.getSetup().getBoolean("allow.parallel.option.activate", false))) {
                localCurrentContractOptionList = new ArrayList();
            } else if (localCurrentContractOptionList == null) {
                localCurrentContractOptionList = this.getContractTariffOptionDao().list(contractId, onDate);
            }
            List<TariffOption> fullOptionList = this.getTariffOptionDao().list(onDate);
            HashSet<TariffOption> currentOptionSet = new HashSet<TariffOption>();
            for (ContractTariffOption contractTariffOption : localCurrentContractOptionList) {
                currentOptionSet.add(new TariffOption().setId(contractTariffOption.getOptionId()));
            }
            if (onlyAvailable) {
                fullOptionList.removeAll(currentOptionSet);
            }
            HashSet<Integer> tariffIds = new HashSet<Integer>();
            ContractTariffDao contractTariffDao = new ContractTariffDao(this.getConnection());
            LocalDate localDate = TimeUtils.convertDateToLocalDate((Date)onDate);
            for (ContractTariff contractTariff : contractTariffDao.list(contractId, localDate)) {
                tariffIds.add(contractTariff.getTariffPlanId());
            }
            tariffIds.addAll(this.getPersonalTariffManager().getParentTreeTariffIds(contractId, onDate));
            List<Integer> labelsOnContract = this.getContractLabelManager().getContractLabelIds(contractId);
            for (TariffOption option : fullOptionList) {
                boolean allowOptionForContract;
                if (CollectionUtils.intersection(option.getTariffIdSet(), tariffIds).size() == 0 || Utils.notEmptyCollection(labelsOnContract) && Utils.notEmptyCollection(option.getContractLabels()) && !(allowOptionForContract = option.getContractLabels().stream().filter(labelId -> labelsOnContract.stream().anyMatch(labelId::equals)).findAny().orElse(-1) > 0)) continue;
                if (web) {
                    if (option.isHideForWeb()) continue;
                    if (option.getHideForContractGroupsMode() == 0) {
                        boolean hideThisLabel;
                        boolean bl = hideThisLabel = option.getHideForContractLabels().stream().filter(labelId -> labelsOnContract.stream().anyMatch(labelId::equals)).findAny().orElse(-1) > 0;
                        if (hideThisLabel) {
                            continue;
                        }
                    } else if (!labelsOnContract.containsAll(option.getHideForContractLabels())) continue;
                }
                option.setEnable(true);
            }
            Contract contract = this.getContract(contractId);
            TariffOptionListAvailableEvent availableListEvent = EventProcessor.getInstance().request(new TariffOptionListAvailableEvent(contractId, this.userId, onDate, contract, tariffIds, localCurrentContractOptionList, onlyAvailable, web, fullOptionList));
            fullOptionList = availableListEvent.getTariffOptionList();
            if (onlyAvailable) {
                result = new ArrayList<TariffOption>();
                for (TariffOption option : fullOptionList) {
                    if (!option.isEnable()) continue;
                    result.add(option);
                }
            } else {
                result = fullOptionList;
            }
            for (TariffOption o : result) {
                o.setActivateModeList(this.getTariffOptionActivateModeDao().getOptionActivateModeList(o.getId(), onDate));
            }
            return result;
        });
    }

    @Override
    public List<TariffOption> tariffOptionWebList(int contractId, Date date, List<TariffOption> fullOptionList) throws BGException {
        return (List)this.tryReturn(() -> {
            List<TariffOption> localFullOptionList = fullOptionList;
            if (localFullOptionList == null) {
                localFullOptionList = this.getTariffOptionDao().list(date);
            }
            List<Integer> labelsOnContract = this.getContractLabelManager().getContractLabelIds(contractId);
            ArrayList<TariffOption> result = new ArrayList<TariffOption>();
            for (TariffOption option : localFullOptionList) {
                if (option.isHideForWeb()) continue;
                if (option.getHideForContractGroupsMode() == 0) {
                    boolean hideThisOption;
                    boolean bl = hideThisOption = option.getHideForContractLabels().stream().filter(labelId -> labelsOnContract.stream().anyMatch(labelId::equals)).findAny().orElse(-1) > 0;
                    if (hideThisOption) {
                        continue;
                    }
                } else if (!labelsOnContract.containsAll(option.getHideForContractLabels())) continue;
                result.add(option);
            }
            return result;
        });
    }

    @Override
    public void tariffOptionUpdate(TariffOption option) throws BGException {
        this.tryCall(() -> {
            this.getTariffOptionDao().update((Object)option);
            this.getTariffOptionActivateModeDao().updateTariffOptionActivateModeList(option.getId(), option.getActivateModeList());
        });
    }

    @Override
    public void tariffOptionDelete(int id) throws BGException {
        this.tryCall(() -> {
            List<TariffOptionActivateMode> modeList = Collections.emptyList();
            this.getTariffOptionDao().delete(id);
            this.getTariffOptionActivateModeDao().updateTariffOptionActivateModeList(id, modeList);
        });
    }

    @Override
    public List<TariffOptionActivateMode> tariffOptionActivateModeList(int optionId, Date date) throws BGException {
        if (optionId <= 0) {
            throw new BGIllegalArgumentException();
        }
        return this.getTariffOptionActivateModeDao().getOptionActivateModeList(optionId, date);
    }

    @Override
    public TariffOptionActivateMode tariffOptionActivateModeGet(int optionId, int modeId) throws BGException {
        TariffOption tariffOption = this.tariffOptionGet(optionId);
        List<TariffOptionActivateMode> list = tariffOption.getActivateModeList();
        TariffOptionActivateMode mode = null;
        for (TariffOptionActivateMode activateMode : list) {
            if (activateMode.getId() != modeId) continue;
            mode = activateMode;
            break;
        }
        return mode;
    }

    @Override
    public List<ContractTariffOption> contractTariffOptionList(int contractId, Date date) throws BGException {
        return (List)this.tryReturn(() -> this.getContractTariffOptionDao().list(contractId, date));
    }

    @Override
    public List<ContractTariffOption> contractTariffOptionListWeb(int contractId, Date date, List<ContractTariffOption> list) throws BGException {
        if (list == null || list.size() == 0) {
            list = this.contractTariffOptionList(contractId, date);
        }
        List<TariffOption> visibleOptions = this.tariffOptionWebList(contractId, date, null);
        HashSet<Integer> visibleOptionIds = new HashSet<Integer>();
        for (TariffOption option : visibleOptions) {
            visibleOptionIds.add(option.getId());
        }
        ArrayList<ContractTariffOption> result = new ArrayList<ContractTariffOption>();
        for (ContractTariffOption option : list) {
            if (!visibleOptionIds.contains(option.getOptionId())) continue;
            result.add(option);
        }
        return result;
    }

    @Override
    public void contractTariffOptionActivate(ContractTariffOptionData contractTariffOptionData) throws BGException {
        this.tryCall(() -> this.getContractTariffOptionActivateManager().activateOptionWhithSumAndPeriod(this, this.userId, contractTariffOptionData));
    }

    @Override
    public int contractTariffOptionActivateWhithSum(ContractTariffOptionData contractTariffOptionData) throws BGException {
        return (Integer)this.tryReturn(() -> this.getContractTariffOptionActivateManager().activateOptionWhithSumAndPeriod(this, this.userId, contractTariffOptionData));
    }

    @Override
    public void contractTariffOptionDeactivate(int contractId, int contractOptionId) throws BGException {
        this.tryCall(() -> this.getContractTariffOptionActivateManager().deactivateOption(this.userId, contractId, contractOptionId));
    }

    @Override
    public void contractTariffOptionReactivate(int contractId, int contractOptionId) throws BGException {
        this.tryCall(() -> this.getContractTariffOptionActivateManager().reactivateOption(this.userId, contractId, contractOptionId));
    }

    @Override
    public List<ContractTariffOption> contractTariffOptionHistory(int contractId, Date date, boolean web) throws BGException {
        return (List)this.tryReturn(() -> {
            List<ContractTariffOption> result = this.getContractTariffOptionDao().list(contractId, date, true, true);
            if (web) {
                result = this.contractTariffOptionListWeb(contractId, date, result);
            }
            return result;
        });
    }

    @Override
    public void contractTariffOptionDelete(int contractId, int id, boolean customer) throws BGException {
        this.tryCall(() -> this.getContractTariffOptionActivateManager().deleteOption(this.userId, contractId, id, customer));
    }

    @Override
    public String configOption() throws BGException {
        JSONArray array = new JSONArray();
        Setup moduleSetup = this.getSetup();
        JSONObject jsonObject = new JSONObject().put("name", (Object)"tariffOption.dontCheckOnActivateAlreadyActivated").put("value", moduleSetup.getBoolean("tariffOption.dontCheckOnActivateAlreadyActivated", false));
        array.put((Object)jsonObject);
        return array.toString();
    }

    private TariffOptionDao getTariffOptionDao() {
        this.tariffOptionDao = new TariffOptionDao(this.getConnection());
        return Optional.ofNullable(this.tariffOptionDao).orElse(this.tariffOptionDao);
    }

    private ContractLabelManager getContractLabelManager() {
        this.contractLabelManager = new ContractLabelManager(this.getConnection());
        return Optional.ofNullable(this.contractLabelManager).orElse(this.contractLabelManager);
    }

    private PersonalTariffManager getPersonalTariffManager() {
        this.personalTariffManager = new PersonalTariffManager(this.getConnection());
        return Optional.ofNullable(this.personalTariffManager).orElse(this.personalTariffManager);
    }

    private ContractTariffOptionDao getContractTariffOptionDao() {
        this.contractTariffOptionDao = new ContractTariffOptionDao(this.getConnection());
        return Optional.ofNullable(this.contractTariffOptionDao).orElse(this.contractTariffOptionDao);
    }

    private TariffOptionActivateModeDao getTariffOptionActivateModeDao() {
        this.tariffOptionActivateModeDao = new TariffOptionActivateModeDao(this.getConnection());
        return Optional.ofNullable(this.tariffOptionActivateModeDao).orElse(this.tariffOptionActivateModeDao);
    }

    private ContractTariffOptionActivateManager getContractTariffOptionActivateManager() {
        this.contractTariffOptionActivateManager = new ContractTariffOptionActivateManager(this.getConnection());
        return Optional.ofNullable(this.contractTariffOptionActivateManager).orElse(this.contractTariffOptionActivateManager);
    }
}

