/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.snmp;

import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.SnmpFlowRecord;

public class SnmpFlowArray
extends FlowArray<SnmpFlowRecord> {
    private static Logger logger = LogManager.getLogger();
    private ByteBuffer data = null;
    protected final Map<Integer, SnmpFlowRecord> lastSnmp;
    protected final SnmpFlowRecord.SnmpFlowInput input;
    protected final SnmpFlowRecord.SnmpFlowOutput output;
    private final Calendar calendar = Calendar.getInstance();

    public SnmpFlowArray(ByteBuffer readBuffer, Map<Integer, SnmpFlowRecord> lastSnmp) {
        super((Data[])new SnmpFlowRecord[2]);
        this.lastSnmp = lastSnmp;
        this.input = new SnmpFlowRecord.SnmpFlowInput(lastSnmp);
        this.output = new SnmpFlowRecord.SnmpFlowOutput(lastSnmp);
        ((SnmpFlowRecord[])this.array)[0] = this.input;
        ((SnmpFlowRecord[])this.array)[1] = this.output;
        this.size = 2;
        this.data = readBuffer;
    }

    public final boolean parsePacket(ByteBuffer readBuffer, long millis) {
        this.input.fillData(readBuffer);
        this.input.milliseconds = millis;
        this.output.fillData(readBuffer);
        this.output.milliseconds = millis;
        SnmpFlowRecord snmp = this.lastSnmp.get(this.input.snmpGetInteface());
        if (snmp == null) {
            snmp = new SnmpFlowRecord(null);
            this.lastSnmp.put(this.input.snmpGetInteface(), snmp);
        }
        snmp.fillData(readBuffer);
        snmp.milliseconds = millis;
        this.size = this.input.octets == 0L && this.output.octets == 0L ? 0 : 2;
        return true;
    }

    public int next() {
        return this.next(this.data.position());
    }

    public int next(int offset) {
        logger.trace("next");
        int oldPosition = this.data.position();
        this.data.position(offset);
        long milliseconds = this.data.getLong();
        while (true) {
            this.calendar.setTimeInMillis(milliseconds);
            int yy = this.calendar.get(1);
            this.calendar.setTimeInMillis(this.data.getLong(offset + 8));
            if (this.calendar.get(1) != 2009 && yy >= 2000 && yy <= 2050) break;
            logger.warn("Seems log is corrupted");
            offset += 8;
            milliseconds = this.data.getLong();
        }
        this.input.fillData(this.data);
        this.input.milliseconds = milliseconds;
        this.output.fillData(this.data);
        this.output.milliseconds = milliseconds;
        SnmpFlowRecord snmp = this.lastSnmp.get(this.input.snmpGetInteface());
        if (snmp == null) {
            snmp = new SnmpFlowRecord(null);
            this.lastSnmp.put(this.input.snmpGetInteface(), snmp);
        }
        snmp.fillData(this.data);
        snmp.milliseconds = milliseconds;
        this.data.position(oldPosition);
        this.size = this.input.octets == 0L && this.output.octets == 0L ? 0 : 2;
        return offset + 8 + 68;
    }

    public Map<Integer, SnmpFlowRecord> getLastSnmp() {
        return this.lastSnmp;
    }
}

