/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.server.tariff.TariffModuleTree;

class CacheEntry {
    private static final long MAX_NO_USE_TIME = 1200000L;
    private static final long MAX_LIVE_TIME = 360000000L;
    private TariffModuleTree _tree;
    private long createTime;
    private long lastUse;

    public CacheEntry(TariffModuleTree tree) {
        this._tree = tree;
        this.createTime = System.currentTimeMillis();
        this.lastUse = System.currentTimeMillis();
    }

    public boolean isCoincide(int treeId, int mid) {
        return treeId == this._tree.getTreeId() && mid == this._tree.getMid();
    }

    public TariffModuleTree getTariffModuleTree() {
        this.lastUse = System.currentTimeMillis();
        return this._tree;
    }

    public boolean isOld() {
        long now = System.currentTimeMillis();
        return now - this.lastUse > 1200000L || now - this.createTime > 360000000L;
    }
}

