/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptBackup;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class ScriptBackupManager
extends AbstractIdDao<ScriptBackup> {
    public ScriptBackupManager(Connection con) {
        super(con, "script_backup");
    }

    protected void updateImpl(ScriptBackup scriptBackup) throws SQLException {
        String querySet = "script_id=?, title=?, script=?, user_id=?, comment=?, type=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)scriptBackup, querySet);){
            int index = 1;
            ps.setInt(index++, scriptBackup.getScriptId());
            ps.setString(index++, scriptBackup.getTitle());
            ps.setString(index++, scriptBackup.getScript());
            ps.setInt(index++, scriptBackup.getUserId());
            ps.setString(index++, scriptBackup.getComment());
            ps.setInt(index++, scriptBackup.getType());
            this.executeUpdate((Id)scriptBackup, index, ps);
            scriptBackup.setTimeRevision(((ScriptBackup)this.get(scriptBackup.getId())).getTimeRevision());
        }
        catch (SQLException e) {
            if (e.getSQLState() != null && e.getSQLState().startsWith("23")) {
                throw new SQLException("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            }
            throw e;
        }
    }

    public List<ScriptBackup> list(int scriptId, int type) throws SQLException {
        return this.list("script_id=? AND type=?", "change_time", new Object[]{scriptId, type});
    }

    public void deleteBackups(int scriptId, int type) throws SQLException {
        for (ScriptBackup backup : this.list(scriptId, type)) {
            this.delete(backup.getId());
        }
    }

    protected ScriptBackup getFromRS(ResultSet rs) throws SQLException {
        ScriptBackup result = new ScriptBackup();
        result.setId(rs.getInt("id"));
        result.setScriptId(rs.getInt("script_id"));
        result.setTitle(rs.getString("title"));
        result.setScript(rs.getString("script"));
        result.setUserId(rs.getInt("user_id"));
        result.setTimeRevision(rs.getTimestamp("change_time"));
        result.setComment(rs.getString("comment"));
        result.setType(rs.getInt("type"));
        return result;
    }
}

