/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectParameterGroupAttr;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class ObjectParameterGroupAttrDao
extends AbstractDirectoryIdDao<ObjectParameterGroupAttr> {
    public ObjectParameterGroupAttrDao(Connection con) {
        super(con, 0, "object_param");
    }

    private static int toEntityType(int pt) {
        switch (pt) {
            case 1: {
                return EntitySpecAttrType.TEXT.getCode();
            }
            case 2: {
                return EntitySpecAttrType.LIST.getCode();
            }
            case 3: {
                return EntitySpecAttrType.DATE.getCode();
            }
            case 4: {
                return EntitySpecAttrType.ADDRESS.getCode();
            }
            case 5: {
                return EntitySpecAttrType.BOOLEAN.getCode();
            }
        }
        return 0;
    }

    private static int toParameterType(int entitySpecAttrTypeId) {
        switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)entitySpecAttrTypeId).get()) {
            case TEXT: {
                return 1;
            }
            case LIST: {
                return 2;
            }
            case DATE: {
                return 3;
            }
            case ADDRESS: {
                return 4;
            }
            case BOOLEAN: {
                return 5;
            }
        }
        return 0;
    }

    protected ObjectParameterGroupAttr getFromRS(ResultSet rs) throws SQLException, BGException {
        return (ObjectParameterGroupAttr)ObjectParameterGroupAttr.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setType(ObjectParameterGroupAttrDao.toEntityType(rs.getInt("type"))).setComment(rs.getString("comment")).setHistory(rs.getBoolean("history")).build();
    }

    protected void updateImpl(ObjectParameterGroupAttr objectParameterGroupAttr) throws BGException, SQLException {
        Objects.requireNonNull(objectParameterGroupAttr);
        boolean update = objectParameterGroupAttr.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, type=?, comment=?, history=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, objectParameterGroupAttr.getTitle());
            ps.setInt(index++, ObjectParameterGroupAttrDao.toParameterType(objectParameterGroupAttr.getType()));
            ps.setString(index++, objectParameterGroupAttr.getComment());
            ps.setBoolean(index++, objectParameterGroupAttr.isHistory());
            if (update) {
                ps.setInt(index++, objectParameterGroupAttr.getId());
            }
            ps.executeUpdate();
            if (!update) {
                objectParameterGroupAttr.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    public ObjectParameterGroupAttr get(String title) throws BGException {
        return (ObjectParameterGroupAttr)((Object)super.get("title=?", new Object[]{title}));
    }

    public List<ObjectParameterGroupAttr> list() throws BGException {
        return super.list(null, null, new Object[0]);
    }
}

